/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.config;

import java.util.ArrayList;
import java.util.StringTokenizer;

public final class RetryIntervalls {
    private static final long MS_PER_MIN = 60000L;
    private static final long MS_PER_HOUR = 3600000L;
    private static final long MS_PER_DAY = 86400000L;
    private static final long MS_PER_WEEK = 604800000L;
    private final int[] counts;
    private final long[] intervalls;

    public RetryIntervalls() {
        this.counts = new int[0];
        this.intervalls = new long[0];
    }

    public RetryIntervalls(String text) {
        if (text.trim().equalsIgnoreCase("NEVER")) {
            this.counts = new int[0];
            this.intervalls = new long[0];
        } else {
            try {
                StringTokenizer stk = new StringTokenizer(text, ", \t\n\r");
                this.counts = new int[stk.countTokens()];
                this.intervalls = new long[this.counts.length];
                for (int i = 0; i < this.counts.length; ++i) {
                    this.init(i, stk.nextToken());
                }
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(text);
            }
        }
    }

    private void init(int i, String item) {
        int x = item.indexOf(120);
        this.intervalls[i] = RetryIntervalls.parseInterval(x != -1 ? item.substring(x + 1) : item);
        this.counts[i] = x != -1 ? Math.max(1, Integer.parseInt(item.substring(0, x))) : 1;
    }

    public String toString() {
        if (this.counts.length == 0) {
            return "NEVER";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.counts.length; ++i) {
            sb.append(this.counts[i]).append('x');
            RetryIntervalls.formatInterval(this.intervalls[i], sb).append(',');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public static String formatIntervalZeroAsNever(long ms) {
        return ms == 0L ? "NEVER" : RetryIntervalls.formatInterval(ms);
    }

    public static String formatInterval(long ms) {
        return RetryIntervalls.formatInterval(ms, new StringBuffer()).toString();
    }

    private static StringBuffer formatInterval(long ms, StringBuffer sb) {
        if (ms % 604800000L == 0L) {
            sb.append(ms / 604800000L).append("w");
        } else if (ms % 86400000L == 0L) {
            sb.append(ms / 86400000L).append("d");
        } else if (ms % 3600000L == 0L) {
            sb.append(ms / 3600000L).append("h");
        } else if (ms % 60000L == 0L) {
            sb.append(ms / 60000L).append("m");
        } else {
            sb.append(ms / 1000L).append("s");
        }
        return sb;
    }

    public static long parseIntervalOrNever(String text) {
        return "NEVER".equalsIgnoreCase(text) ? 0L : RetryIntervalls.parseInterval(text);
    }

    public static long parseInterval(String text) {
        int len = text.length();
        long ms = Long.parseLong(text.substring(0, len - 1));
        switch (text.charAt(len - 1)) {
            case 'w': {
                ms *= 7L;
            }
            case 'd': {
                ms *= 24L;
            }
            case 'h': {
                ms *= 60L;
            }
            case 'm': {
                ms *= 60L;
            }
            case 's': {
                break;
            }
            default: {
                throw new IllegalArgumentException("interval: " + text);
            }
        }
        return ms *= 1000L;
    }

    public long getIntervall(int failureCount) {
        int countDown = failureCount;
        for (int i = 0; i < this.counts.length; ++i) {
            if ((countDown -= this.counts[i]) > 0) continue;
            return this.intervalls[i];
        }
        return -1L;
    }

    public static final class Map {
        private final ArrayList<String> keys = new ArrayList();
        private final ArrayList<RetryIntervalls> values = new ArrayList();
        private RetryIntervalls defval = null;

        public Map(String s) {
            StringTokenizer st = new StringTokenizer(s, ";\r\n");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                int pos = token.indexOf(93);
                if (pos > 0) {
                    this.keys.add(token.substring(1, pos));
                    this.values.add(new RetryIntervalls(token.substring(pos + 1)));
                    continue;
                }
                this.defval = new RetryIntervalls(token);
            }
            this.keys.trimToSize();
            this.values.trimToSize();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            int size = this.keys.size();
            for (int i = 0; i < size; ++i) {
                sb.append('[').append(this.keys.get(i)).append(']').append(this.values.get(i)).append('\n');
            }
            if (this.defval != null) {
                sb.append(this.defval).append('\n');
            }
            return sb.toString();
        }

        public long getIntervall(String key, int failureCount) {
            int index = this.keys.indexOf(key);
            RetryIntervalls val = index >= 0 ? this.values.get(index) : this.defval;
            return val != null ? val.getIntervall(failureCount) : -1L;
        }
    }
}

