/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Map;
import java.util.StringTokenizer;
import org.dcm4cheri.util.StringUtils;
import org.dcm4chex.archive.config.Condition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForwardingRules {
    static final String NONE = "NONE";
    static final String[] EMPTY = new String[0];
    private final ArrayList list = new ArrayList();

    public ForwardingRules(String s) {
        StringTokenizer stk = new StringTokenizer(s, "\r\n;");
        while (stk.hasMoreTokens()) {
            String tk = stk.nextToken().trim();
            if (tk.length() == 0) continue;
            try {
                int endCond = tk.indexOf(93) + 1;
                Condition cond = new Condition(tk.substring(0, endCond));
                String second = tk.substring(endCond);
                String[] aets = second.length() == 0 || NONE.equalsIgnoreCase(second) ? EMPTY : StringUtils.split(second, ',');
                for (int i = 0; i < aets.length; ++i) {
                    ForwardingRules.checkAET(aets[i]);
                }
                this.list.add(new Entry(cond, aets));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(tk);
            }
        }
    }

    private static void checkAET(String s) {
        int delim = (s = ForwardingRules.withoutPriority(s)).lastIndexOf(33);
        if (delim == -1) {
            return;
        }
        int hypen = s.lastIndexOf(45);
        int start = Integer.parseInt(s.substring(delim + 1, hypen));
        int end = Integer.parseInt(s.substring(hypen + 1));
        if (start < 0 || end > 24) {
            throw new IllegalArgumentException();
        }
    }

    private static String withoutPriority(String s) {
        return s.endsWith("{LOW}") ? s.substring(0, s.length() - 5) : (s.endsWith("{HIGH}") ? s.substring(0, s.length() - 6) : (s.endsWith("{MEDIUM}") ? s.substring(0, s.length() - 8) : s));
    }

    public static int toPriority(String s, int defPriority) {
        return s.endsWith("{LOW}") ? 2 : (s.endsWith("{HIGH}") ? 1 : (s.endsWith("{MEDIUM}") ? 0 : defPriority));
    }

    public static String toAET(String s) {
        int delim = s.lastIndexOf(33);
        return delim > 0 || (delim = s.lastIndexOf(123)) > 0 ? s.substring(0, delim) : s;
    }

    public static long toScheduledTime(String s) {
        int delim = (s = ForwardingRules.withoutPriority(s)).lastIndexOf(33);
        return delim == -1 ? 0L : ForwardingRules.afterBusinessHours(Calendar.getInstance(), s.substring(delim + 1));
    }

    public static long afterBusinessHours(Calendar cal, String businessHours) {
        boolean delay;
        boolean sameDay;
        int hypen = businessHours.lastIndexOf(45);
        int notAfterHour = Integer.parseInt(businessHours.substring(0, hypen));
        int notBeforeHour = Integer.parseInt(businessHours.substring(hypen + 1));
        int hour = cal.get(11);
        boolean bl = sameDay = notAfterHour <= notBeforeHour;
        boolean bl2 = sameDay ? hour >= notAfterHour && hour < notBeforeHour : (delay = hour >= notAfterHour || hour < notBeforeHour);
        if (!delay) {
            return 0L;
        }
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, notBeforeHour);
        if (!sameDay && hour >= notAfterHour) {
            cal.add(5, 1);
        }
        return cal.getTimeInMillis();
    }

    public String[] getForwardDestinationsFor(Map<String, String[]> param) {
        ArrayList<String> l = new ArrayList<String>();
        for (Entry e : this.list) {
            if (!e.condition.isTrueFor(param) || e.forwardAETs.length <= 0) continue;
            l.addAll(Arrays.asList(e.forwardAETs));
        }
        if (l.isEmpty()) {
            return EMPTY;
        }
        return l.toArray(new String[l.size()]);
    }

    public String toString() {
        String newline = System.getProperty("line.separator", "\n");
        if (this.list.isEmpty()) {
            return newline;
        }
        StringBuffer sb = new StringBuffer();
        for (Entry e : this.list) {
            e.condition.toStringBuffer(sb);
            if (e.forwardAETs.length == 0) {
                sb.append(NONE);
            } else {
                for (int i = 0; i < e.forwardAETs.length; ++i) {
                    sb.append(e.forwardAETs[i]).append(',');
                }
                sb.setLength(sb.length() - 1);
            }
            sb.append(newline);
        }
        return sb.toString();
    }

    public static final class Entry {
        final Condition condition;
        final String[] forwardAETs;

        Entry(Condition condition, String[] forwardAETs) {
            this.condition = condition;
            this.forwardAETs = forwardAETs;
        }
    }
}

