/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.config;

import java.util.Calendar;
import java.util.StringTokenizer;
import org.dcm4chex.archive.config.DeleterThreshold;
import org.dcm4chex.archive.util.FileUtils;

public class DeleterThresholds {
    private final DeleterThreshold[] thresholds;

    public DeleterThresholds(String spec, boolean timeBased) {
        StringTokenizer stk = new StringTokenizer(spec, ":;, \t\r\n");
        int n = stk.countTokens();
        if (n == 0 || (n & 1) != 0) {
            throw new IllegalArgumentException(spec);
        }
        this.thresholds = new DeleterThreshold[n / 2];
        try {
            for (int i = 0; i < this.thresholds.length; ++i) {
                int last;
                int hour = Integer.parseInt(stk.nextToken());
                String sizeOrHours = stk.nextToken();
                if (sizeOrHours.charAt(last = sizeOrHours.length() - 1) == 'h') {
                    if (!timeBased) {
                        throw new IllegalArgumentException();
                    }
                    this.thresholds[i] = new DeleterThreshold.TimeBased(hour, Integer.parseInt(sizeOrHours.substring(0, last)));
                    continue;
                }
                this.thresholds[i] = new DeleterThreshold.SizeBased(hour, FileUtils.parseSize(sizeOrHours, 0L));
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(spec);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.thresholds.length; ++i) {
            sb.append(this.thresholds[i]).append(';');
        }
        return sb.substring(0, sb.length() - 1);
    }

    public DeleterThreshold getDeleterThreshold(Calendar now) {
        if (this.thresholds.length == 1) {
            return this.thresholds[0];
        }
        int hourOfDay = now.get(11);
        if (hourOfDay > this.thresholds[0].getStartHour()) {
            for (int i = 1; i < this.thresholds.length; ++i) {
                if (hourOfDay >= this.thresholds[i].getStartHour()) continue;
                return this.thresholds[i - 1];
            }
        }
        return this.thresholds[this.thresholds.length - 1];
    }
}

