/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.config;

import org.dcm4chex.archive.util.FileUtils;

public abstract class DeleterThreshold
implements Comparable {
    protected int startHour;

    private DeleterThreshold(int startHour) {
        if (startHour < 0 || startHour > 23) {
            throw new IllegalArgumentException();
        }
        this.startHour = startHour;
    }

    public final int getStartHour() {
        return this.startHour;
    }

    public int compareTo(Object o) {
        return this.startHour - ((DeleterThreshold)o).startHour;
    }

    public abstract long getFreeSize(long var1);

    public static class TimeBased
    extends DeleterThreshold {
        private int freeHours;

        TimeBased(int startHour, int freeHours) {
            super(startHour);
            if (freeHours <= 0) {
                throw new IllegalArgumentException();
            }
            this.freeHours = freeHours;
        }

        public final int getFreeHours() {
            return this.freeHours;
        }

        public String toString() {
            return "" + this.startHour + ":" + this.freeHours + "h";
        }

        public long getFreeSize(long expectedDataVolumePerDay) {
            return expectedDataVolumePerDay * (long)this.freeHours / 24L;
        }
    }

    public static class SizeBased
    extends DeleterThreshold {
        private long freeSize;

        SizeBased(int startHour, long freeSize) {
            super(startHour);
            if (freeSize <= 0L) {
                throw new IllegalArgumentException();
            }
            this.freeSize = freeSize;
        }

        public final long getFreeSize() {
            return this.freeSize;
        }

        public String toString() {
            return "" + this.startHour + ":" + FileUtils.formatSize(this.freeSize);
        }

        public long getFreeSize(long expectedDataVolumePerDay) {
            return this.freeSize;
        }
    }
}

