/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.config;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Condition {
    private static final int EXPECT_KEY = 0;
    private static final int EXPECT_EQUAL = 1;
    private static final int EXPECT_VALUE = 2;
    private static final int EXPECT_DELIM = 3;
    private static final String DELIM = "=|,]";
    private LinkedHashMap map = new LinkedHashMap();

    private static boolean isDelim(String s) {
        return s.length() == 1 && DELIM.indexOf(s.charAt(0)) != -1;
    }

    public Condition(String spec) {
        if (!spec.startsWith("[") || !spec.endsWith("]") || spec.length() == 2) {
            return;
        }
        StringTokenizer stk = new StringTokenizer(spec.substring(1), DELIM, true);
        String key = null;
        int state = 0;
        while (true) {
            String tk;
            try {
                tk = stk.nextToken();
            }
            catch (NoSuchElementException e) {
                throw new IllegalArgumentException(spec);
            }
            switch (state) {
                case 0: {
                    if (Condition.isDelim(tk)) {
                        throw new IllegalArgumentException(spec);
                    }
                    key = tk;
                    state = 1;
                    break;
                }
                case 1: {
                    if (!"=".equals(tk)) {
                        throw new IllegalArgumentException(spec);
                    }
                    state = 2;
                    break;
                }
                case 2: {
                    if (Condition.isDelim(tk)) {
                        throw new IllegalArgumentException(spec);
                    }
                    this.put(key, tk);
                    state = 3;
                    break;
                }
                case 3: {
                    if ("|".equals(tk)) {
                        state = 2;
                        break;
                    }
                    if (",".equals(tk)) {
                        state = 0;
                        break;
                    }
                    if (!"]".equals(tk)) break;
                    return;
                }
            }
        }
    }

    private void put(String key, String val) {
        LinkedHashSet<String> set = (LinkedHashSet<String>)this.map.get(key);
        if (set == null) {
            set = new LinkedHashSet<String>();
            this.map.put(key, set);
        }
        set.add(val);
    }

    public boolean isAlwaysTrue() {
        return this.map.isEmpty();
    }

    public boolean isTrueFor(Map<String, String[]> param) {
        for (Map.Entry<String, String[]> entry : param.entrySet()) {
            String key = entry.getKey();
            String[] val = entry.getValue();
            LinkedHashSet set = (LinkedHashSet)this.map.get(key);
            if (set != null && !this.containsAny(set, val)) {
                return false;
            }
            LinkedHashSet antiset = (LinkedHashSet)this.map.get(key + '!');
            if (antiset == null || !this.containsAny(antiset, val)) continue;
            return false;
        }
        return true;
    }

    private boolean containsAny(LinkedHashSet set, String[] val) {
        if (val != null) {
            for (int i = 0; i < val.length; ++i) {
                if (!set.contains(val[i])) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.toStringBuffer(new StringBuffer()).toString();
    }

    public StringBuffer toStringBuffer(StringBuffer sb) {
        if (this.map.isEmpty()) {
            return sb;
        }
        sb.append('[');
        for (Map.Entry entry : this.map.entrySet()) {
            sb.append(entry.getKey()).append('=');
            LinkedHashSet set = (LinkedHashSet)entry.getValue();
            Iterator values = set.iterator();
            while (values.hasNext()) {
                sb.append(values.next()).append('|');
            }
            sb.setCharAt(sb.length() - 1, ',');
        }
        sb.setCharAt(sb.length() - 1, ']');
        return sb;
    }
}

