/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.net.Association;
import org.dcm4chex.archive.codec.CompressCmd;
import org.dcm4chex.archive.codec.CompressionFailedException;
import org.dcm4chex.archive.config.Condition;

public class CompressionRules {
    static final Logger LOG = Logger.getLogger(CompressionRules.class);
    static final int NONE = 0;
    static final int J2LL = 1;
    static final int JLSL = 2;
    static final int J2KR = 3;
    static final int JPLY = 4;
    static final String[] CODES = new String[]{"NONE", "JPLL", "JLSL", "J2KR", "JPLY"};
    static final String[] TSUIDS = new String[]{null, "1.2.840.10008.1.2.4.70", "1.2.840.10008.1.2.4.80", "1.2.840.10008.1.2.4.90", "1.2.840.10008.1.2.4.50"};
    private final ArrayList list = new ArrayList();

    public CompressionRules(String s) {
        StringTokenizer stk = new StringTokenizer(s, "\r\n;");
        while (stk.hasMoreTokens()) {
            String tk = stk.nextToken().trim();
            if (tk.length() == 0) continue;
            try {
                int compression;
                int endCond = tk.indexOf(93) + 1;
                Condition cond = new Condition(tk.substring(0, endCond));
                String codec = tk.substring(endCond);
                float quality = 0.75f;
                float ratio = 5.0f;
                String derivationDescription = "JPEG Lossy Compression with quality=0.75";
                if (codec.startsWith("JPLY(")) {
                    if (!codec.endsWith(")")) {
                        throw new IllegalArgumentException();
                    }
                    int endQuality = codec.indexOf(58);
                    if (endQuality == -1) {
                        throw new IllegalArgumentException();
                    }
                    int endDesc = codec.indexOf(58, endQuality + 1);
                    if (endDesc == -1) {
                        throw new IllegalArgumentException();
                    }
                    compression = 4;
                    quality = Float.parseFloat(codec.substring(5, endQuality));
                    derivationDescription = codec.substring(endQuality + 1, endDesc);
                    ratio = Float.parseFloat(codec.substring(endDesc + 1, codec.length() - 1));
                } else {
                    compression = Arrays.asList(CODES).indexOf(codec);
                    if (compression == -1) {
                        throw new IllegalArgumentException();
                    }
                }
                this.list.add(new Entry(cond, compression, quality, derivationDescription, ratio));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(tk);
            }
        }
    }

    public CompressCmd getCompressFor(Association assoc, Dataset ds) {
        HashMap<String, String[]> param = new HashMap<String, String[]>();
        param.put("calling", new String[]{assoc.getCallingAET()});
        param.put("called", new String[]{assoc.getCalledAET()});
        if (ds != null) {
            this.putIntoIfNotNull(param, "cuid", ds, 524310);
            this.putIntoIfNotNull(param, "pmi", ds, 2621444);
            this.putIntoIfNotNull(param, "imgtype", ds, 524296);
            this.putIntoIfNotNull(param, "bodypart", ds, 1572885);
        }
        for (Entry e : this.list) {
            if (!e.condition.isTrueFor(param)) continue;
            try {
                return e.compression == 0 ? null : (e.compression == 4 ? CompressCmd.createJPEGLossyCompressCmd(ds, e.quality, e.derivationDescription, e.ratio, null, null) : CompressCmd.createCompressCmd(ds, TSUIDS[e.compression]));
            }
            catch (CompressionFailedException e1) {
                LOG.info((Object)e1.getMessage());
            }
        }
        return null;
    }

    private void putIntoIfNotNull(Map param, String key, Dataset ds, int tag) {
        String[] val = ds.getStrings(tag);
        if (val != null && val.length != 0) {
            param.put(key, val);
        }
    }

    public String toString() {
        String newline = System.getProperty("line.separator", "\n");
        if (this.list.isEmpty()) {
            return newline;
        }
        StringBuffer sb = new StringBuffer();
        for (Entry e : this.list) {
            e.condition.toStringBuffer(sb);
            sb.append(CODES[e.compression]);
            if (e.compression == 4) {
                sb.append('(').append(e.quality).append(':').append(e.derivationDescription).append(':').append(e.ratio).append(')');
            }
            sb.append(newline);
        }
        return sb.toString();
    }

    private static final class Entry {
        final Condition condition;
        final int compression;
        final float quality;
        final String derivationDescription;
        final float ratio;

        Entry(Condition condition, int compression, float quality, String derivationDescription, float ratio) {
            this.condition = condition;
            this.compression = compression;
            this.quality = quality;
            this.derivationDescription = derivationDescription;
            this.ratio = ratio;
        }
    }
}

