/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.codec;

import EDU.oswego.cs.dl.util.concurrent.FIFOSemaphore;
import com.sun.media.imageio.stream.SegmentedImageInputStream;
import com.sun.media.imageio.stream.StreamSegmentMapper;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmEncodeParam;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.data.DcmParser;
import org.dcm4che.data.DcmParserFactory;
import org.dcm4che.data.FileFormat;
import org.dcm4che.data.FileMetaInfo;
import org.dcm4che.util.BufferedOutputStream;
import org.dcm4cheri.image.ImageReaderFactory;
import org.dcm4cheri.image.ItemParser;
import org.dcm4cheri.imageio.plugins.PatchJpegLSImageInputStream;
import org.dcm4chex.archive.codec.CodecCmd;

public class DecompressCmd
extends CodecCmd {
    private static final String J2KIMAGE_READER = "com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReader";
    private final boolean clampPixelValue;
    private final ItemParser itemParser;
    private final ImageInputStream iis;
    private int[] simpleFrameList;
    private static int maxConcurrentDecompress = 1;
    private static FIFOSemaphore decompressSemaphore = new FIFOSemaphore((long)maxConcurrentDecompress);
    private static AtomicInteger nrOfConcurrentDecompress = new AtomicInteger();
    private static int[] OFF_0 = new int[]{0};
    private static int[] OFF_0_0_0 = new int[]{0, 0, 0};
    private static int[] OFF_0_1_2 = new int[]{0, 1, 2};

    public static void setMaxConcurrentDecompression(int maxConcurrentDecompress) {
        decompressSemaphore = new FIFOSemaphore((long)maxConcurrentDecompress);
        DecompressCmd.maxConcurrentDecompress = maxConcurrentDecompress;
    }

    public static int getMaxConcurrentDecompression() {
        return maxConcurrentDecompress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decompressFile(File inFile, File outFile, String outTS, int planarConfiguration, int pxdataVR, byte[] buffer) throws Exception {
        byte[] byArray;
        log.info((Object)("M-READ file:" + inFile));
        FileImageInputStream fiis = new FileImageInputStream(inFile);
        try {
            DcmParser parser = DcmParserFactory.getInstance().newDcmParser(fiis);
            DcmObjectFactory dof = DcmObjectFactory.getInstance();
            Dataset ds = dof.newDataset();
            parser.setDcmHandler(ds.getDcmHandler());
            parser.parseDcmFile(FileFormat.DICOM_FILE, 2145386512);
            log.info((Object)("M-WRITE file:" + outFile));
            MessageDigest md = MessageDigest.getInstance("MD5");
            DigestOutputStream dos = new DigestOutputStream(new FileOutputStream(outFile), md);
            BufferedOutputStream bos = new BufferedOutputStream(dos, buffer);
            try {
                DcmEncodeParam encParam = DcmEncodeParam.valueOf(outTS);
                String inTS = DecompressCmd.getTransferSyntax(ds);
                DecompressCmd.adjustPhotometricInterpretation(ds, inTS);
                if (planarConfiguration >= 0 && ds.contains(2621446)) {
                    ds.putUS(2621446, planarConfiguration);
                }
                DecompressCmd cmd = new DecompressCmd(ds, inTS, parser);
                int len = cmd.getPixelDataLength();
                FileMetaInfo fmi = dof.newFileMetaInfo(ds, outTS);
                ds.setFileMetaInfo(fmi);
                ds.writeFile(bos, encParam);
                ds.writeHeader(bos, encParam, 2145386512, pxdataVR, len + 1 & 0xFFFFFFFE);
                try {
                    cmd.decompress(encParam.byteOrder, bos);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new RuntimeException("Decompression failed:", e);
                }
                if ((len & 1) != 0) {
                    bos.write(0);
                }
                parser.parseDataset(parser.getDcmDecodeParam(), -1);
                ds.subSet(2145386512, -1).writeDataset(bos, encParam);
                Object var20_20 = null;
            }
            catch (Throwable throwable) {
                Object var20_21 = null;
                bos.close();
                throw throwable;
            }
            bos.close();
            byArray = md.digest();
            Object var22_23 = null;
        }
        catch (Throwable throwable) {
            Object var22_24 = null;
            try {
                fiis.close();
            }
            catch (IOException ignore) {}
            throw throwable;
        }
        try {
            fiis.close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        return byArray;
    }

    public static String getTransferSyntax(Dataset ds) {
        FileMetaInfo fmi = ds.getFileMetaInfo();
        return fmi != null ? fmi.getTransferSyntaxUID() : "1.2.840.10008.1.2";
    }

    public DecompressCmd(Dataset ds, String tsuid, DcmParser parser) throws IOException {
        super(ds, tsuid);
        this.clampPixelValue = this.pixelRepresentation == 0 && this.bitsAllocated == 16 && this.bitsStored < 12 && "1.2.840.10008.1.2.4.51".equals(tsuid);
        this.iis = parser.getImageInputStream();
        this.itemParser = new ItemParser(parser, this.frames, tsuid);
    }

    public static void adjustPhotometricInterpretation(Dataset ds, String tsOrig) {
        String pmi = ds.getString(2621444, "MONOCHROME2");
        if (pmi.startsWith("YBR") && (tsOrig.equals("1.2.840.10008.1.2.4.50") || tsOrig.equals("1.2.840.10008.1.2.4.51") || tsOrig.equals("1.2.840.10008.1.2.4.90") || tsOrig.equals("1.2.840.10008.1.2.4.91"))) {
            ds.putCS(2621444, "RGB");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decompress(ByteOrder byteOrder, OutputStream out) throws Exception {
        boolean semaphoreAquired;
        long t1;
        block12: {
            t1 = System.currentTimeMillis();
            ImageReader reader = null;
            BufferedImage bi = null;
            boolean patchJpegLS = false;
            semaphoreAquired = false;
            try {
                String patchJAIJpegLS;
                semaphoreAquired = DecompressCmd.acquireSemaphore();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("codec semaphore acquired after " + (System.currentTimeMillis() - t1) + "ms!"));
                }
                log.info((Object)("start decompression of image: " + this.rows + "x" + this.columns + "x" + this.frames + " (current codec tasks: compress&decompress:" + nrOfConcurrentCodec.get() + " decompress:" + nrOfConcurrentDecompress.get() + ")"));
                t1 = System.currentTimeMillis();
                ImageReaderFactory f = ImageReaderFactory.getInstance();
                reader = f.getReaderForTransferSyntax(this.tsuid);
                if (this.bitsAllocated == 16 && "1.2.840.10008.1.2.4.80".equals(this.tsuid) && (patchJAIJpegLS = f.patchJAIJpegLS()) != null) {
                    patchJpegLS = patchJAIJpegLS.length() == 0 || patchJAIJpegLS.equals(this.implClassUID);
                }
                bi = this.getBufferedImage();
                int n = this.getNumberOfFrames();
                for (int i = 0; i < n; ++i) {
                    int frame = this.simpleFrameList != null ? this.simpleFrameList[i] - 1 : i;
                    log.debug((Object)("start decompression of frame #" + (frame + 1)));
                    SegmentedImageInputStream siis = new SegmentedImageInputStream(this.iis, (StreamSegmentMapper)this.itemParser);
                    this.itemParser.seekFrame(siis, frame);
                    reader.setInput(patchJpegLS ? new PatchJpegLSImageInputStream((ImageInputStream)siis) : siis);
                    ImageReadParam param = reader.getDefaultReadParam();
                    param.setDestination(bi);
                    bi = reader.read(0, param);
                    if (reader.getClass().getName().startsWith(J2KIMAGE_READER)) {
                        reader.dispose();
                        reader = i < n - 1 ? f.getReaderForTransferSyntax(this.tsuid) : null;
                    } else {
                        reader.reset();
                    }
                    this.write(bi.getRaster(), out, byteOrder);
                }
                this.itemParser.seekFooter();
                Object var16_15 = null;
                if (reader != null) {
                    reader.dispose();
                }
                if (bi == null) break block12;
                biPool.returnBufferedImage(bi);
            }
            catch (Throwable throwable) {
                Object var16_16 = null;
                if (reader != null) {
                    reader.dispose();
                }
                if (bi != null) {
                    biPool.returnBufferedImage(bi);
                }
                long t2 = System.currentTimeMillis();
                DecompressCmd.finished();
                log.info((Object)("finished decompression in " + (t2 - t1) + "ms." + " (remaining codec tasks: compress&decompress:" + nrOfConcurrentCodec + " decompress:" + nrOfConcurrentDecompress + ")"));
                if (semaphoreAquired) {
                    DecompressCmd.releaseSemaphore();
                }
                throw throwable;
            }
        }
        long t2 = System.currentTimeMillis();
        DecompressCmd.finished();
        log.info((Object)("finished decompression in " + (t2 - t1) + "ms." + " (remaining codec tasks: compress&decompress:" + nrOfConcurrentCodec + " decompress:" + nrOfConcurrentDecompress + ")"));
        if (semaphoreAquired) {
            DecompressCmd.releaseSemaphore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean acquireSemaphore() throws InterruptedException {
        boolean success;
        block4: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"acquire codec semaphore");
                log.debug((Object)("#####codecSemaphore.permits():" + codecSemaphore.permits()));
                log.debug((Object)("#####decompressSemaphore.permits():" + decompressSemaphore.permits()));
            }
            success = false;
            codecSemaphore.acquire();
            try {
                decompressSemaphore.acquire();
                success = true;
                nrOfConcurrentDecompress.incrementAndGet();
                Object var2_1 = null;
                if (success) break block4;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (!success) {
                    codecSemaphore.release();
                    throw throwable;
                }
                nrOfConcurrentCodec.incrementAndGet();
                throw throwable;
            }
            codecSemaphore.release();
            return success;
        }
        nrOfConcurrentCodec.incrementAndGet();
        return success;
    }

    public static void finished() {
        log.debug((Object)"finished: decrement nrOfConcurrentCodec and nrOfConcurrentDecompress");
        nrOfConcurrentCodec.decrementAndGet();
        nrOfConcurrentDecompress.decrementAndGet();
    }

    public static void releaseSemaphore() {
        decompressSemaphore.release();
        codecSemaphore.release();
    }

    public static int getNrOfConcurrentCodec() {
        return nrOfConcurrentCodec.get();
    }

    public static int getNrOfConcurrentDecompress() {
        return nrOfConcurrentDecompress.get();
    }

    private void write(WritableRaster raster, OutputStream out, ByteOrder byteOrder) throws IOException {
        DataBuffer buffer = raster.getDataBuffer();
        ComponentSampleModel sm = (ComponentSampleModel)raster.getSampleModel();
        this.checkSampleModel(sm);
        int stride = sm.getScanlineStride();
        int h = raster.getHeight();
        int w = raster.getWidth();
        int numBands = sm.getNumBands();
        int numBanks = buffer.getNumBanks();
        int l = w * numBands / numBanks;
        block5: for (int b = 0; b < numBanks; ++b) {
            switch (buffer.getDataType()) {
                case 0: {
                    int i;
                    for (i = 0; i < h; ++i) {
                        out.write(((DataBufferByte)buffer).getData(b), i * stride, l);
                    }
                    continue block5;
                }
                case 1: {
                    int i;
                    if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                        for (i = 0; i < h; ++i) {
                            this.writeShortLE(((DataBufferUShort)buffer).getData(b), i * stride, l, out);
                        }
                        continue block5;
                    }
                    for (i = 0; i < h; ++i) {
                        this.writeShortBE(((DataBufferUShort)buffer).getData(b), i * stride, l, out);
                    }
                    continue block5;
                }
                case 2: {
                    int i;
                    if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                        for (i = 0; i < h; ++i) {
                            this.writeShortLE(((DataBufferShort)buffer).getData(b), i * stride, l, out);
                        }
                        continue block5;
                    }
                    for (i = 0; i < h; ++i) {
                        this.writeShortBE(((DataBufferShort)buffer).getData(b), i * stride, l, out);
                    }
                    continue block5;
                }
                default: {
                    throw new RuntimeException(buffer.getClass().getName() + " not supported");
                }
            }
        }
    }

    private void checkSampleModel(ComponentSampleModel sm) {
        int[] bandOffsets = sm.getBandOffsets();
        int[] bankIndices = sm.getBankIndices();
        if (!(Arrays.equals(OFF_0, bandOffsets) && Arrays.equals(OFF_0, bankIndices) || Arrays.equals(OFF_0_0_0, bandOffsets) && Arrays.equals(OFF_0_1_2, bankIndices) || Arrays.equals(OFF_0_0_0, bankIndices) && Arrays.equals(OFF_0_1_2, bandOffsets))) {
            throw new RuntimeException(sm.getClass().getName() + " with bandOffsets=" + Arrays.asList(new int[][]{bandOffsets}) + " with bankIndices=" + Arrays.asList(new int[][]{bankIndices}) + " not supported");
        }
    }

    private void writeShortLE(short[] data, int off, int len, OutputStream out) throws IOException {
        if (this.clampPixelValue) {
            int end = off + len;
            for (int i = off; i < end; ++i) {
                int px = Math.min(data[i] & 0xFFFF, this.maxVal);
                out.write(px & 0xFF);
                out.write(px >>> 8 & 0xFF);
            }
        } else {
            int end = off + len;
            for (int i = off; i < end; ++i) {
                short px = data[i];
                out.write(px & 0xFF);
                out.write(px >>> 8 & 0xFF);
            }
        }
    }

    private void writeShortBE(short[] data, int off, int len, OutputStream out) throws IOException {
        if (this.clampPixelValue) {
            int end = off + len;
            for (int i = off; i < end; ++i) {
                int px = Math.min(data[i] & 0xFFFF, this.maxVal);
                out.write(px >>> 8 & 0xFF);
                out.write(px & 0xFF);
            }
        } else {
            int end = off + len;
            for (int i = off; i < end; ++i) {
                short px = data[i];
                out.write(px >>> 8 & 0xFF);
                out.write(px & 0xFF);
            }
        }
    }

    public void setSimpleFrameList(int[] simpleFrameList) {
        this.simpleFrameList = simpleFrameList;
    }

    public int getPixelDataLength() {
        return this.getNumberOfFrames() * this.frameLength;
    }

    private int getNumberOfFrames() {
        return this.simpleFrameList != null ? this.simpleFrameList.length : this.frames;
    }
}

