/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.codec;

import EDU.oswego.cs.dl.util.concurrent.FIFOSemaphore;
import EDU.oswego.cs.dl.util.concurrent.Semaphore;
import com.sun.media.imageio.plugins.jpeg2000.J2KImageWriteParam;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.IIOImage;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmDecodeParam;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmEncodeParam;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.data.DcmParser;
import org.dcm4che.data.DcmParserFactory;
import org.dcm4che.data.FileFormat;
import org.dcm4che.data.FileMetaInfo;
import org.dcm4che.util.BufferedOutputStream;
import org.dcm4cheri.image.ImageWriterFactory;
import org.dcm4cheri.imageio.plugins.PatchJpegLSImageOutputStream;
import org.dcm4chex.archive.codec.CodecCmd;
import org.dcm4chex.archive.codec.CompressionFailedException;
import org.dcm4chex.archive.common.DatasetUtils;
import org.dcm4chex.archive.ejb.jdbc.FileInfo;

public abstract class CompressCmd
extends CodecCmd {
    private static int maxConcurrentCompress = 1;
    private static Semaphore compressSemaphore = new FIFOSemaphore((long)maxConcurrentCompress);
    private static AtomicInteger nrOfConcurrentCompress = new AtomicInteger();
    private static final byte[] ITEM_TAG = new byte[]{-2, -1, 0, -32};
    private static final String[] DERIVED_PRIMARY = new String[]{"DERIVED", "PRIMARY"};
    private static final Dataset LOSSY_COMPRESSION = CompressCmd.newCodeItem("113040", "DCM", "Lossy Compression");
    private static final Dataset UNCOMPRESSED_PREDECESSOR = CompressCmd.newCodeItem("121320", "DCM", "Uncompressed predecessor");

    private static Dataset newCodeItem(String value, String schemeDesignator, String meaning) {
        Dataset item = DcmObjectFactory.getInstance().newDataset();
        item.putSH(524544, value);
        item.putSH(524546, schemeDesignator);
        item.putLO(524548, meaning);
        return item;
    }

    public static void setMaxConcurrentCompression(int maxConcurrentCompress) {
        compressSemaphore = new FIFOSemaphore((long)maxConcurrentCompress);
        CompressCmd.maxConcurrentCompress = maxConcurrentCompress;
    }

    public static int getMaxConcurrentCompression() {
        return maxConcurrentCompress;
    }

    private int bitmask() {
        return 65535 >>> this.bitsAllocated - this.bitsUsed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compressFile(File inFile, File outFile, String tsuid, int[] planarConfiguration, int[] pxdataVR, byte[] buffer) throws Exception {
        log.info((Object)("M-READ file:" + inFile));
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(inFile));
        try {
            DcmParser p = DcmParserFactory.getInstance().newDcmParser(in);
            DcmObjectFactory of = DcmObjectFactory.getInstance();
            Dataset ds = of.newDataset();
            p.setDcmHandler(ds.getDcmHandler());
            p.parseDcmFile(FileFormat.DICOM_FILE, 2145386512);
            if (planarConfiguration != null && planarConfiguration.length != 0) {
                planarConfiguration[0] = ds.getInt(2621446, 0);
            }
            if (pxdataVR != null && pxdataVR.length != 0) {
                pxdataVR[0] = p.getReadVR();
            }
            FileMetaInfo fmi = of.newFileMetaInfo(ds, tsuid);
            ds.setFileMetaInfo(fmi);
            log.info((Object)("M-WRITE file:" + outFile));
            MessageDigest md = MessageDigest.getInstance("MD5");
            DigestOutputStream dos = new DigestOutputStream(new FileOutputStream(outFile), md);
            BufferedOutputStream bos = new BufferedOutputStream(dos, buffer);
            try {
                DcmDecodeParam decParam = p.getDcmDecodeParam();
                DcmEncodeParam encParam = DcmEncodeParam.valueOf(tsuid);
                CompressCmd compressCmd = CompressCmd.createCompressCmd(ds, tsuid);
                compressCmd.coerceDataset(ds);
                ds.writeFile(bos, encParam);
                ds.writeHeader(bos, encParam, 2145386512, 20290, -1);
                int read = compressCmd.compress(decParam.byteOrder, in, bos, null);
                ds.writeHeader(bos, encParam, -73507, 0, 0);
                CompressCmd.skipFully(in, p.getReadLength() - read);
                p.parseDataset(decParam, -1);
                ds.subSet(2145386512, -1).writeDataset(bos, encParam);
            }
            finally {
                bos.close();
            }
            byte[] byArray = md.digest();
            return byArray;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compressFileJPEGLossy(File inFile, File outFile, int[] planarConfiguration, int[] pxdataVR, float quality, String derivationDescription, float estimatedCompressionRatio, float[] actualCompressionRatio, String iuid, String suid, byte[] buffer, Dataset ds, FileInfo fileInfo) throws Exception {
        if (suid != null && iuid == null) {
            throw new IllegalArgumentException("New Series Instance UID requires new SOP Instance UID");
        }
        log.info((Object)("M-READ file:" + inFile));
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(inFile));
        try {
            DcmParser p = DcmParserFactory.getInstance().newDcmParser(in);
            if (ds == null) {
                ds = DcmObjectFactory.getInstance().newDataset();
            }
            p.setDcmHandler(ds.getDcmHandler());
            p.parseDcmFile(FileFormat.DICOM_FILE, 2145386512);
            if (planarConfiguration != null && planarConfiguration.length != 0) {
                planarConfiguration[0] = ds.getInt(2621446, 0);
            }
            if (pxdataVR != null && pxdataVR.length != 0) {
                pxdataVR[0] = p.getReadVR();
            }
            if (fileInfo != null) {
                DatasetUtils.fromByteArray(fileInfo.patAttrs, DatasetUtils.fromByteArray(fileInfo.studyAttrs, DatasetUtils.fromByteArray(fileInfo.seriesAttrs, DatasetUtils.fromByteArray(fileInfo.instAttrs, ds))));
            }
            CompressCmd compressCmd = CompressCmd.createJPEGLossyCompressCmd(ds, quality, derivationDescription, estimatedCompressionRatio, iuid, suid);
            compressCmd.coerceDataset(ds);
            String tsuid = compressCmd.getTransferSyntaxUID();
            FileMetaInfo fmi = DcmObjectFactory.getInstance().newFileMetaInfo(ds, tsuid);
            ds.setFileMetaInfo(fmi);
            log.info((Object)("M-WRITE file:" + outFile));
            MessageDigest md = MessageDigest.getInstance("MD5");
            DigestOutputStream dos = new DigestOutputStream(new FileOutputStream(outFile), md);
            BufferedOutputStream bos = new BufferedOutputStream(dos, buffer);
            try {
                DcmDecodeParam decParam = p.getDcmDecodeParam();
                DcmEncodeParam encParam = DcmEncodeParam.valueOf(tsuid);
                ds.writeFile(bos, encParam);
                ds.writeHeader(bos, encParam, 2145386512, 20290, -1);
                int read = compressCmd.compress(decParam.byteOrder, in, bos, actualCompressionRatio);
                ds.writeHeader(bos, encParam, -73507, 0, 0);
                CompressCmd.skipFully(in, p.getReadLength() - read);
                p.parseDataset(decParam, -1);
                ds.subSet(2145386512, -1).writeDataset(bos, encParam);
            }
            finally {
                bos.close();
            }
            byte[] byArray = md.digest();
            return byArray;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    private static void skipFully(InputStream in, int n) throws IOException {
        int skipped = 0;
        for (int remaining = n; remaining > 0; remaining -= skipped) {
            skipped = (int)in.skip(remaining);
            if (skipped != 0) continue;
            throw new EOFException();
        }
    }

    public static CompressCmd createCompressCmd(Dataset ds, String tsuid) {
        if ("1.2.840.10008.1.2.4.90".equals(tsuid)) {
            return new Jpeg2000(ds, tsuid);
        }
        if ("1.2.840.10008.1.2.4.80".equals(tsuid)) {
            return new JpegLS(ds, tsuid);
        }
        if ("1.2.840.10008.1.2.4.70".equals(tsuid) || "1.2.840.10008.1.2.4.57".equals(tsuid)) {
            return new JpegLossless(ds, tsuid);
        }
        throw new IllegalArgumentException("tsuid:" + tsuid);
    }

    public static CompressCmd createJPEGLossyCompressCmd(Dataset ds, float quality, String derivationDescription, float ratio, String iuid, String suid) throws CompressionFailedException {
        return new JpegLossy(ds, ds.getInt(2621696, 8) > 8 ? "1.2.840.10008.1.2.4.51" : "1.2.840.10008.1.2.4.50", quality, derivationDescription, ratio, iuid, suid);
    }

    protected CompressCmd(Dataset ds, String tsuid) {
        super(ds, tsuid);
    }

    public abstract void coerceDataset(Dataset var1);

    protected abstract void initWriteParam(ImageWriteParam var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public int compress(ByteOrder byteOrder, InputStream in, OutputStream out, float[] compressionRatio) throws Exception {
        void var13_23;
        long end;
        boolean compressSemaphoreAquired;
        boolean codecSemaphoreAquired;
        long t1;
        block19: {
            t1 = System.currentTimeMillis();
            ImageWriter w = null;
            BufferedImage bi = null;
            codecSemaphoreAquired = false;
            compressSemaphoreAquired = false;
            end = 0L;
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"acquire codec semaphore:");
                    log.debug((Object)("#####codecSemaphore.permits():" + codecSemaphore.permits()));
                    log.debug((Object)("#####compressSemaphore.permits():" + compressSemaphore.permits()));
                }
                codecSemaphore.acquire();
                codecSemaphoreAquired = true;
                compressSemaphore.acquire();
                compressSemaphoreAquired = true;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("codec semaphore acquired after " + (System.currentTimeMillis() - t1) + "ms!"));
                }
                log.info((Object)("start compression of image: " + this.rows + "x" + this.columns + "x" + this.frames + " (current codec tasks: compress&decompress:" + nrOfConcurrentCodec.incrementAndGet() + " compress:" + nrOfConcurrentCompress.incrementAndGet() + ")"));
                t1 = System.currentTimeMillis();
                MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(out);
                ios.setByteOrder(ByteOrder.LITTLE_ENDIAN);
                ImageWriterFactory f = ImageWriterFactory.getInstance();
                w = f.getWriterForTransferSyntax(this.tsuid);
                boolean patchJpegLS = this.bitsAllocated == 16 && "1.2.840.10008.1.2.4.80".equals(this.tsuid) && f.patchJAIJpegLS();
                ImageWriteParam wParam = w.getDefaultWriteParam();
                this.initWriteParam(wParam);
                bi = this.getBufferedImage();
                WritableRaster raster = bi.getRaster();
                DataBuffer db = raster.getDataBuffer();
                ios.write(ITEM_TAG);
                ios.writeInt(0);
                for (int i = 0; i < this.frames; ++i) {
                    log.debug((Object)("start compression of frame #" + (i + 1)));
                    ios.write(ITEM_TAG);
                    long mark = ios.getStreamPosition();
                    ios.writeInt(0);
                    switch (this.dataType) {
                        case 0: {
                            this.read(in, ((DataBufferByte)db).getBankData());
                            break;
                        }
                        case 2: {
                            this.read(byteOrder, in, ((DataBufferShort)db).getBankData());
                            break;
                        }
                        case 1: {
                            this.read(byteOrder, in, ((DataBufferUShort)db).getBankData());
                            break;
                        }
                        default: {
                            throw new RuntimeException("dataType:" + db.getDataType());
                        }
                    }
                    w.setOutput(patchJpegLS ? new PatchJpegLSImageOutputStream(ios) : ios);
                    w.write(null, new IIOImage(bi, null, null), wParam);
                    end = ios.getStreamPosition();
                    if ((end & 1L) != 0L) {
                        ios.write(0);
                        ++end;
                    }
                    ios.seek(mark);
                    ios.writeInt((int)(end - mark - 4L));
                    ios.seek(end);
                    ios.flush();
                }
                Object var24_19 = null;
                if (w != null) {
                    w.dispose();
                }
                if (bi == null) break block19;
                biPool.returnBufferedImage(bi);
            }
            catch (Throwable throwable) {
                Object var24_20 = null;
                if (w != null) {
                    w.dispose();
                }
                if (bi != null) {
                    biPool.returnBufferedImage(bi);
                }
                long t2 = System.currentTimeMillis();
                int pixelDataLength = this.frameLength * this.frames;
                nrOfConcurrentCompress.decrementAndGet();
                nrOfConcurrentCodec.decrementAndGet();
                log.info((Object)("finished compression " + (float)pixelDataLength / (float)end + " : 1 in " + (t2 - t1) + "ms." + " (remaining codec tasks: compress&decompress:" + nrOfConcurrentCodec + " compress:" + nrOfConcurrentCompress + ")"));
                if (compressSemaphoreAquired) {
                    compressSemaphore.release();
                }
                if (codecSemaphoreAquired) {
                    log.debug((Object)"release codec semaphore");
                    codecSemaphore.release();
                }
                throw throwable;
            }
        }
        long t2 = System.currentTimeMillis();
        int pixelDataLength = this.frameLength * this.frames;
        nrOfConcurrentCompress.decrementAndGet();
        nrOfConcurrentCodec.decrementAndGet();
        log.info((Object)("finished compression " + (float)pixelDataLength / (float)end + " : 1 in " + (t2 - t1) + "ms." + " (remaining codec tasks: compress&decompress:" + nrOfConcurrentCodec + " compress:" + nrOfConcurrentCompress + ")"));
        if (compressSemaphoreAquired) {
            compressSemaphore.release();
        }
        if (codecSemaphoreAquired) {
            log.debug((Object)"release codec semaphore");
            codecSemaphore.release();
        }
        if (compressionRatio != null && compressionRatio.length > 0) {
            compressionRatio[0] = (float)var13_23 * (float)this.bitsUsed() / (float)this.bitsAllocated / (float)end;
        }
        return (int)var13_23;
    }

    private void read(ByteOrder byteOrder, InputStream in, short[][] data) throws IOException {
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            this.readLE(in, data);
        } else {
            this.readBE(in, data);
        }
    }

    private void readLE(InputStream in, short[][] data) throws IOException {
        int bitmask = this.bitmask();
        for (int i = 0; i < data.length; ++i) {
            short[] bank = data[i];
            for (int j = 0; j < bank.length; ++j) {
                int hi;
                int lo = in.read();
                if ((lo | (hi = in.read())) < 0) {
                    throw new EOFException();
                }
                bank[j] = (short)((lo & 0xFF) + (hi << 8) & bitmask);
            }
        }
    }

    private void readBE(InputStream in, short[][] data) throws IOException {
        int bitmask = this.bitmask();
        for (int i = 0; i < data.length; ++i) {
            short[] bank = data[i];
            for (int j = 0; j < bank.length; ++j) {
                int hi = in.read();
                int lo = in.read();
                if ((lo | hi) < 0) {
                    throw new EOFException();
                }
                bank[j] = (short)((lo & 0xFF) + (hi << 8) & bitmask);
            }
        }
    }

    private void read(InputStream in, byte[][] data) throws IOException {
        for (int i = 0; i < data.length; ++i) {
            int read;
            byte[] bank = data[i];
            for (int toread = bank.length; toread > 0; toread -= read) {
                read = in.read(bank, bank.length - toread, toread);
                if (read != -1) continue;
                throw new EOFException("Length of pixel matrix is too short!");
            }
        }
    }

    private static class JpegLossy
    extends CompressCmd {
        private final float quality;
        private final String derivationDescription;
        private final float compressionRatio;
        private final String iuid;
        private final String suid;

        public JpegLossy(Dataset ds, String tsuid, float quality, String derivationDescription, float compressionRatio, String iuid, String suid) throws CompressionFailedException {
            super(ds, tsuid);
            if (suid != null && iuid == null) {
                throw new IllegalArgumentException("New Series Instance UID requires new SOP Instance UID");
            }
            if (this.samples == 3 ? !this.photometricInterpretation.equals("RGB") : !this.photometricInterpretation.equals("MONOCHROME2") && !this.photometricInterpretation.equals("MONOCHROME1")) {
                throw new CompressionFailedException("JPEG Lossy compression of " + this.photometricInterpretation + " images not supported");
            }
            if (JpegLossy.hasOverlayDataInPixelData(ds)) {
                throw new CompressionFailedException("JPEG Lossy compression of images with overlay data in the Image Pixel Data not supported");
            }
            this.quality = quality;
            this.derivationDescription = derivationDescription;
            this.compressionRatio = compressionRatio;
            this.iuid = iuid;
            this.suid = suid;
        }

        private static boolean hasOverlayDataInPixelData(Dataset ds) {
            for (int i = 0; i < 16; ++i) {
                int g = i << 17;
                if (!ds.contains(0x60000010 | g) || ds.contains(0x60003000 | g)) continue;
                return true;
            }
            return false;
        }

        public void coerceDataset(Dataset ds) {
            if (this.samples == 3) {
                ds.putUS(2621446, 0);
                ds.putCS(2621444, "YBR_FULL_422");
            }
            ds.putUS(2621697, this.bitsUsed());
            ds.putCS(2629904, "01");
            ds.putCS(2629908, "ISO_10918_1");
            ds.putDS(0x282112, this.compressionRatio);
            if (this.iuid != null) {
                this.updateImageType(ds);
                this.updateDerivationDescription(ds);
                this.updateDerivationCodeSequence(ds);
                this.updateSourceImageSequence(ds);
                ds.putUI(524312, this.iuid);
                if (this.suid != null) {
                    ds.putUI(0x20000E, this.suid);
                }
            }
        }

        private void updateImageType(Dataset ds) {
            String[] imageType = ds.getStrings(524296);
            if (imageType == null || imageType.length == 0) {
                imageType = DERIVED_PRIMARY;
            } else {
                imageType[0] = DERIVED_PRIMARY[0];
            }
            ds.putCS(524296, imageType);
        }

        private void updateDerivationDescription(Dataset ds) {
            StringBuilder desc = new StringBuilder(32);
            String olddesc = ds.getString(532753);
            if (olddesc != null) {
                desc.append(olddesc).append("; ");
            }
            desc.append(this.derivationDescription);
            ds.putST(532753, desc.toString());
        }

        private void updateDerivationCodeSequence(Dataset ds) {
            DcmElement codes = ds.get(561685);
            if (codes == null) {
                codes = ds.putSQ(561685);
            }
            codes.addItem(LOSSY_COMPRESSION);
        }

        private void updateSourceImageSequence(Dataset ds) {
            DcmElement sourceImages = ds.get(532754);
            if (sourceImages == null) {
                sourceImages = ds.putSQ(532754);
            }
            Dataset sourceImage = sourceImages.addNewItem();
            sourceImage.putUI(528720, ds.getString(524310));
            sourceImage.putUI(528725, ds.getString(524312));
            sourceImage.putSQ(4235632).addItem(UNCOMPRESSED_PREDECESSOR);
        }

        protected void initWriteParam(ImageWriteParam param) {
            param.setCompressionMode(2);
            param.setCompressionType("JPEG");
            param.setCompressionQuality(this.quality);
        }

        protected int bitsUsed() {
            return Math.min(12, this.bitsStored);
        }
    }

    private static class JpegLS
    extends CompressCmd {
        public JpegLS(Dataset ds, String tsuid) {
            super(ds, tsuid);
        }

        public void coerceDataset(Dataset ds) {
            if (this.samples == 3) {
                ds.putUS(2621446, 0);
            }
        }

        protected void initWriteParam(ImageWriteParam param) {
            param.setCompressionMode(2);
            param.setCompressionType("JPEG-LS");
        }
    }

    private static class JpegLossless
    extends CompressCmd {
        public JpegLossless(Dataset ds, String tsuid) {
            super(ds, tsuid);
        }

        public void coerceDataset(Dataset ds) {
            if (this.samples == 3) {
                ds.putUS(2621446, 0);
            }
        }

        protected void initWriteParam(ImageWriteParam param) {
            param.setCompressionMode(2);
            param.setCompressionType("JPEG-LOSSLESS");
        }
    }

    private static class Jpeg2000
    extends CompressCmd {
        public Jpeg2000(Dataset ds, String tsuid) {
            super(ds, tsuid);
        }

        public void coerceDataset(Dataset ds) {
            if (this.samples == 3) {
                ds.putUS(2621446, 0);
                ds.putCS(2621444, "YBR_RCT");
            }
        }

        protected void initWriteParam(ImageWriteParam param) {
            if (param instanceof J2KImageWriteParam) {
                J2KImageWriteParam j2KwParam = (J2KImageWriteParam)param;
                j2KwParam.setWriteCodeStreamOnly(true);
            }
        }
    }
}

