/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.codec;

import EDU.oswego.cs.dl.util.concurrent.FIFOSemaphore;
import EDU.oswego.cs.dl.util.concurrent.Semaphore;
import java.awt.image.BufferedImage;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.FileMetaInfo;
import org.dcm4chex.archive.codec.BufferedImagePool;

public abstract class CodecCmd {
    static final Logger log = Logger.getLogger(CodecCmd.class);
    static final String YBR_FULL_422 = "YBR_FULL_422";
    static final String YBR_RCT = "YBR_RCT";
    static final String JPEG2000 = "jpeg2000";
    static final String JPEG = "jpeg";
    static final String JPEG_LOSSLESS = "JPEG-LOSSLESS";
    static final String JPEG_LS = "JPEG-LS";
    static int maxConcurrentCodec = 1;
    static AtomicInteger nrOfConcurrentCodec = new AtomicInteger();
    static Semaphore codecSemaphore = new FIFOSemaphore((long)maxConcurrentCodec);
    static BufferedImagePool biPool = new BufferedImagePool();
    protected final String implClassUID;
    protected final String photometricInterpretation;
    protected final int samples;
    protected final int frames;
    protected final int rows;
    protected final int columns;
    protected final int planarConfiguration;
    protected final int bitsAllocated;
    protected final int bitsStored;
    protected final int pixelRepresentation;
    protected final int frameLength;
    protected final String tsuid;
    protected final int dataType;
    protected final int maxVal;

    protected CodecCmd(Dataset ds, String tsuid) {
        FileMetaInfo fmi = ds.getFileMetaInfo();
        this.implClassUID = fmi != null ? fmi.getImplementationClassUID() : null;
        this.photometricInterpretation = ds.getString(2621444, "MONCHROME2");
        this.samples = ds.getInt(0x280002, 1);
        this.frames = ds.getInt(0x280008, 1);
        this.rows = ds.getInt(2621456, 1);
        this.columns = ds.getInt(2621457, 1);
        this.bitsAllocated = ds.getInt(2621696, 8);
        this.bitsStored = ds.getInt(2621697, this.bitsAllocated);
        this.pixelRepresentation = ds.getInt(2621699, 0);
        this.planarConfiguration = ds.getInt(2621446, 0);
        this.frameLength = this.rows * this.columns * this.samples * this.bitsAllocated / 8;
        this.tsuid = tsuid;
        switch (this.bitsAllocated) {
            case 8: {
                this.dataType = 0;
                break;
            }
            case 16: {
                this.dataType = this.pixelRepresentation != 0 && ("1.2.840.10008.1.2.4.90".equals(tsuid) || "1.2.840.10008.1.2.4.91".equals(tsuid)) ? 2 : 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("bits allocated:" + this.bitsAllocated);
            }
        }
        this.maxVal = -1 >>> 32 - this.bitsStored + this.pixelRepresentation;
    }

    public static void setMaxConcurrentCodec(int maxConcurrentCodec) {
        codecSemaphore = new FIFOSemaphore((long)maxConcurrentCodec);
        CodecCmd.maxConcurrentCodec = maxConcurrentCodec;
    }

    public static int getMaxConcurrentCodec() {
        return maxConcurrentCodec;
    }

    public static int getMaxBufferedImagePoolSize() {
        return biPool.getMaxSize();
    }

    public static void setMaxBufferedImagePoolSize(int maxSize) {
        biPool.setMaxSize(maxSize);
    }

    public static int getCurrentBufferedImagePoolSize() {
        return biPool.getPoolSize();
    }

    public static long getMaxBufferedImagePoolMemory() {
        return biPool.getMaxMemory();
    }

    public static void setMaxBufferedImagePoolMemory(long maxMemory) {
        biPool.setMaxMemory(maxMemory);
    }

    public static long getCurrentBufferedImagePoolMemory() {
        return biPool.getPoolMemory();
    }

    public static float getBufferedImagePoolHitRate() {
        return biPool.getHitRate();
    }

    public static void resetBufferedImagePoolHitRate() {
        biPool.resetHitRate();
    }

    public final String getTransferSyntaxUID() {
        return this.tsuid;
    }

    public int getPixelDataLength() {
        return this.frames * this.frameLength;
    }

    protected BufferedImage getBufferedImage() {
        return biPool.borrowOrCreateBufferedImage(this.rows, this.columns, this.bitsUsed(), this.samples, this.planarConfiguration, this.dataType);
    }

    protected int bitsUsed() {
        return this.bitsAllocated;
    }

    protected void returnBufferedImage(BufferedImage bi) {
        biPool.returnBufferedImage(bi);
    }
}

