/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.codec;

import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

class BufferedImagePool {
    static final Logger log = Logger.getLogger(BufferedImagePool.class);
    private static final int[] GRAY_BAND_OFFSETS = new int[]{0};
    private static final int[] RGB_BAND_OFFSETS = new int[]{0, 1, 2};
    private List<BufferedImage> pool = new ArrayList<BufferedImage>();
    private int maxSize = 10;
    private long maxMemory = 1000000L;
    private long poolMemory = 0L;
    private float borrowOrCreateCount = 0.0f;
    private float borrowCount = 0.0f;

    BufferedImagePool() {
    }

    public synchronized BufferedImage borrowOrCreateBufferedImage(int rows, int columns, int bitsUsed, int samples, int planarConfiguration, int dataType) {
        BufferedImage bi;
        this.borrowOrCreateCount += 1.0f;
        int index = this.pool.size();
        while (--index >= 0) {
            bi = this.pool.get(index);
            ColorModel cm = bi.getColorModel();
            WritableRaster raster = bi.getRaster();
            DataBuffer db = raster.getDataBuffer();
            if (raster.getHeight() != rows || raster.getWidth() != columns || raster.getNumBands() != samples || cm.getComponentSize(0) != bitsUsed || db.getNumBanks() != (planarConfiguration != 0 ? samples : 1) || db.getDataType() != dataType) continue;
            this.pool.remove(index);
            this.poolMemory -= (long)BufferedImagePool.sizeOf(bi);
            this.borrowCount += 1.0f;
            BufferedImagePool.log("borrow", bi);
            return bi;
        }
        WritableRaster r = Raster.createWritableRaster(BufferedImagePool.getSampleModel(rows, columns, samples, planarConfiguration, dataType), null);
        bi = new BufferedImage(BufferedImagePool.getColorModel(bitsUsed, samples, dataType), r, false, null);
        BufferedImagePool.log("create", bi);
        return bi;
    }

    private static void log(String msg, BufferedImage bi) {
        if (log.isDebugEnabled()) {
            ColorModel cm = bi.getColorModel();
            WritableRaster raster = bi.getRaster();
            log.debug((Object)(msg + " BufferedImage@" + Integer.toHexString(bi.hashCode()) + " " + raster.getWidth() + "x" + raster.getHeight() + "x" + raster.getNumBands() + " " + DataBuffer.getDataTypeSize(raster.getTransferType()) + "(" + cm.getComponentSize(0) + ") bits"));
        }
    }

    private static SampleModel getSampleModel(int rows, int columns, int samples, int planarConfiguration, int dataType) {
        return planarConfiguration == 0 ? new PixelInterleavedSampleModel(dataType, columns, rows, samples, columns * samples, samples == 1 ? GRAY_BAND_OFFSETS : RGB_BAND_OFFSETS) : new BandedSampleModel(dataType, columns, rows, samples);
    }

    private static ColorModel getColorModel(int bitsUsed, int samples, int dataType) {
        return samples == 3 ? new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{bitsUsed, bitsUsed, bitsUsed}, false, false, 1, dataType) : new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{bitsUsed}, false, false, 1, dataType);
    }

    private static int sizeOf(BufferedImage bi) {
        WritableRaster raster = bi.getRaster();
        int biSize = raster.getWidth() * raster.getHeight() * raster.getNumBands() * (DataBuffer.getDataTypeSize(raster.getTransferType()) >> 3);
        return biSize;
    }

    public synchronized void returnBufferedImage(BufferedImage bi) {
        long biSize;
        if (this.maxSize == 0 || (biSize = (long)BufferedImagePool.sizeOf(bi)) > this.maxMemory) {
            BufferedImagePool.log("trash", bi);
            return;
        }
        this.pool.add(bi);
        this.poolMemory += biSize;
        BufferedImagePool.log("return", bi);
        this.resize();
    }

    private void resize() {
        while (this.pool.size() > this.maxSize || this.poolMemory > this.maxMemory) {
            BufferedImage bi = this.pool.remove(0);
            this.poolMemory -= (long)BufferedImagePool.sizeOf(bi);
            BufferedImagePool.log("trash", bi);
        }
    }

    public final int getMaxSize() {
        return this.maxSize;
    }

    public final void setMaxSize(int maxSize) {
        if (maxSize < 0) {
            throw new IllegalArgumentException("maxSize: " + maxSize);
        }
        this.maxSize = maxSize;
        this.resize();
    }

    public final long getMaxMemory() {
        return this.maxMemory;
    }

    public final void setMaxMemory(long maxMemory) {
        if (maxMemory < 0L) {
            throw new IllegalArgumentException("maxMemory: " + maxMemory);
        }
        this.maxMemory = maxMemory;
    }

    public final int getPoolSize() {
        return this.pool.size();
    }

    public final long getPoolMemory() {
        return this.poolMemory;
    }

    public float getHitRate() {
        return this.borrowCount / this.borrowOrCreateCount;
    }

    public void resetHitRate() {
        this.borrowCount = 0.0f;
        this.borrowOrCreateCount = 0.0f;
    }
}

