/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.common.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.servlet.http.HttpServletRequest;

public class HttpUserInfo {
    private static final String WEB_REQUEST_KEY = "javax.servlet.http.HttpServletRequest";
    private String userId;
    private String ip;
    private String hostName;
    private String url;

    public HttpUserInfo(boolean enableDNSLookups) {
        try {
            HttpServletRequest rq = (HttpServletRequest)PolicyContext.getContext((String)WEB_REQUEST_KEY);
            this.init(rq, enableDNSLookups);
        }
        catch (PolicyContextException e) {
            this.userId = "UNKNOWN_USER";
        }
        catch (NullPointerException e) {
            this.userId = "SYSTEM";
        }
    }

    public HttpUserInfo(HttpServletRequest rq, boolean enableDNSLookups) {
        this.init(rq, enableDNSLookups);
    }

    private void init(HttpServletRequest rq, boolean enableDNSLookups) {
        int pos;
        String xForward;
        this.userId = rq.getRemoteUser();
        if (this.userId == null || this.userId.length() < 1) {
            this.userId = "UNKNOWN_USER";
        }
        this.ip = (xForward = rq.getHeader("x-forwarded-for")) != null ? ((pos = xForward.indexOf(44)) > 0 ? xForward.substring(0, pos) : xForward).trim() : rq.getRemoteAddr();
        if (enableDNSLookups) {
            try {
                this.hostName = InetAddress.getByName(this.ip).getHostName();
            }
            catch (UnknownHostException ignore) {
                this.hostName = this.ip;
            }
        } else {
            this.hostName = this.ip;
        }
        this.url = rq.getRequestURL().toString();
    }

    public String getUserId() {
        return this.userId;
    }

    public String getIP() {
        return this.ip;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getURL() {
        return this.url;
    }
}

