/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.common.util;

import java.io.File;
import org.jboss.system.server.ServerConfigLocator;

public class FileUtils {
    private static char[] HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static File resolve(File f) {
        if (f.isAbsolute()) {
            return f;
        }
        try {
            File serverHomeDir = ServerConfigLocator.locate().getServerHomeDir();
            return new File(serverHomeDir, f.getPath());
        }
        catch (Throwable t) {
            return f;
        }
    }

    public static File toFile(String unixPath) {
        return FileUtils.resolve(new File(unixPath.replace('/', File.separatorChar)));
    }

    public static String toHex(int val) {
        char[] ch8 = new char[8];
        int i = 8;
        while (--i >= 0) {
            ch8[i] = HEX_DIGIT[val & 0xF];
            val >>= 4;
        }
        return String.valueOf(ch8);
    }
}

