/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.common.util;

import java.util.Calendar;
import java.util.Locale;
import org.apache.wicket.Component;
import org.joda.time.format.DateTimeFormat;

public class DateUtils {
    public static String da2str(String da) {
        if (da == null) {
            return null;
        }
        if (da.length() != 8) {
            return da;
        }
        StringBuilder sb = new StringBuilder(10);
        sb.append(da.substring(0, 4)).append('-').append(da.substring(4, 6)).append('-').append(da.substring(6));
        return sb.toString();
    }

    public static String str2da(String str) {
        String s = str.trim();
        if (s.length() != 10) {
            return s;
        }
        StringBuilder sb = new StringBuilder(8);
        sb.append(s.substring(0, 4)).append(s.substring(5, 7)).append(s.substring(8));
        return sb.toString();
    }

    public static String tm2str(String tm) {
        if (tm == null) {
            return null;
        }
        if (tm.length() < 4 || tm.charAt(2) == ':') {
            return tm;
        }
        StringBuilder sb = new StringBuilder(10);
        sb.append(tm.substring(0, 2)).append(':').append(tm.substring(2, 4));
        if (tm.length() >= 6) {
            sb.append(':').append(tm.substring(4, 6));
        }
        return sb.toString();
    }

    public static String str2tm(String str) {
        String s = str.trim();
        int colon = s.indexOf(58);
        if (colon == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length());
        int pos = 0;
        do {
            sb.append(s.substring(pos, colon));
        } while ((colon = s.indexOf(58, pos = colon + 1)) != -1);
        sb.append(s.substring(pos));
        return sb.toString();
    }

    public static String datm2str(String da, String tm) {
        return DateUtils.da2str(da) + " " + DateUtils.tm2str(tm);
    }

    public static String[] str2datm(String str) {
        String s = str.trim();
        int space = s.indexOf(32);
        String[] datm = new String[2];
        if (space == -1) {
            datm[0] = DateUtils.str2da(s);
        } else {
            datm[0] = DateUtils.str2da(s.substring(0, space));
            datm[1] = DateUtils.str2tm(s.substring(space + 1).trim());
        }
        return datm;
    }

    public static String getDatePattern(Component c) {
        String pattern = DateTimeFormat.patternForStyle((String)"S-", (Locale)c.getLocale());
        int pos1 = pattern.indexOf(121);
        if (pos1 != -1) {
            if (pattern.length() <= pos1 + 2) {
                pattern = pattern + "yy";
            } else if (pattern.charAt(pos1 + 2) != 'y') {
                pattern = pattern.substring(0, pos1) + "yyyy" + pattern.substring(pos1 + 2);
            }
        }
        return pattern;
    }

    public static void setTimeToMinOrMax(Calendar cal, boolean max) {
        if (max) {
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 999);
        } else {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
        }
    }
}

