/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.common.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.dcm4che2.audit.message.ActiveParticipant;
import org.dcm4che2.audit.message.AuditEvent;
import org.dcm4che2.audit.message.AuditMessage;
import org.dcm4che2.audit.message.DataExportMessage;
import org.dcm4che2.audit.message.InstancesAccessedMessage;
import org.dcm4che2.audit.message.ParticipantObject;
import org.dcm4che2.audit.message.ParticipantObjectDescription;
import org.dcm4che2.audit.message.PatientRecordMessage;
import org.dcm4che2.audit.message.ProcedureRecordMessage;
import org.dcm4che2.audit.message.QueryMessage;
import org.dcm4che2.audit.message.SecurityAlertMessage;
import org.dcm4che2.audit.message.StudyDeletedMessage;
import org.dcm4che2.audit.util.InstanceSorter;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.io.DicomOutputStream;
import org.dcm4chee.web.common.util.HttpUserInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Auditlog {
    private static Logger auditLog = LoggerFactory.getLogger((String)"auditlog");
    private static Logger log = LoggerFactory.getLogger(Auditlog.class);

    public static void logQuery(boolean success, String cuid, DicomObject query) {
        HttpUserInfo userInfo = new HttpUserInfo(AuditMessage.isEnableDNSLookups());
        try {
            QueryMessage msg = new QueryMessage();
            msg.setOutcomeIndicator(success ? AuditEvent.OutcomeIndicator.SUCCESS : AuditEvent.OutcomeIndicator.MINOR_FAILURE);
            msg.addDestinationProcess(AuditMessage.getProcessID(), null, AuditMessage.getProcessName(), userInfo.getHostName(), false);
            msg.addSourceProcess(AuditMessage.getProcessID(), null, AuditMessage.getProcessName(), AuditMessage.getLocalHostName(), true);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DicomOutputStream dos = new DicomOutputStream((OutputStream)bos);
            dos.writeDataset(query, "1.2.840.10008.1.2.1");
            msg.addQuerySOPClass(cuid, "1.2.840.10008.1.2.1", bos.toByteArray());
            msg.validate();
            auditLog.info(msg.toString());
        }
        catch (Exception x) {
            log.warn("Audit Log 'Query' failed:", (Throwable)x);
        }
    }

    public static void logInstancesAccessed(AuditEvent.ActionCode actionCode, boolean success, DicomObject kos, boolean addIUID, String detailMessage) {
        HttpUserInfo userInfo = new HttpUserInfo(AuditMessage.isEnableDNSLookups());
        try {
            InstancesAccessedMessage msg = new InstancesAccessedMessage(actionCode);
            msg.setOutcomeIndicator(success ? AuditEvent.OutcomeIndicator.SUCCESS : AuditEvent.OutcomeIndicator.MINOR_FAILURE);
            msg.addUserPerson(userInfo.getUserId(), null, null, userInfo.getHostName(), true);
            msg.addPatient(kos.getString(0x100020), kos.getString(0x100010));
            DicomElement crpeSeq = kos.get(4236149);
            int len = crpeSeq.countItems();
            for (int i = 0; i < len; ++i) {
                DicomObject item = crpeSeq.getDicomObject(i);
                ParticipantObject study = msg.addStudy(item.getString(0x20000D), Auditlog.getStudyDescription(item, addIUID));
                if (detailMessage == null) continue;
                study.addParticipantObjectDetail("Description", Auditlog.getStudySeriesDetail(detailMessage, item));
            }
            msg.validate();
            auditLog.info(msg.toString());
        }
        catch (Exception x) {
            log.warn("Audit Log 'Instances Accessed' (actionCode:" + actionCode + ") failed:", (Throwable)x);
        }
    }

    public static void logStudyDeleted(DicomObject kos, boolean success) {
        HttpUserInfo userInfo = new HttpUserInfo(AuditMessage.isEnableDNSLookups());
        try {
            String patId = kos.getString(0x100020);
            String patName = kos.getString(0x100010);
            DicomElement crpeSeq = kos.get(4236149);
            int len = crpeSeq.countItems();
            for (int i = 0; i < len; ++i) {
                StudyDeletedMessage msg = new StudyDeletedMessage();
                msg.addUserPerson(userInfo.getUserId(), null, null, userInfo.getHostName(), true);
                msg.addPatient(patId, patName);
                DicomObject crpeSeqItem = kos.get(4236149).getDicomObject(i);
                msg.addStudy(crpeSeqItem.getString(0x20000D), Auditlog.getStudyDescription(crpeSeqItem, true));
                msg.setOutcomeIndicator(success ? AuditEvent.OutcomeIndicator.SUCCESS : AuditEvent.OutcomeIndicator.MINOR_FAILURE);
                msg.validate();
                auditLog.info(msg.toString());
            }
        }
        catch (Exception x) {
            log.warn("Audit Log 'Study Deleted' failed:", (Throwable)x);
        }
    }

    public static void logDicomObjectUpdated(boolean success, String patId, String patName, String[] studyIUIDs, DicomObject obj, String detailMessage) {
        HttpUserInfo userInfo = new HttpUserInfo(AuditMessage.isEnableDNSLookups());
        try {
            InstancesAccessedMessage msg = new InstancesAccessedMessage(InstancesAccessedMessage.UPDATE);
            msg.setOutcomeIndicator(success ? AuditEvent.OutcomeIndicator.SUCCESS : AuditEvent.OutcomeIndicator.MINOR_FAILURE);
            msg.addUserPerson(userInfo.getUserId(), null, null, userInfo.getHostName(), true);
            msg.addPatient(patId, patName);
            for (int i = 0; i < studyIUIDs.length; ++i) {
                ParticipantObject study = msg.addStudy(studyIUIDs[i], Auditlog.getStudyDescription(obj));
                if (detailMessage == null) continue;
                study.addParticipantObjectDetail("Description", detailMessage);
            }
            msg.validate();
            auditLog.info(msg.toString());
        }
        catch (Exception x) {
            log.warn("Audit Log 'Instances Accessed' (actionCode:U) failed:", (Throwable)x);
        }
    }

    public static void logPatientRecord(AuditEvent.ActionCode actionCode, boolean success, String patId, String patName) {
        HttpUserInfo userInfo = new HttpUserInfo(AuditMessage.isEnableDNSLookups());
        try {
            PatientRecordMessage msg = new PatientRecordMessage(actionCode);
            msg.setOutcomeIndicator(success ? AuditEvent.OutcomeIndicator.SUCCESS : AuditEvent.OutcomeIndicator.MINOR_FAILURE);
            msg.addUserPerson(userInfo.getUserId(), null, null, userInfo.getHostName(), true);
            msg.addPatient(patId, patName);
            msg.validate();
            auditLog.info(msg.toString());
        }
        catch (Exception x) {
            log.warn("Audit Log 'Patient Record' (actionCode:" + actionCode + ") failed:", (Throwable)x);
        }
    }

    public static void logExport(String mediaType, List<DicomObject> objs, boolean success) {
        try {
            HttpUserInfo userInfo = new HttpUserInfo(AuditMessage.isEnableDNSLookups());
            String user = userInfo.getUserId();
            String host = userInfo.getHostName();
            DataExportMessage msg = new DataExportMessage();
            msg.setOutcomeIndicator(AuditEvent.OutcomeIndicator.SUCCESS);
            msg.addExporterProcess(AuditMessage.getProcessID(), AuditMessage.getLocalAETitles(), AuditMessage.getProcessName(), false, AuditMessage.getLocalHostName());
            msg.addDataRepository(userInfo.getURL());
            msg.addDestinationMedia(host, null, mediaType, user == null, host);
            if (user != null) {
                ActiveParticipant ap = ActiveParticipant.createActivePerson((String)user, null, (String)user, null, (boolean)true);
                msg.addActiveParticipant(ap);
            }
            HashSet<String> pats = new HashSet<String>();
            HashMap studies = new HashMap();
            for (DicomObject dicomObject : objs) {
                int[] noi;
                HashMap<String, int[]> sopClasses;
                String patID = dicomObject.getString(0x100020);
                String patName = dicomObject.getString(0x100010);
                if (pats.add(patID + "_" + patName)) {
                    msg.addPatient(patID, patName);
                }
                if ((sopClasses = (HashMap<String, int[]>)studies.get(dicomObject.getString(0x20000D))) == null) {
                    sopClasses = new HashMap<String, int[]>();
                    studies.put(dicomObject.getString(0x20000D), sopClasses);
                }
                if ((noi = (int[])sopClasses.get(dicomObject.getString(524310))) == null) {
                    sopClasses.put(dicomObject.getString(524310), new int[]{1});
                    continue;
                }
                noi[0] = noi[0] + 1;
            }
            for (Map.Entry entry : studies.entrySet()) {
                ParticipantObjectDescription desc = new ParticipantObjectDescription();
                for (Map.Entry sopCl : ((HashMap)entry.getValue()).entrySet()) {
                    ParticipantObjectDescription.SOPClass sopClass = new ParticipantObjectDescription.SOPClass((String)sopCl.getKey());
                    sopClass.setNumberOfInstances(((int[])sopCl.getValue())[0]);
                    desc.addSOPClass(sopClass);
                }
                msg.addStudy((String)entry.getKey(), desc);
            }
            msg.validate();
            auditLog.info(msg.toString());
        }
        catch (Exception x) {
            log.warn("Audit Log 'Data Export' failed:", (Throwable)x);
        }
    }

    public static void logProcedureRecord(AuditEvent.ActionCode actionCode, boolean success, DicomObject patAttrs, String studyIuid, String accNr, String desc) {
        HttpUserInfo userInfo = new HttpUserInfo(AuditMessage.isEnableDNSLookups());
        try {
            ProcedureRecordMessage msg = new ProcedureRecordMessage(actionCode);
            msg.setOutcomeIndicator(success ? AuditEvent.OutcomeIndicator.SUCCESS : AuditEvent.OutcomeIndicator.MINOR_FAILURE);
            msg.addUserPerson(userInfo.getUserId(), null, null, userInfo.getHostName(), true);
            msg.addPatient(patAttrs.getString(0x100020), patAttrs.getString(0x100010));
            if (studyIuid != null) {
                ParticipantObjectDescription poDesc = new ParticipantObjectDescription();
                if (accNr != null) {
                    poDesc.addAccession(accNr);
                }
                ParticipantObject study = msg.addStudy(studyIuid, poDesc);
                if (desc != null) {
                    study.addParticipantObjectDetail("Description", desc);
                }
            }
            msg.validate();
            auditLog.info(msg.toString());
        }
        catch (Exception x) {
            log.warn("Audit Log 'Procedure Record' failed:", (Throwable)x);
        }
    }

    public static void logSecurityAlert(AuditEvent.TypeCode code, boolean success, String desc) {
        try {
            SecurityAlertMessage msg = Auditlog.getSecurityAlertMessage(code, success, desc);
            msg.validate();
            auditLog.info(msg.toString());
        }
        catch (Exception e) {
            log.warn("Failed to log ActorConfig:", (Throwable)e);
        }
    }

    public static void logSecurityAlert(AuditEvent.TypeCode code, boolean success, String desc, String patID, String patName, String studyIUID) {
        try {
            SecurityAlertMessage msg = Auditlog.getSecurityAlertMessage(code, success, desc);
            msg.addParticipantObject(ParticipantObject.createPatient((String)patID, (String)patName));
            if (studyIUID != null) {
                msg.addParticipantObject(ParticipantObject.createStudy((String)studyIUID, null));
            }
            msg.validate();
            auditLog.info(msg.toString());
        }
        catch (Exception e) {
            log.warn("Failed to log ActorConfig:", (Throwable)e);
        }
    }

    public static SecurityAlertMessage getSecurityAlertMessage(AuditEvent.TypeCode code, boolean success, String desc) {
        HttpUserInfo userInfo = new HttpUserInfo(AuditMessage.isEnableDNSLookups());
        SecurityAlertMessage msg = new SecurityAlertMessage(code);
        msg.setOutcomeIndicator(success ? AuditEvent.OutcomeIndicator.SUCCESS : AuditEvent.OutcomeIndicator.MINOR_FAILURE);
        msg.addReportingProcess(AuditMessage.getProcessID(), AuditMessage.getLocalAETitles(), AuditMessage.getProcessName(), AuditMessage.getLocalHostName());
        if (userInfo.getHostName() != null) {
            msg.addPerformingPerson(userInfo.getUserId(), null, null, userInfo.getHostName());
        } else {
            msg.addPerformingNode(AuditMessage.getLocalHostName());
        }
        msg.addAlertSubjectWithNodeID(AuditMessage.getLocalNodeID(), desc);
        return msg;
    }

    public static void logSoftwareConfiguration(boolean success, String desc) {
        Auditlog.logSecurityAlert(SecurityAlertMessage.SOFTWARE_CONFIGURATION, success, desc);
    }

    public static boolean addChangeOfCollection(StringBuilder sb, boolean changed, String valueName, Collection oldValue, Collection newValue) {
        if (oldValue == null && newValue == null) {
            return false;
        }
        ArrayList addedValues = null;
        ArrayList removedValues = null;
        if (oldValue == null) {
            addedValues = newValue;
        } else if (newValue == null) {
            removedValues = oldValue;
        } else if (newValue.size() >= oldValue.size() && newValue.containsAll(oldValue)) {
            if (newValue.size() == oldValue.size()) {
                return false;
            }
            addedValues = new ArrayList(newValue.size());
            addedValues.addAll(newValue);
            addedValues.removeAll(oldValue);
        } else {
            addedValues = new ArrayList(newValue.size());
            addedValues.addAll(newValue);
            addedValues.removeAll(oldValue);
            removedValues = new ArrayList(oldValue.size());
            addedValues.addAll(oldValue);
            addedValues.removeAll(newValue);
        }
        sb.append(changed ? " ; " : "Change ").append(valueName).append(":");
        if (removedValues != null && removedValues.size() > 0) {
            sb.append(" removed:[");
            for (Object o : removedValues) {
                sb.append(o).append(',');
            }
            sb.setLength(sb.length() - 1);
            sb.append("]");
        }
        if (addedValues != null && addedValues.size() > 0) {
            sb.append(" added:[");
            for (Object o : addedValues) {
                sb.append(o).append(',');
            }
            sb.setLength(sb.length() - 1);
            sb.append("]");
        }
        return true;
    }

    public static boolean addChange(StringBuilder sb, boolean changed, String valueName, Object oldValue, Object newValue) {
        if (oldValue == newValue || oldValue != null && oldValue.equals(newValue)) {
            return false;
        }
        sb.append(changed ? " ; " : "Change ").append(valueName).append(" from ").append(oldValue).append(" to ").append(newValue);
        return true;
    }

    private static ParticipantObjectDescription getStudyDescription(DicomObject obj) {
        ParticipantObjectDescription desc = new ParticipantObjectDescription();
        if (obj.containsValue(524368)) {
            desc.addAccession(obj.getString(524368));
        }
        if (obj.containsValue(524310)) {
            ParticipantObjectDescription.SOPClass sopClass = new ParticipantObjectDescription.SOPClass(obj.getString(524310));
            sopClass.addInstance(obj.getString(524312));
            desc.addSOPClass(sopClass);
        }
        return desc;
    }

    private static ParticipantObjectDescription getStudyDescription(DicomObject crpeSeqItem, boolean addIUID) {
        ParticipantObjectDescription desc = new ParticipantObjectDescription();
        String accNr = crpeSeqItem.getString(524368);
        if (accNr != null) {
            desc.addAccession(accNr);
        }
        Auditlog.addSOPClassInfo(desc, crpeSeqItem, addIUID);
        return desc;
    }

    private static String getStudySeriesDetail(String detailMessage, DicomObject crpeSeqItem) {
        DicomElement refSeries = crpeSeqItem.get(528661);
        StringBuffer sb = new StringBuffer();
        sb.append(detailMessage);
        int len = refSeries.countItems();
        if (len > 0) {
            sb.append(refSeries.getDicomObject(0).getString(0x20000E));
            for (int i = 1; i < len; ++i) {
                sb.append(", ").append(refSeries.getDicomObject(i).getString(0x20000E));
            }
        }
        return sb.toString();
    }

    private static void addSOPClassInfo(ParticipantObjectDescription desc, DicomObject studyMgtDs, boolean addIUID) {
        DicomElement refSeries = studyMgtDs.get(528661);
        if (refSeries == null) {
            return;
        }
        String suid = studyMgtDs.getString(0x20000D);
        InstanceSorter sorter = new InstanceSorter();
        int len = refSeries.countItems();
        for (int i = 0; i < len; ++i) {
            DicomElement refSopSeq = refSeries.getDicomObject(i).get(528793);
            if (refSopSeq == null) continue;
            int jlen = refSopSeq.countItems();
            for (int j = 0; j < jlen; ++j) {
                DicomObject ds = refSopSeq.getDicomObject(j);
                sorter.addInstance(suid, ds.getString(528720), ds.getString(528725), null);
            }
        }
        for (String cuid : sorter.getCUIDs(suid)) {
            ParticipantObjectDescription.SOPClass sopClass = new ParticipantObjectDescription.SOPClass(cuid);
            sopClass.setNumberOfInstances(sorter.countInstances(suid, cuid));
            if (addIUID) {
                for (String iuid : sorter.getIUIDs(suid, cuid)) {
                    sopClass.addInstance(iuid);
                }
            }
            desc.addSOPClass(sopClass);
        }
    }
}

