/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.common.secure;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.resource.loader.ClassStringResourceLoader;
import org.apache.wicket.resource.loader.PackageStringResourceLoader;
import org.apache.wicket.security.extensions.markup.html.tabs.ISecureTab;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecureTab
implements ISecureTab {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(SecureTab.class);
    private transient ClassStringResourceLoader classStringLoader;
    private transient PackageStringResourceLoader pkgStringLoader;
    private static final String TAB_TITLE_EXT = ".tabTitle";
    private Class<? extends Panel> clazz;
    private String clazzName;
    private String tabTitlePropertyName;
    private Panel panel;
    private IModel<String> titleModel;

    public SecureTab(Class<? extends Panel> clazz2) {
        this.clazz = clazz2;
        this.initialize();
    }

    public SecureTab(Class<? extends Panel> clazz2, IModel<String> titleModel) {
        this.clazz = clazz2;
        this.titleModel = titleModel;
        this.initialize();
    }

    public SecureTab(Panel instance, IModel<String> titleModel) {
        this.clazz = instance.getClass();
        this.panel = instance;
        this.titleModel = titleModel;
        if (titleModel == null) {
            this.initialize();
        }
    }

    private void initialize() {
        this.clazzName = this.clazz.getName().substring(this.clazz.getName().lastIndexOf(46) + 1);
        this.pkgStringLoader = new PackageStringResourceLoader();
        try {
            Method m = this.clazz.getDeclaredMethod("getModuleName", new Class[0]);
            this.tabTitlePropertyName = m.invoke(null, new Object[0]) + TAB_TITLE_EXT;
        }
        catch (Exception e) {
            log.warn("Panel class " + this.clazz + " has no static getModuleName() method declared! use classname instead!:" + this.clazzName);
            this.tabTitlePropertyName = this.clazzName + TAB_TITLE_EXT;
        }
    }

    private ClassStringResourceLoader getClassStringLoader() {
        if (this.classStringLoader == null) {
            this.classStringLoader = new ClassStringResourceLoader(this.clazz);
        }
        return this.classStringLoader;
    }

    private PackageStringResourceLoader getPackageStringLoader() {
        if (this.pkgStringLoader == null) {
            this.pkgStringLoader = new PackageStringResourceLoader();
        }
        return this.pkgStringLoader;
    }

    public Class<? extends Panel> getPanel() {
        return this.clazz;
    }

    public Panel getPanel(String panelId) {
        try {
            if (this.panel == null) {
                Constructor<? extends Panel> c = this.clazz.getConstructor(String.class);
                this.panel = c.newInstance(panelId);
            }
            return this.panel;
        }
        catch (Exception x) {
            log.error("Can't instantiate Panel for " + panelId, (Throwable)x);
            return null;
        }
    }

    public IModel<String> getTitle() {
        if (this.titleModel == null) {
            String t = this.getClassStringLoader().loadStringResource(null, this.tabTitlePropertyName);
            if (t == null) {
                t = this.getPackageStringLoader().loadStringResource(this.clazz, this.tabTitlePropertyName, RequestCycle.get().getSession().getLocale(), null);
            }
            return new Model((Serializable)((Object)(t == null ? this.clazzName : t)));
        }
        return this.titleModel;
    }

    public boolean isVisible() {
        return true;
    }
}

