/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.common.model;

import org.apache.wicket.model.AbstractReadOnlyModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElapsedTimeModel
extends AbstractReadOnlyModel<Long> {
    public static final int MILLIS = 1;
    public static final int SECONDS = 1000;
    public static final int MINUTES = 60000;
    public static final int HOURS = 3600000;
    public static final int DAYS = 86400000;
    private long startTime;
    private int unitDivider;
    private boolean reset = false;
    private static final long serialVersionUID = 0L;

    public ElapsedTimeModel() {
        this(System.currentTimeMillis(), 1);
    }

    public ElapsedTimeModel(int divider) {
        this(System.currentTimeMillis(), divider);
    }

    public ElapsedTimeModel(long start, int divider) {
        if (divider == 0) {
            throw new IllegalArgumentException("UNIT divider must not be 0!");
        }
        this.startTime = start;
        this.unitDivider = divider;
    }

    public ElapsedTimeModel setResetAfterGet(boolean b) {
        this.reset = b;
        return this;
    }

    public Long getObject() {
        return this.unitDivider == 1 ? this.getMillis() : this.getMillis() / (long)this.unitDivider;
    }

    public Long getMillis() {
        long t1 = System.currentTimeMillis();
        long diff = t1 - this.startTime;
        if (this.reset) {
            this.startTime = t1;
        }
        return diff;
    }

    public Long getSeconds() {
        return this.getMillis() / 1000L;
    }

    public Long getMinutes() {
        return this.getMillis() / 60000L;
    }

    public Long getHours() {
        return this.getMillis() / 3600000L;
    }

    public Long getDays() {
        return this.getMillis() / 86400000L;
    }
}

