/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.common.markup.modal;

import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxFallbackLink;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.CSSPackageResource;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.resources.CompressedResourceReference;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.util.string.interpolator.PropertyVariableInterpolator;
import org.dcm4chee.web.common.base.BaseWicketPage;
import org.dcm4chee.web.common.exceptions.WicketExceptionWithMsgKey;
import org.dcm4chee.web.common.markup.modal.AutoOpenModalWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageWindow
extends AutoOpenModalWindow {
    private static final long serialVersionUID = 1L;
    protected static final String TITLE_DEFAULT = "MessageWindow";
    public static final String TITLE_INFO = "msgwindow.title.info";
    public static final String TITLE_WARNING = "msgwindow.title.warn";
    public static final String TITLE_ERROR = "msgwindow.title.error";
    private static final ResourceReference baseCSS = new CompressedResourceReference(BaseWicketPage.class, "base-style.css");
    private IModel<String> msgModel;
    private IModel<String> colorModel = new Model((Serializable)((Object)""));

    public MessageWindow(String id) {
        super(id);
        this.initContent();
    }

    public MessageWindow(String id, String titleResource) {
        this(id);
        this.setTitle((IModel)new ResourceModel(titleResource));
    }

    protected void initContent() {
        this.setInitialWidth(300);
        this.setInitialHeight(200);
        this.setTitle((IModel)new ResourceModel(TITLE_INFO, TITLE_DEFAULT));
        this.setPageCreator(new ModalWindow.PageCreator(){
            private static final long serialVersionUID = 1L;

            public Page createPage() {
                return new MessagePage();
            }
        });
    }

    public void setMessage(String msg) {
        this.msgModel = new Model((Serializable)((Object)msg));
    }

    public void setInfoMessage(String msg) {
        this.msgModel = new Model((Serializable)((Object)msg));
        this.setTitle((IModel)new ResourceModel(TITLE_INFO, TITLE_DEFAULT));
    }

    public void setWarningMessage(String msg) {
        this.msgModel = new Model((Serializable)((Object)msg));
        this.setTitle((IModel)new ResourceModel(TITLE_WARNING, TITLE_DEFAULT));
    }

    public void setErrorMessage(String msg) {
        this.msgModel = new Model((Serializable)((Object)msg));
        this.setTitle((IModel)new ResourceModel(TITLE_ERROR, TITLE_DEFAULT));
    }

    public void setErrorMessage(Exception x, boolean useCauseAsDetail) {
        Object detail = null;
        if (useCauseAsDetail && x.getCause() != null) {
            Throwable cause = x.getCause();
            detail = cause instanceof WicketExceptionWithMsgKey ? new ResourceModel(((WicketExceptionWithMsgKey)cause).getMsgKey()).wrapOnAssignment((Component)this) : new Model((Serializable)((Object)this.getExceptionMessage(cause)));
        }
        if (x instanceof WicketExceptionWithMsgKey) {
            WicketExceptionWithMsgKey we = (WicketExceptionWithMsgKey)x;
            this.msgModel = new StringResourceModel(we.getMsgKey(), (Component)this, (IModel)detail, we.getMsgParams());
        } else {
            String msg = detail == null ? this.getExceptionMessage(x) : PropertyVariableInterpolator.interpolate((String)this.getExceptionMessage(x), (Object)detail.getObject());
            this.msgModel = new Model((Serializable)((Object)msg));
        }
        this.setTitle((IModel)new ResourceModel(TITLE_ERROR, TITLE_DEFAULT));
    }

    private String getExceptionMessage(Throwable x) {
        if (x.getLocalizedMessage() != null) {
            return x.getLocalizedMessage();
        }
        if (x.getCause() == null) {
            return x.toString();
        }
        return this.getExceptionMessage(x.getCause());
    }

    @Override
    protected boolean needAutoOpen() {
        return this.msgModel != null;
    }

    @Override
    public void show(AjaxRequestTarget target) {
        if (target != null) {
            super.show(target);
            target.focusComponent(this.get("content:close"));
        }
    }

    public void show(AjaxRequestTarget target, String msg) {
        this.msgModel = new Model((Serializable)((Object)msg));
        this.show(target);
    }

    public void setColor(String color) {
        this.colorModel.setObject((Object)("color: " + color));
    }

    public void show(AjaxRequestTarget target, IModel<String> msg) {
        this.msgModel = msg;
        this.show(target);
    }

    public void show(AjaxRequestTarget target, Exception x, boolean useCauseAsDetail) {
        this.setErrorMessage(x, useCauseAsDetail);
        this.show(target);
    }

    public class MessagePage
    extends WebPage {
        private static final long serialVersionUID = 0L;

        public MessagePage() {
            if (baseCSS != null) {
                this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution((ResourceReference)baseCSS)});
            }
            this.add(new Component[]{new Label("msg", (IModel)new AbstractReadOnlyModel<String>(){
                private static final long serialVersionUID = 1L;

                public String getObject() {
                    return MessageWindow.this.msgModel == null ? null : (String)MessageWindow.this.msgModel.getObject();
                }
            }).add(new IBehavior[]{new AttributeModifier("style", true, MessageWindow.this.colorModel)})});
            this.add(new Component[]{new AjaxFallbackLink<Object>("close"){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    MessageWindow.this.close(target);
                }
            }.add(new Component[]{new Label("closeLabel", (IModel)new ResourceModel("closeBtn"))})});
        }

        public boolean isVisible() {
            return true;
        }

        protected void onAfterRender() {
            MessageWindow.this.msgModel = null;
            super.onAfterRender();
        }
    }
}

