/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.common.markup.modal;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.markup.html.AjaxFallbackLink;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxFallbackLink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.CSSPackageResource;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.html.resources.CompressedResourceReference;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.dcm4chee.web.common.ajax.MaskingAjaxCallBehavior;
import org.dcm4chee.web.common.base.BaseWicketPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConfirmationWindow<T>
extends ModalWindow {
    private static final long serialVersionUID = 1L;
    public static final String FOCUS_ON_CONFIRM = "content:confirm";
    public static final String FOCUS_ON_DECLINE = "content:decline";
    public static final String FOCUS_ON_CANCEL = "content:cancel";
    public static final int UNCONFIRMED = 0;
    public static final int CONFIRMED = 1;
    public static final int DECLINED = 2;
    public static final int CANCELED = 3;
    private T userObject;
    private String focusElementId;
    private IModel<?> remark;
    private IModel<?> confirm;
    private IModel<?> decline;
    private IModel<?> cancel;
    protected boolean hasStatus;
    private boolean showCancel = false;
    private int state = 0;
    public MessageWindowPanel messageWindowPanel;
    private static final ResourceReference baseCSS = new CompressedResourceReference(BaseWicketPage.class, "base-style.css");

    public ConfirmationWindow(String id, String titleResource) {
        this(id);
        this.setTitle((IModel)new ResourceModel(titleResource));
    }

    public ConfirmationWindow(String id) {
        this(id, (IModel<?>)new ResourceModel("yesBtn"), (IModel<?>)new ResourceModel("noBtn"), (IModel<?>)new ResourceModel("cancelBtn"));
        this.setCloseButtonCallback(new ModalWindow.CloseButtonCallback(){
            private static final long serialVersionUID = 1L;

            public boolean onCloseButtonClicked(AjaxRequestTarget target) {
                ConfirmationWindow.this.messageWindowPanel.msg = null;
                ConfirmationWindow.this.close(target);
                return true;
            }
        });
        this.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
            private static final long serialVersionUID = 1L;

            public void onClose(AjaxRequestTarget target) {
                ConfirmationWindow.this.getPage().setOutputMarkupId(true);
                target.addComponent((Component)ConfirmationWindow.this.getPage());
            }
        });
    }

    public ConfirmationWindow(String id, IModel<?> confirm, IModel<?> decline, IModel<?> cancel) {
        super(id);
        this.confirm = confirm;
        this.decline = decline;
        this.cancel = cancel;
        this.initContent();
    }

    protected void initContent() {
        this.setInitialWidth(400);
        this.setInitialHeight(300);
        this.messageWindowPanel = new MessageWindowPanel("panel");
        this.setPageCreator(new ModalWindow.PageCreator(){
            private static final long serialVersionUID = 1L;

            public Page createPage() {
                return new ConfirmPage();
            }
        });
        this.add(new IBehavior[]{new DisableDefaultConfirmBehavior()});
    }

    public abstract void onConfirmation(AjaxRequestTarget var1, T var2);

    public void onDecline(AjaxRequestTarget target, T userObject) {
    }

    public void onCancel(AjaxRequestTarget target, T userObject) {
    }

    public void onOk(AjaxRequestTarget target) {
    }

    public void show(AjaxRequestTarget target) {
        this.hasStatus = false;
        super.show(target);
        if (this.focusElementId != null) {
            target.focusComponent(this.get(this.focusElementId));
        }
    }

    public void confirm(AjaxRequestTarget target, IModel<?> msg, T userObject) {
        this.confirm(target, msg, userObject, FOCUS_ON_DECLINE);
    }

    public void confirm(AjaxRequestTarget target, IModel<?> msg, T userObject, String focusElementId) {
        this.confirm(target, msg, userObject, focusElementId, false);
    }

    public void confirm(AjaxRequestTarget target, IModel<?> msg, T userObject, String focusElementId, boolean showCancel) {
        this.messageWindowPanel.msg = msg;
        this.userObject = userObject;
        this.focusElementId = focusElementId;
        this.showCancel = showCancel;
        this.show(target);
    }

    public void confirmWithCancel(AjaxRequestTarget target, IModel<?> msg, T userObject) {
        this.confirm(target, msg, userObject, FOCUS_ON_CANCEL, true);
    }

    public void setStatus(IModel<?> statusMsg) {
        this.messageWindowPanel.msg = statusMsg;
        this.hasStatus = true;
    }

    public void setRemark(IModel<?> remark) {
        this.remark = remark;
    }

    public T getUserObject() {
        return this.userObject;
    }

    public int getState() {
        return this.state;
    }

    public MessageWindowPanel getMessageWindowPanel() {
        return this.messageWindowPanel;
    }

    public class DisableDefaultConfirmBehavior
    extends AbstractBehavior
    implements IHeaderContributor {
        private static final long serialVersionUID = 1L;

        public void renderHead(IHeaderResponse response) {
            response.renderOnDomReadyJavascript("Wicket.Window.unloadConfirmation = false");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MessageWindowPanel
    extends Panel {
        private static final long serialVersionUID = 1L;
        private final Logger log;
        private IndicatingAjaxFallbackLink<Object> confirmBtn;
        private AjaxFallbackLink<Object> okBtn;
        private IModel<?> msg;
        private Label msgLabel;
        private Label remarkLabel;
        private boolean logout;

        public MessageWindowPanel(String id) {
            super(id);
            this.log = LoggerFactory.getLogger(MessageWindowPanel.class);
            this.logout = false;
            final MaskingAjaxCallBehavior macb = new MaskingAjaxCallBehavior();
            this.add(new IBehavior[]{macb});
            Component[] componentArray = new Component[1];
            this.msgLabel = new Label("msg", (IModel)new AbstractReadOnlyModel<Object>(){
                private static final long serialVersionUID = 1L;

                public Object getObject() {
                    return MessageWindowPanel.this.msg == null ? null : MessageWindowPanel.this.msg.getObject();
                }
            });
            componentArray[0] = this.msgLabel.setOutputMarkupId(true).setEscapeModelStrings(false);
            this.add(componentArray);
            Component[] componentArray2 = new Component[1];
            this.remarkLabel = new Label("remark", (IModel)new AbstractReadOnlyModel<Object>(){
                private static final long serialVersionUID = 1L;

                public Object getObject() {
                    return ConfirmationWindow.this.remark == null ? null : ConfirmationWindow.this.remark.getObject();
                }
            }){
                private static final long serialVersionUID = 1L;

                public boolean isVisible() {
                    return !ConfirmationWindow.this.hasStatus;
                }
            };
            componentArray2[0] = this.remarkLabel.setOutputMarkupId(true);
            this.add(componentArray2);
            this.confirmBtn = new IndicatingAjaxFallbackLink<Object>("confirm"){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    try {
                        ConfirmationWindow.this.onConfirmation(target, ConfirmationWindow.this.userObject);
                        ConfirmationWindow.this.state = 1;
                        if (ConfirmationWindow.this.hasStatus) {
                            target.addComponent((Component)MessageWindowPanel.this);
                        } else {
                            MessageWindowPanel.this.msg = null;
                            ConfirmationWindow.this.close(target);
                        }
                    }
                    catch (Exception x) {
                        MessageWindowPanel.this.logout = true;
                        ConfirmationWindow.this.setStatus((IModel<?>)new Model((Serializable)((Object)x.getMessage())));
                        target.addComponent((Component)MessageWindowPanel.this);
                    }
                }

                public boolean isVisible() {
                    return !ConfirmationWindow.this.hasStatus;
                }

                protected IAjaxCallDecorator getAjaxCallDecorator() {
                    try {
                        return macb.getAjaxCallDecorator();
                    }
                    catch (Exception e) {
                        MessageWindowPanel.this.log.error("Failed to get IAjaxCallDecorator: ", (Throwable)e);
                        return null;
                    }
                }
            };
            this.confirmBtn.add(new Component[]{new Label("confirmLabel", ConfirmationWindow.this.confirm)});
            this.confirmBtn.setOutputMarkupId(true);
            this.add(new Component[]{this.confirmBtn});
            this.add(new Component[]{new AjaxFallbackLink<Object>("decline"){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    ConfirmationWindow.this.onDecline(target, ConfirmationWindow.this.userObject);
                    ConfirmationWindow.this.state = 2;
                    if (ConfirmationWindow.this.hasStatus) {
                        target.addComponent((Component)MessageWindowPanel.this);
                    } else {
                        MessageWindowPanel.this.msg = null;
                        ConfirmationWindow.this.close(target);
                    }
                }

                public boolean isVisible() {
                    return !ConfirmationWindow.this.hasStatus;
                }
            }.add(new Component[]{new Label("declineLabel", ConfirmationWindow.this.decline)})});
            this.add(new Component[]{new AjaxFallbackLink<Object>("cancel"){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    ConfirmationWindow.this.onCancel(target, ConfirmationWindow.this.userObject);
                    ConfirmationWindow.this.state = 3;
                    MessageWindowPanel.this.msg = null;
                    ConfirmationWindow.this.close(target);
                }

                public boolean isVisible() {
                    return !ConfirmationWindow.this.hasStatus && ConfirmationWindow.this.showCancel;
                }
            }.add(new Component[]{new Label("cancelLabel", ConfirmationWindow.this.cancel)})});
            Component[] componentArray3 = new Component[1];
            this.okBtn = new IndicatingAjaxFallbackLink<Object>("ok"){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    if (MessageWindowPanel.this.logout) {
                        ConfirmationWindow.this.onConfirmation(target, ConfirmationWindow.this.userObject);
                    } else {
                        ConfirmationWindow.this.onOk(target);
                    }
                    MessageWindowPanel.this.msg = null;
                    ConfirmationWindow.this.close(target);
                }

                public boolean isVisible() {
                    return ConfirmationWindow.this.hasStatus;
                }

                protected IAjaxCallDecorator getAjaxCallDecorator() {
                    try {
                        return macb.getAjaxCallDecorator();
                    }
                    catch (Exception e) {
                        MessageWindowPanel.this.log.error("Failed to get IAjaxCallDecorator: ", (Throwable)e);
                        return null;
                    }
                }
            };
            componentArray3[0] = this.okBtn;
            this.add(componentArray3);
            this.getOkBtn().add(new Component[]{new Label("okLabel", (IModel)new ResourceModel("okBtn"))});
            this.getOkBtn().setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true);
            this.setOutputMarkupId(true);
        }

        public boolean isVisible() {
            return true;
        }

        public AjaxFallbackLink<Object> getOkBtn() {
            return this.okBtn;
        }

        public Label getMsgLabel() {
            return this.msgLabel;
        }

        public Label getRemarkLabel() {
            return this.remarkLabel;
        }
    }

    public class ConfirmPage
    extends WebPage {
        public ConfirmPage() {
            if (baseCSS != null) {
                this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution((ResourceReference)baseCSS)});
            }
            this.add(new Component[]{ConfirmationWindow.this.messageWindowPanel});
        }
    }
}

