/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.common.markup;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeField
extends TextField<Date>
implements AbstractTextComponent.ITextFormatProvider {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(TimeField.class);

    public TimeField(String id, IModel<Date> model) {
        super(id, model);
        this.setType(Date.class);
    }

    public void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (tag.getAttribute("class") == null) {
            tag.put("class", (CharSequence)"timeField");
        }
    }

    protected void convertInput() {
        super.convertInput();
    }

    public IConverter getConverter(Class<?> type) {
        return new IConverter(){
            private static final long serialVersionUID = 1L;
            private Calendar cal = Calendar.getInstance();

            public Object convertToObject(String value, Locale locale) {
                return TimeField.this.convert(value);
            }

            public String convertToString(Object value, Locale locale) {
                this.cal.setTime((Date)value);
                int m = this.cal.get(12);
                return this.cal.get(11) + ":" + (m < 10 ? "0" + m : String.valueOf(m));
            }
        };
    }

    public String getTextFormat() {
        return "HH:mm";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Date convert(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        int pos = value.indexOf(58);
        int posMinStart = -1;
        try {
            int m;
            if (pos == -1) {
                int len = value.length();
                if (len < 3) {
                    pos = len;
                } else {
                    if (len >= 5) {
                        log.info("Convert time String to date failed! Missing ':' value:" + value);
                        throw new ConversionException("Missing ':'");
                    }
                    posMinStart = pos = len - 2;
                }
            } else {
                posMinStart = pos + 1;
            }
            int h = Integer.parseInt(value.substring(0, pos));
            int n = m = posMinStart == -1 ? 0 : Integer.parseInt(value.substring(posMinStart));
            if (h >= 0 && h <= 23 && m >= 0 && m <= 59) {
                cal.set(11, h);
                cal.set(12, m);
                cal.set(13, 0);
                cal.set(14, 0);
                return cal.getTime();
            }
            log.info("Convert time String to date failed! Hour or minutes not in range! value:" + value);
            throw new ConversionException("Hour or minutes invalid!");
        }
        catch (Exception x) {
            log.info("Convert time String to date failed! Exception thrown! value:" + value, (Throwable)x);
            throw new ConversionException("Hour or minutes invalid!");
        }
    }
}

