/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.common.markup;

import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatientNameField
extends FormComponentPanel<String> {
    private static final long serialVersionUID = 1L;
    private boolean useFnGn;
    private TextField<String> pnField;
    private TextField<String> fnField;
    private TextField<String> gnField;
    private static Logger log = LoggerFactory.getLogger(PatientNameField.class);

    public PatientNameField(String id, IModel<String> model, boolean useFnGn) {
        super(id, model);
        this.useFnGn = useFnGn;
        this.setType(String.class);
        this.add(new Component[]{new Label("pnLabel", (IModel)new ResourceModel("patientname.label")).setVisible(!useFnGn)});
        this.pnField = new TextField("pnField", model);
        this.add(new Component[]{this.pnField.setVisible(!useFnGn)});
        this.add(new Component[]{new Label("fnLabel", (IModel)new ResourceModel("familyname.label")).setVisible(useFnGn)});
        this.fnField = new TextField("fnField", (IModel)new FamilyNameModel(this));
        this.add(new Component[]{this.fnField.setVisible(useFnGn)});
        this.add(new Component[]{new Label("gnLabel", (IModel)new ResourceModel("givenname.label")).setVisible(useFnGn)});
        this.gnField = new TextField("gnField", (IModel)new GivenNameModel(this));
        this.add(new Component[]{this.gnField.setVisible(useFnGn)});
    }

    public boolean isUseFnGn() {
        return this.useFnGn;
    }

    public void setUseFnGn(boolean useFnGn) {
        this.useFnGn = useFnGn;
    }

    public void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (tag.getAttribute("class") == null) {
            tag.put("class", (CharSequence)"patientField");
        }
    }

    public String getInput() {
        return this.useFnGn ? this.fnField.getInput() + "^" + this.gnField.getInput() : this.pnField.getInput();
    }

    protected void convertInput() {
        int pos;
        String converted;
        String fn = (String)this.fnField.getConvertedInput();
        if (!this.useFnGn) {
            converted = (String)this.pnField.getConvertedInput();
        } else if (fn != null && (pos = fn.indexOf(94)) != -1) {
            converted = pos == fn.lastIndexOf(94) ? fn.substring(0, pos) + "*" + fn.substring(pos) + "*" : fn;
        } else {
            String gn = (String)this.gnField.getConvertedInput();
            String string = converted = fn == null ? "" : fn;
            if (gn != null && gn.length() != 0) {
                if (!converted.endsWith("*")) {
                    converted = converted + "*";
                }
                converted = converted + "^" + gn;
                if (gn.indexOf(94) == -1 && !converted.endsWith("*")) {
                    converted = converted + "*";
                }
            }
        }
        this.setConvertedInput(converted);
        log.debug("Converted Input:{}", this.getConvertedInput());
    }

    public Component addToDateField(IBehavior ... behaviors) {
        this.fnField.add(behaviors);
        return this;
    }

    public Component addToTimeField(IBehavior ... behaviors) {
        this.gnField.add(behaviors);
        return this;
    }

    private class GivenNameModel
    extends FamilyNameModel {
        private static final long serialVersionUID = 1L;

        public GivenNameModel(PatientNameField tf) {
            super(tf);
        }

        public String getObject() {
            String gn;
            String n = (String)this.tf.getModelObject();
            if (n == null) {
                return null;
            }
            int pos = n.indexOf(94);
            if (pos == -1) {
                return null;
            }
            return (gn = n.substring(++pos)).indexOf(94) != -1 ? gn : this.toViewString(gn);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FamilyNameModel
    implements IModel<String> {
        private static final long serialVersionUID = 1L;
        protected PatientNameField tf;

        public FamilyNameModel(PatientNameField tf) {
            this.tf = tf;
        }

        public String getObject() {
            String n = (String)this.tf.getModelObject();
            if (n == null) {
                return null;
            }
            int pos = n.indexOf(94);
            if (pos == -1) {
                return n;
            }
            String fn = n.substring(0, pos);
            return n.substring(++pos).indexOf(94) != -1 ? fn : this.toViewString(fn);
        }

        protected String toViewString(String s) {
            return s != null && s.endsWith("*") ? s.substring(0, s.length() - 1) : s;
        }

        public void setObject(String object) {
        }

        public void detach() {
        }
    }
}

