/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.common.login;

import javax.security.auth.Subject;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.security.authentication.LoginException;
import org.apache.wicket.security.hive.authentication.DefaultSubject;
import org.apache.wicket.security.hive.authentication.LoginContext;
import org.dcm4chee.web.common.delegate.BaseCfgDelegate;
import org.dcm4chee.web.common.delegate.BaseMBeanDelegate;
import org.dcm4chee.web.common.login.LoginContextSecurityHelper;
import org.dcm4chee.web.common.secure.SecureSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSOLoginContext
extends LoginContext {
    protected static Logger log = LoggerFactory.getLogger(BaseMBeanDelegate.class);
    SecureSession session;
    private Subject jaasSubject;

    public SSOLoginContext() {
    }

    public SSOLoginContext(SecureSession secureSession, Subject jaasSubject) {
        this.session = secureSession;
        this.jaasSubject = jaasSubject;
    }

    public final org.apache.wicket.security.hive.authentication.Subject login() throws LoginException {
        if (this.jaasSubject == null) {
            throw new LoginException("Insufficient information to login");
        }
        return this.getSubject(this.jaasSubject);
    }

    protected org.apache.wicket.security.hive.authentication.Subject getSubject(Subject jaasSubject) throws LoginException {
        DefaultSubject subject;
        if (this.session == null) {
            try {
                this.session = (SecureSession)RequestCycle.get().getSession();
            }
            catch (Exception e) {
                log.warn("SSO Login failed. Reason: " + e.getMessage());
                throw new LoginException();
            }
        }
        this.session.setManageUsers(BaseCfgDelegate.getInstance().getManageUsers());
        if (!this.readHiveFile()) {
            return null;
        }
        try {
            subject = LoginContextSecurityHelper.mapSwarmSubject(jaasSubject, this.session);
            if (!LoginContextSecurityHelper.checkLoginAllowed(subject)) {
                this.session.invalidate();
                RequestCycle.get().getResponse().redirect("");
                log.warn("Failed to authorize subject for login, denied. See 'LoginAllowedRolename' parameter in web.xml.");
            } else {
                this.session.extendedLogin((org.apache.wicket.security.hive.authentication.Subject)subject);
            }
        }
        catch (Exception e) {
            log.error("Login failed for JAAS subject: " + jaasSubject, (Throwable)e);
            this.session.invalidate();
            return new DefaultSubject();
        }
        return subject;
    }

    private boolean readHiveFile() {
        try {
            this.session.setAllSwarmPrincipals(LoginContextSecurityHelper.readSwarmPrincipals());
            return true;
        }
        catch (Exception e) {
            log.error("Exception (error processing hive file): " + e.getMessage());
            this.session.invalidate();
            return false;
        }
    }
}

