/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.common.delegate;

import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.dcm4chee.web.common.delegate.BaseCfgDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMBeanDelegate {
    protected ObjectName serviceObjectName;
    protected static MBeanServerConnection server;
    protected static Logger log;

    public BaseMBeanDelegate() {
        this.init();
    }

    protected void init() {
        log.info("Init MBeanDelegate! server:" + server + " serviceObjectName:" + this.serviceObjectName);
        if (server == null) {
            ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
            if (servers != null && !servers.isEmpty()) {
                server = (MBeanServerConnection)servers.get(0);
                log.debug("Found MBeanServer:" + server);
            } else {
                log.error("Failed to get MBeanServerConnection! MbeanDelegate class:" + this.getClass().getName());
                return;
            }
        }
        if (this.serviceObjectName == null) {
            try {
                this.serviceObjectName = BaseCfgDelegate.getInstance().getObjectName(this.getServiceNameCfgAttribute(), this.getDefaultServiceObjectName());
                log.info("MBeanDelegate initialized! serviceName:" + this.serviceObjectName);
            }
            catch (Exception e) {
                log.error("Failed to set ObjectName for MBeanService! serviceNameCfgAttribute:" + this.getServiceNameCfgAttribute(), (Throwable)e);
            }
        }
    }

    public abstract String getServiceNameCfgAttribute();

    public String getDefaultServiceObjectName() {
        return null;
    }

    public boolean isInitialized() {
        return this.serviceObjectName != null;
    }

    static {
        log = LoggerFactory.getLogger(BaseMBeanDelegate.class);
    }
}

