/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.common.delegate;

import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.wicket.Application;
import org.apache.wicket.protocol.http.WebApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseCfgDelegate {
    protected static BaseCfgDelegate singleton;
    protected ObjectName serviceObjectName;
    protected MBeanServerConnection server;
    protected static Logger log;

    protected BaseCfgDelegate() {
        this.init();
    }

    public static BaseCfgDelegate getInstance() {
        if (singleton == null) {
            singleton = new BaseCfgDelegate();
        }
        return singleton;
    }

    public boolean getManageUsers() {
        return this.getBoolean("manageUsers", true);
    }

    public String getWebConfigPath() {
        return this.getString("WebConfigPath");
    }

    public int[] getWindowSize(String name) {
        if (this.server == null) {
            return new int[]{800, 600};
        }
        try {
            return (int[])this.server.invoke(this.serviceObjectName, "getWindowSize", new Object[]{name}, new String[]{String.class.getName()});
        }
        catch (Exception x) {
            log.warn("Cant invoke getWindowSize, using 800,600 as default!", (Throwable)x);
            return new int[]{800, 600};
        }
    }

    public ObjectName getObjectName(String attrName, String defaultName) throws MalformedObjectNameException, NullPointerException {
        if (this.server == null) {
            return defaultName == null ? null : new ObjectName(defaultName);
        }
        try {
            return (ObjectName)this.server.getAttribute(this.serviceObjectName, attrName);
        }
        catch (Throwable t) {
            log.error("Can't get ObjectName for " + attrName + " ! use default:" + defaultName, t);
            return defaultName == null ? null : new ObjectName(defaultName);
        }
    }

    protected String getString(String attrName) {
        if (this.server == null) {
            return null;
        }
        try {
            return (String)this.server.getAttribute(this.serviceObjectName, attrName);
        }
        catch (Exception x) {
            log.warn("Cant get " + attrName + "! Ignored by return null!", (Throwable)x);
            return null;
        }
    }

    protected boolean getBoolean(String attrName, boolean defVal) {
        if (this.server == null) {
            return defVal;
        }
        try {
            return (Boolean)this.server.getAttribute(this.serviceObjectName, attrName);
        }
        catch (Exception x) {
            log.warn("Cant get " + attrName + " attribute! return " + defVal + " as default!", (Throwable)x);
            return defVal;
        }
    }

    protected Integer getInteger(String attrName, int defVal) {
        if (this.server == null) {
            return null;
        }
        try {
            return (Integer)this.server.getAttribute(this.serviceObjectName, attrName);
        }
        catch (Exception x) {
            log.warn("Cant get " + attrName + " attribute! return " + defVal + " as default!", (Throwable)x);
            return null;
        }
    }

    public Object invoke(String opName, Object[] args, Object defVal) {
        try {
            if (args == null) {
                args = new Object[]{};
            }
            String[] argTypes = new String[args.length];
            for (int i = 0; i < args.length; ++i) {
                argTypes[i] = args.getClass().getName();
            }
            return this.server.invoke(this.serviceObjectName, opName, args, argTypes);
        }
        catch (Exception x) {
            log.warn("Cant invoke " + opName + "! Return defVal:" + defVal, (Throwable)x);
            return defVal;
        }
    }

    protected void init() {
        log.info("Init " + this.getClass().getName());
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        if (servers == null || servers.isEmpty()) {
            log.error("Failed to get MBeanServerConnection! MbeanDelegate class:" + this.getClass().getName());
            return;
        }
        this.server = (MBeanServerConnection)servers.get(0);
        log.debug("Found MBeanServer:" + this.server);
        String s = ((WebApplication)Application.get()).getInitParameter("WebCfgServiceName");
        if (s == null) {
            s = "dcm4chee.web:service=WebConfig";
        }
        try {
            this.serviceObjectName = new ObjectName(s);
            log.info(this.getClass().getName() + " initialized! WebConfig serviceName: " + this.serviceObjectName);
        }
        catch (Exception e) {
            log.error("Failed to set ObjectName for " + this.getClass().getName() + "! name:" + s, (Throwable)e);
        }
    }

    public MBeanServerConnection getMBeanServer() {
        return this.server;
    }

    protected List<String> getStringList(String name) {
        if (this.server == null) {
            return new ArrayList<String>();
        }
        try {
            return (List)this.server.invoke(this.serviceObjectName, name, new Object[0], new String[0]);
        }
        catch (Exception e) {
            log.warn("Cant invoke '" + name + "', returning empty list.", (Throwable)e);
            return new ArrayList<String>();
        }
    }

    protected List<Integer> getIntegerList(String name, List<Integer> defValue) {
        if (this.server != null) {
            try {
                return (List)this.server.invoke(this.serviceObjectName, name, new Object[0], new String[0]);
            }
            catch (Exception e) {
                log.warn("Cant invoke '" + name + "', returning defValue:" + defValue, (Throwable)e);
            }
        }
        return defValue == null ? new ArrayList() : defValue;
    }

    static {
        log = LoggerFactory.getLogger(BaseCfgDelegate.class);
    }
}

