/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.common.behaviours;

import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.Localizer;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.dcm4chee.web.common.markup.BaseForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TooltipBehaviour
extends AbstractBehavior {
    private static final long serialVersionUID = 1L;
    private static final String POSTFIX = ".tooltip";
    private String prefix;
    private String id;
    private transient Localizer localizer;
    private IModel<?> substitutionModel;
    private AbstractReadOnlyModel<Boolean> showTooltipModel;
    private boolean generateComponentTreePrefix;

    public TooltipBehaviour(String prefix) {
        this.prefix = prefix;
    }

    public TooltipBehaviour(String prefix, String id) {
        this.prefix = prefix;
        this.id = id;
    }

    public TooltipBehaviour(String prefix, String id, IModel<?> substitutionModel) {
        this(prefix, id);
        this.substitutionModel = substitutionModel;
    }

    public TooltipBehaviour(String prefix, String id, AbstractReadOnlyModel<Boolean> showTooltipModel) {
        this(prefix, id);
        this.showTooltipModel = showTooltipModel;
    }

    public TooltipBehaviour setGenerateComponentTreePrefix() {
        this.generateComponentTreePrefix = true;
        return this;
    }

    public void onComponentTag(Component c, ComponentTag tag) {
        String currentTitle = tag.getAttribute("title");
        tag.put("title", (CharSequence)(currentTitle != null ? currentTitle + " " : "" + this.getLocalizer().getStringIgnoreSettings(this.getResourceKey(c), c, this.substitutionModel, "")));
    }

    String getResourceKey(Component c) {
        if (this.generateComponentTreePrefix) {
            this.prefix = this.generateComponentTreePrefix(c);
        }
        StringBuilder sb = new StringBuilder();
        if (this.prefix != null) {
            sb.append(this.prefix);
        }
        sb.append(this.id == null ? c.getId() : this.id);
        sb.append(this.showTooltipModel == null ? "" : "." + ((Boolean)this.showTooltipModel.getObject() != false ? "hide" : "show"));
        sb.append(POSTFIX);
        return sb.toString();
    }

    private String generateComponentTreePrefix(Component c) {
        this.generateComponentTreePrefix = false;
        StringBuilder sb = new StringBuilder("");
        for (MarkupContainer parent = c.getParent(); parent != null && !parent.equals("") && !(parent instanceof BaseForm); parent = parent.getParent()) {
            sb.insert(0, ".");
            sb.insert(0, parent.getId());
        }
        if (this.prefix != null && !this.prefix.equals("")) {
            sb.insert(0, this.prefix);
        }
        return sb.toString();
    }

    public Localizer getLocalizer() {
        if (this.localizer == null) {
            this.localizer = Application.get().getResourceSettings().getLocalizer();
        }
        return this.localizer;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public TooltipBehaviour newWithSubstitution(IModel<?> model) {
        return new TooltipBehaviour(this.prefix, this.id, model);
    }

    public String getTooltip(Component c) {
        return this.getLocalizer().getStringIgnoreSettings(this.getResourceKey(c), c, this.substitutionModel, "");
    }
}

