/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.common.behaviours;

import java.util.Calendar;
import java.util.Date;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.calldecorator.CancelEventIfNoAjaxDecorator;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.model.IModel;
import org.dcm4chee.web.common.markup.SimpleDateTimeField;
import org.dcm4chee.web.common.util.DateUtils;

public class CheckOneDayBehaviour
extends AjaxFormSubmitBehavior {
    private static final long serialVersionUID = 5109347770809331652L;
    private SimpleDateTimeField dtfStart;
    private SimpleDateTimeField dtfEnd;
    private Date oldStart;

    public CheckOneDayBehaviour(SimpleDateTimeField dtfStart, SimpleDateTimeField dtfEnd, String event) {
        super(event);
        this.dtfStart = dtfStart;
        this.dtfEnd = dtfEnd;
    }

    protected void onEvent(AjaxRequestTarget target) {
        this.oldStart = (Date)this.dtfStart.getModelObject();
        if (this.oldStart != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.oldStart);
            DateUtils.setTimeToMinOrMax(cal, !this.dtfEnd.isWithoutTime());
            this.oldStart = cal.getTime();
        }
        super.onEvent(target);
    }

    protected void onSubmit(AjaxRequestTarget target) {
        this.setEndDate(target);
    }

    private void setEndDate(AjaxRequestTarget target) {
        Date startDate = (Date)this.dtfStart.getModelObject();
        Date endDate = (Date)this.dtfEnd.getModelObject();
        IModel mEnd = this.dtfEnd.getModel();
        if (startDate != null && (endDate == null || endDate.equals(this.oldStart))) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(startDate);
            DateUtils.setTimeToMinOrMax(cal, !this.dtfEnd.isWithoutTime());
            mEnd.setObject((Object)cal.getTime());
            target.addComponent((Component)this.dtfStart);
            target.addComponent((Component)this.dtfEnd);
        }
    }

    protected IAjaxCallDecorator getAjaxCallDecorator() {
        return new CancelEventIfNoAjaxDecorator(null);
    }

    protected void onError(AjaxRequestTarget target) {
        this.setEndDate(target);
    }
}

