/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.common.base;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.Cookie;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.Session;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxFallbackLink;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.CSSPackageResource;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.security.swarm.SwarmWebApplication;
import org.dcm4chee.web.common.markup.modal.ConfirmationWindow;
import org.dcm4chee.web.common.model.ProgressProvider;
import org.dcm4chee.web.common.secure.SecureAjaxTabbedPanel;
import org.dcm4chee.web.common.secure.SecureSession;
import org.dcm4chee.web.common.util.CloseRequestSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleSelectorPanel
extends SecureAjaxTabbedPanel {
    private static final long serialVersionUID = 1L;
    public boolean showLogout = true;
    private static Logger log = LoggerFactory.getLogger(ModuleSelectorPanel.class);
    private static final long LAST_REFRESHED_TIMEOUT = 5000L;
    private boolean popupsClosed = false;
    ConfirmationWindow<List<ProgressProvider>> confirmLogout = new ConfirmationWindow<List<ProgressProvider>>("confirmLogout"){
        private static final long serialVersionUID = 1L;

        @Override
        public void onConfirmation(AjaxRequestTarget target, List<ProgressProvider> providers) {
            if (ModuleSelectorPanel.this.popupsClosed) {
                this.getSession().invalidate();
                return;
            }
            if (ModuleSelectorPanel.this.closePopups(providers)) {
                ModuleSelectorPanel.this.popupsClosed = true;
                throw new IllegalStateException(ModuleSelectorPanel.this.getString("logout.logout"));
            }
            if (ModuleSelectorPanel.this.isPopupOpen(providers)) {
                throw new IllegalStateException(ModuleSelectorPanel.this.getString("logout.waiting"));
            }
        }
    };

    public ModuleSelectorPanel(String id) {
        super(id);
        boolean found = false;
        Cookie[] cs = ((WebRequest)RequestCycle.get().getRequest()).getHttpServletRequest().getCookies();
        if (cs != null) {
            for (Cookie c : cs) {
                if (!c.getName().equals("WEB3LOCALE")) continue;
                this.getSession().setLocale(new Locale(c.getValue()));
                found = true;
                break;
            }
        }
        if (!found) {
            Cookie c = new Cookie("WEB3LOCALE", this.getSession().getLocale().getCountry().toLowerCase());
            c.setMaxAge(Integer.MAX_VALUE);
            ((WebResponse)RequestCycle.get().getResponse()).addCookie(c);
        }
        this.add(new Component[]{this.confirmLogout});
        try {
            InputStream is = ((SwarmWebApplication)this.getApplication()).getServletContext().getResourceAsStream("/WEB-INF/web.xml");
            XMLReader parser = XMLReaderFactory.createXMLReader();
            DefaultHandler dh = new DefaultHandler(){
                private StringBuffer current;

                public void characters(char[] ch, int start, int length) throws SAXException {
                    this.current = new StringBuffer().append(ch, start, length);
                }

                public void endElement(String uri, String localName, String qName) throws SAXException {
                    if (qName.equals("auth-method") && this.current.toString().equals("BASIC")) {
                        ModuleSelectorPanel.this.showLogout = false;
                    }
                }
            };
            parser.setContentHandler(dh);
            parser.parse(new InputSource(is));
        }
        catch (Exception ignore) {
            // empty catch block
        }
        this.add(new Component[]{new AjaxFallbackLink<Object>("logout"){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                List<ProgressProvider> providers = null;
                Session s = this.getSession();
                if (s instanceof SecureSession && (providers = ((SecureSession)s).getProgressProviders()).size() > 0) {
                    ModuleSelectorPanel.this.confirmLogout.confirm(target, (IModel<?>)new ResourceModel("logout.confirmPendingTasks").wrapOnAssignment((Component)this), providers);
                    return;
                }
                this.getSession().invalidate();
                this.setResponsePage(this.getApplication().getHomePage());
            }

            public boolean isVisible() {
                return ModuleSelectorPanel.this.showLogout;
            }
        }.add(new Component[]{new Label("logoutLabel", (IModel)new StringResourceModel("logout", (Component)this, null, new Object[]{((SecureSession)RequestCycle.get().getSession()).getUsername()}))})});
        ArrayList<String> languages = new ArrayList<String>();
        languages.add("en");
        languages.add("de");
        languages.add("ja");
        DropDownChoice<String> languageSelector = new DropDownChoice<String>("language", (IModel)new Model(), languages, (IChoiceRenderer)new ChoiceRenderer<String>(){
            private static final long serialVersionUID = 1L;

            public String getDisplayValue(String object) {
                Locale l = new Locale(object);
                return l.getDisplayName(l);
            }
        }){
            private static final long serialVersionUID = 1L;

            protected void onSelectionChanged(String newSelection) {
                Cookie c = new Cookie("WEB3LOCALE", newSelection);
                c.setMaxAge(Integer.MAX_VALUE);
                ((WebResponse)RequestCycle.get().getResponse()).addCookie(c);
                this.getSession().setLocale(new Locale(newSelection));
            }
        };
        languageSelector.setDefaultModelObject((Object)this.getSession().getLocale().getLanguage());
        languageSelector.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange", (DropDownChoice)languageSelector){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ DropDownChoice val$languageSelector;
            {
                this.val$languageSelector = dropDownChoice;
                super(x0);
            }

            protected void onUpdate(AjaxRequestTarget target) {
                this.val$languageSelector.onSelectionChanged();
                target.addComponent(ModuleSelectorPanel.this.getPage().setOutputMarkupId(true));
            }
        }});
        this.add(new Component[]{languageSelector});
        this.add(new Component[]{new Image("img_logo", new ResourceReference(ModuleSelectorPanel.class, "images/logo.gif"))});
    }

    public void addModule(Class<? extends Panel> clazz) {
        super.addModule(clazz, null);
        if (clazz.getResource("base-style.css") != null) {
            this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution(clazz, (String)"base-style.css")});
        }
    }

    public void addInstance(Panel instance) {
        this.addInstance(instance, null);
    }

    public void addInstance(Panel instance, IModel<String> titleModel) {
        super.addModule(instance.getClass(), titleModel);
        if (instance.getClass().getResource("base-style.css") != null) {
            this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution(instance.getClass(), (String)"base-style.css")});
        }
    }

    public ModuleSelectorPanel setShowLogoutLink(boolean show) {
        this.showLogout = show;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean closePopups(List<ProgressProvider> providers) {
        boolean b = false;
        if (providers != null) {
            List<ProgressProvider> list = providers;
            synchronized (list) {
                int len = providers.size();
                for (int i = 0; i < len; ++i) {
                    Integer pageID = providers.get(i).getPopupPageId();
                    log.info("Provider has status: " + providers.get(i).getStatus());
                    if (pageID == null) continue;
                    Page p = this.getSession().getPage(pageID.intValue(), 0);
                    log.info("Found open popup page:" + p);
                    if (p == null || !(p instanceof CloseRequestSupport)) continue;
                    log.debug("Set close request for popup page:" + p);
                    if (((CloseRequestSupport)p).isCloseRequested()) continue;
                    ((CloseRequestSupport)p).setCloseRequest();
                    b = true;
                }
            }
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPopupOpen(List<ProgressProvider> providers) {
        if (providers != null) {
            List<ProgressProvider> list = providers;
            synchronized (list) {
                int len = providers.size();
                for (int i = 0; i < len; ++i) {
                    Page p;
                    Integer pageID = providers.get(i).getPopupPageId();
                    if (pageID == null || (p = this.getSession().getPage(pageID.intValue(), 0)) == null || !(p instanceof CloseRequestSupport) || ((CloseRequestSupport)p).isClosed()) continue;
                    return System.currentTimeMillis() - providers.get(i).getLastRefreshedTimeInMillis() < 5000L;
                }
            }
        }
        return false;
    }
}

