/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.common.base;

import java.net.MalformedURLException;
import org.apache.wicket.Page;
import org.apache.wicket.Request;
import org.apache.wicket.Response;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.security.WaspApplication;
import org.apache.wicket.security.actions.ActionFactory;
import org.apache.wicket.security.hive.HiveMind;
import org.apache.wicket.security.hive.config.HiveFactory;
import org.apache.wicket.security.hive.config.SwarmPolicyFileHiveFactory;
import org.apache.wicket.security.strategies.StrategyFactory;
import org.apache.wicket.security.strategies.WaspAuthorizationStrategy;
import org.apache.wicket.security.swarm.SwarmWebApplication;
import org.apache.wicket.security.swarm.strategies.SwarmStrategyFactory;
import org.apache.wicket.settings.IExceptionSettings;
import org.dcm4chee.web.common.base.AccessDeniedPage;
import org.dcm4chee.web.common.base.InternalErrorPage;
import org.dcm4chee.web.common.login.LoginPage;
import org.dcm4chee.web.common.secure.ExtendedSwarmStrategy;
import org.dcm4chee.web.common.secure.SecureSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseWicketApplication
extends SwarmWebApplication {
    private Class<? extends Page> homePage;
    private Class<? extends Page> signinPage;
    private static final Logger log = LoggerFactory.getLogger(BaseWicketApplication.class);

    protected void init() {
        super.init();
        this.signinPage = this.getPageClass(this.getInitParameter("signinPageClass"), LoginPage.class);
        this.homePage = this.getPageClass(this.getInitParameter("homePageClass"), null);
        Class<? extends Page> internalErrorPage = this.getPageClass(this.getInitParameter("internalErrorPageClass"), InternalErrorPage.class);
        this.getApplicationSettings().setAccessDeniedPage(this.getPageClass(this.getInitParameter("accessDeniedPageClass"), AccessDeniedPage.class));
        this.getApplicationSettings().setPageExpiredErrorPage(this.getPageClass(this.getInitParameter("pageExpiredPageClass"), this.getHomePage()));
        if (internalErrorPage != null) {
            this.getApplicationSettings().setInternalErrorPage(internalErrorPage);
            this.getExceptionSettings().setUnexpectedExceptionDisplay(IExceptionSettings.SHOW_INTERNAL_ERROR_PAGE);
        }
    }

    private Class<? extends Page> getPageClass(String className, Class<? extends Page> def) {
        Class<?> clazz = null;
        if (className != null) {
            try {
                clazz = Class.forName(className);
            }
            catch (Throwable t) {
                log.error("Could not get Class " + className + "! use default:" + def, t);
            }
        }
        return clazz == null ? def : clazz;
    }

    public Class<? extends Page> getHomePage() {
        if (this.homePage == null) {
            throw new RuntimeException("No HomePage is set! You have to set init-param 'homePageClass' in web.xml or subclass BaseWicketApplication and override getHomePage()!");
        }
        return this.homePage;
    }

    protected Object getHiveKey() {
        return "hive_" + this.getName();
    }

    protected void setUpHive() {
        SwarmPolicyFileHiveFactory factory = new SwarmPolicyFileHiveFactory((ActionFactory)this.getActionFactory());
        try {
            factory.addPolicyFile(this.getServletContext().getResource("/WEB-INF/dcm4chee.hive"));
        }
        catch (MalformedURLException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
        HiveMind.registerHive((Object)this.getHiveKey(), (HiveFactory)factory);
    }

    protected void setupStrategyFactory() {
        this.setStrategyFactory((StrategyFactory)new SwarmStrategyFactory(this.getHiveKey()){

            public WaspAuthorizationStrategy newStrategy() {
                return new ExtendedSwarmStrategy(this.getHiveKey());
            }
        });
    }

    public Class<? extends Page> getLoginPage() {
        return this.signinPage;
    }

    public SecureSession newSession(Request request, Response response) {
        return new SecureSession((WaspApplication)this, request);
    }
}

