/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.common.ajax;

import org.apache.wicket.Page;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.IHeaderResponse;

public abstract class AjaxIntervalBehaviour
extends AbstractDefaultAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private int updateInterval;

    public AjaxIntervalBehaviour(int updateInterval) {
        if (updateInterval <= 0) {
            throw new IllegalArgumentException("Invalid update interval! Must be >0 but is:" + updateInterval);
        }
        this.updateInterval = updateInterval;
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.renderOnLoadJavascript(this.getJsTimeoutCall());
    }

    protected final String getJsTimeoutCall() {
        return "setInterval(\"" + this.getCallbackScript() + "\", " + this.updateInterval + ");";
    }

    protected CharSequence getCallbackScript() {
        return this.generateCallbackScript("wicketAjaxGet('" + this.getCallbackUrl() + "'");
    }

    protected CharSequence getPreconditionScript() {
        String precondition = null;
        if (!(this.getComponent() instanceof Page)) {
            String componentId = this.getComponent().getMarkupId();
            precondition = "var c = Wicket.$('" + componentId + "'); return typeof(c) != 'undefined' && c != null";
        }
        return precondition;
    }

    protected final void respond(AjaxRequestTarget target) {
        this.onTimer(target);
    }

    protected abstract void onTimer(AjaxRequestTarget var1);
}

