/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.soundex;

import org.dcm4che2.soundex.FuzzyStr;

public class ESoundex2
implements FuzzyStr {
    private final boolean encodeFirst;
    private final int codeLength;
    private final int padToLength;

    public ESoundex2() {
        this(true, 255, 0);
    }

    public ESoundex2(boolean encodeFirst, int codeLength, int padLength) {
        this.encodeFirst = encodeFirst;
        this.codeLength = codeLength;
        this.padToLength = padLength;
    }

    public String toFuzzy(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        char[] in = s.toUpperCase().toCharArray();
        char[] out = in.length < this.padToLength ? new char[this.padToLength] : in;
        int i = 0;
        int j = 0;
        if (!this.encodeFirst) {
            out[j++] = in[i++];
        }
        int prevout = 0;
        int curout = 0;
        while (i < in.length && j < this.codeLength) {
            block17: {
                switch (in[i]) {
                    case 'A': 
                    case 'E': 
                    case 'H': 
                    case 'I': 
                    case 'O': 
                    case 'U': 
                    case 'W': 
                    case 'Y': 
                    case '\u00c0': 
                    case '\u00c1': 
                    case '\u00c2': 
                    case '\u00c3': 
                    case '\u00c4': 
                    case '\u00c5': 
                    case '\u00c6': 
                    case '\u00c8': 
                    case '\u00c9': 
                    case '\u00ca': 
                    case '\u00cb': 
                    case '\u00cc': 
                    case '\u00cd': 
                    case '\u00ce': 
                    case '\u00cf': 
                    case '\u00d2': 
                    case '\u00d3': 
                    case '\u00d4': 
                    case '\u00d5': 
                    case '\u00d6': 
                    case '\u00d8': 
                    case '\u00d9': 
                    case '\u00da': 
                    case '\u00db': 
                    case '\u00dc': 
                    case '\u00dd': {
                        prevout = 48;
                        break block17;
                    }
                    case 'B': 
                    case 'F': {
                        prevout = 49;
                        break block17;
                    }
                    case 'P': 
                    case 'V': {
                        curout = 50;
                        break;
                    }
                    case 'C': 
                    case 'K': 
                    case 'S': 
                    case '\u00c7': 
                    case '\u00df': {
                        curout = 51;
                        break;
                    }
                    case 'G': 
                    case 'J': {
                        curout = 52;
                        break;
                    }
                    case 'Q': 
                    case 'X': 
                    case 'Z': {
                        curout = 53;
                        break;
                    }
                    case 'D': 
                    case 'T': {
                        curout = 54;
                        break;
                    }
                    case 'L': {
                        curout = 55;
                        break;
                    }
                    case 'M': 
                    case 'N': {
                        curout = 56;
                        break;
                    }
                    case 'R': {
                        curout = 57;
                        break;
                    }
                    default: {
                        break block17;
                    }
                }
                if (prevout != curout) {
                    out[j++] = prevout = curout;
                }
            }
            ++i;
        }
        while (j < this.padToLength) {
            out[j++] = 48;
        }
        return new String(out, 0, j);
    }

    public static void main(String[] args) {
        ESoundex2 inst = new ESoundex2();
        for (String arg : args) {
            System.out.println(inst.toFuzzy(arg));
        }
    }
}

