/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.security.acl.Group;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.sql.DataSource;
import javax.transaction.Transaction;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;
import org.jboss.security.auth.spi.Util;
import org.jboss.tm.TransactionDemarcationSupport;

public class DatabaseServerLoginModule
extends UsernamePasswordLoginModule {
    protected String dsJndiName;
    protected String principalsQuery = "select Password from Principals where PrincipalID=?";
    protected String rolesQuery = "select Role, RoleGroup from Roles where PrincipalID=?";
    protected boolean suspendResume = true;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        Object tmp;
        super.initialize(subject, callbackHandler, sharedState, options);
        this.dsJndiName = (String)options.get("dsJndiName");
        if (this.dsJndiName == null) {
            this.dsJndiName = "java:/DefaultDS";
        }
        if ((tmp = options.get("principalsQuery")) != null) {
            this.principalsQuery = tmp.toString();
        }
        if ((tmp = options.get("rolesQuery")) != null) {
            this.rolesQuery = tmp.toString();
        }
        if ((tmp = options.get("suspendResume")) != null) {
            this.suspendResume = Boolean.valueOf(tmp.toString());
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("DatabaseServerLoginModule, dsJndiName=" + this.dsJndiName));
            this.log.trace((Object)("principalsQuery=" + this.principalsQuery));
            this.log.trace((Object)("rolesQuery=" + this.rolesQuery));
            this.log.trace((Object)("suspendResume=" + this.suspendResume));
        }
    }

    protected String getUsersPassword() throws LoginException {
        boolean trace = this.log.isTraceEnabled();
        String username = this.getUsername();
        String password = null;
        Connection conn = null;
        Statement ps = null;
        ResultSet rs = null;
        Transaction tx = null;
        if (this.suspendResume) {
            tx = TransactionDemarcationSupport.suspendAnyTransaction();
            if (trace) {
                this.log.trace((Object)"suspendAnyTransaction");
            }
        }
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup(this.dsJndiName);
            conn = ds.getConnection();
            if (trace) {
                this.log.trace((Object)("Excuting query: " + this.principalsQuery + ", with username: " + username));
            }
            ps = conn.prepareStatement(this.principalsQuery);
            ps.setString(1, username);
            rs = ps.executeQuery();
            if (!rs.next()) {
                if (trace) {
                    this.log.trace((Object)"Query returned no matches from db");
                }
                throw new FailedLoginException("No matching username found in Principals");
            }
            password = rs.getString(1);
            password = this.convertRawPassword(password);
            if (trace) {
                this.log.trace((Object)"Obtained user password");
            }
        }
        catch (NamingException ex) {
            LoginException le = new LoginException("Error looking up DataSource from: " + this.dsJndiName);
            le.initCause(ex);
            throw le;
        }
        catch (SQLException ex) {
            LoginException le = new LoginException("Query failed");
            le.initCause(ex);
            throw le;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {}
            }
            if (this.suspendResume) {
                TransactionDemarcationSupport.resumeAnyTransaction((Transaction)tx);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"resumeAnyTransaction");
                }
            }
        }
        return password;
    }

    protected Group[] getRoleSets() throws LoginException {
        String username = this.getUsername();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("getRoleSets using rolesQuery: " + this.rolesQuery + ", username: " + username));
        }
        Group[] roleSets = Util.getRoleSets(username, this.dsJndiName, this.rolesQuery, this, this.suspendResume);
        return roleSets;
    }

    protected String convertRawPassword(String rawPassword) {
        return rawPassword;
    }
}

