/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.security.hive;

import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.security.hive.Hive;
import org.apache.wicket.security.hive.config.HiveFactory;

public class HiveMind {
    private static final HiveMind INSTANCE = new HiveMind();
    private Map<Object, Hive> hiveCollection = new HashMap<Object, Hive>();

    private HiveMind() {
    }

    public static Hive getHive(Object queen) {
        return HiveMind.INSTANCE.hiveCollection.get(queen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerHive(Object queen, HiveFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Cannot register Hive without a factory.");
        }
        Map<Object, Hive> map = HiveMind.INSTANCE.hiveCollection;
        synchronized (map) {
            if (HiveMind.INSTANCE.hiveCollection.containsKey(queen)) {
                throw new IllegalArgumentException("Another Hive is already registered with the following key: " + queen);
            }
            Hive hive = factory.createHive();
            if (hive == null) {
                throw new RuntimeException("Factory did not produce a Hive.");
            }
            HiveMind.INSTANCE.hiveCollection.put(queen, hive);
        }
    }

    public static Hive unregisterHive(Object queen) {
        return HiveMind.INSTANCE.hiveCollection.remove(queen);
    }
}

