/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.audit.tomcat;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.log4j.Logger;
import org.apache.tomcat.util.net.jsse.JSSESocketFactory;
import org.dcm4che2.audit.message.AuditEvent;
import org.dcm4che2.audit.message.AuditMessage;
import org.dcm4che2.audit.message.SecurityAlertMessage;

public class ATNASocketFactory
extends JSSESocketFactory {
    public void handshake(Socket sock) throws IOException {
        try {
            super.handshake(sock);
        }
        catch (IOException e) {
            SecurityAlertMessage msg = new SecurityAlertMessage(SecurityAlertMessage.NODE_AUTHENTICATION);
            msg.setOutcomeIndicator(AuditEvent.OutcomeIndicator.MINOR_FAILURE);
            msg.addReportingProcess(AuditMessage.getProcessID(), AuditMessage.getLocalAETitles(), AuditMessage.getProcessName(), AuditMessage.getLocalHostName());
            msg.addPerformingNode(AuditMessage.hostNameOf((InetAddress)sock.getInetAddress()));
            msg.addAlertSubjectWithNodeID(AuditMessage.getLocalNodeID(), e.getMessage());
            msg.validate();
            Logger.getLogger((String)"auditlog").warn((Object)msg);
            throw e;
        }
    }
}

