/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import org.dcm4che.dict.Tags;
import org.dcm4che.dict.VRs;

public class StringUtils {
    static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    static final byte[] b0 = new byte[0];
    static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final int UID_DIGIT1 = 0;
    private static final int UID_DIGIT = 1;
    private static final int UID_DOT = 2;
    private static final int UID_ERROR = -1;

    private StringUtils() {
    }

    public static StringBuffer promptBytes(StringBuffer sb, byte[] data, int start, int length, int maxlen) {
        if (length == 0) {
            return sb;
        }
        Tags.toHexString(sb, data[start] & 0xFF, 2);
        int i = start + 1;
        int remain = Math.min(length, (maxlen - 2) / 3);
        while (--remain > 0) {
            Tags.toHexString(sb.append('\\'), data[i] & 0xFF, 2);
            ++i;
        }
        if (sb.length() < 3 * length - 1) {
            sb.setLength(maxlen - 2);
            sb.append("..");
        }
        return sb;
    }

    public static String promptBytes(byte[] data, int start, int length, int maxlen) {
        if (length == 0) {
            return "";
        }
        return StringUtils.promptBytes(new StringBuffer(Math.min(maxlen, length * 3 - 1)), data, start, length, maxlen).toString();
    }

    public static String promptBytes(byte[] data, int start, int length) {
        return StringUtils.promptBytes(data, start, length, Integer.MAX_VALUE);
    }

    public static String truncate(String val, int maxlen) {
        return val.length() > maxlen ? val.substring(0, maxlen - 2) + ".." : val;
    }

    public static String promptValue(int vr, ByteBuffer bb) {
        return StringUtils.promptValue(vr, bb, ISO_8859_1, Integer.MAX_VALUE);
    }

    public static String promptValue(int vr, ByteBuffer bb, Charset cs) {
        return StringUtils.promptValue(vr, bb, cs, Integer.MAX_VALUE);
    }

    public static String promptValue(int vr, ByteBuffer bb, int maxlen) {
        return StringUtils.promptValue(vr, bb, ISO_8859_1, maxlen);
    }

    public static String promptValue(int vr, ByteBuffer bb, Charset cs, int maxlen) {
        if (bb.limit() == 0) {
            return "";
        }
        if (VRs.isStringValue(vr)) {
            if (bb.get(bb.limit() - 1) == 0) {
                bb.limit(bb.limit() - 1);
            }
            return StringUtils.truncate(cs.decode(bb).toString(), maxlen);
        }
        switch (vr) {
            case 16724: {
                return StringUtils.promptAT(bb, maxlen);
            }
            case 17988: {
                return StringUtils.promptFD(bb, maxlen);
            }
            case 17996: {
                return StringUtils.promptFL(bb, maxlen);
            }
            case 20290: 
            case 21838: {
                return StringUtils.promptOB(bb, maxlen);
            }
            case 20294: {
                return StringUtils.promptOF(bb, maxlen);
            }
            case 20311: {
                return StringUtils.promptOW(bb, maxlen);
            }
            case 21324: {
                return StringUtils.promptSL(bb, maxlen);
            }
            case 21331: {
                return StringUtils.promptSS(bb, maxlen);
            }
            case 21836: {
                return StringUtils.promptUL(bb, maxlen);
            }
            case 21843: {
                return StringUtils.promptUS(bb, maxlen);
            }
        }
        throw new IllegalArgumentException("VR:" + VRs.toString(vr));
    }

    public static String promptAT(ByteBuffer bb, int maxlen) {
        int l = bb.limit() / 4 * 9 - 1;
        if (l < 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(l);
        bb.rewind();
        Tags.toHexString(sb, bb.getShort() & 0xFFFF, 4);
        Tags.toHexString(sb, bb.getShort() & 0xFFFF, 4);
        while (bb.remaining() >= 4 && sb.length() < maxlen) {
            Tags.toHexString(sb.append('\\'), bb.getShort() & 0xFFFF, 4);
            Tags.toHexString(sb, bb.getShort() & 0xFFFF, 4);
        }
        return StringUtils.truncate(sb.toString(), maxlen);
    }

    public static String promptFD(ByteBuffer bb, int maxlen) {
        if (bb.limit() < 8) {
            return "";
        }
        StringBuffer sb = new StringBuffer(bb.limit());
        bb.rewind();
        sb.append(bb.getDouble());
        while (bb.remaining() >= 8 && sb.length() < maxlen) {
            sb.append('\\').append(bb.getDouble());
        }
        return StringUtils.truncate(sb.toString(), maxlen);
    }

    public static String promptFL(ByteBuffer bb, int maxlen) {
        if (bb.limit() < 4) {
            return "";
        }
        StringBuffer sb = new StringBuffer(bb.limit());
        bb.rewind();
        sb.append(bb.getFloat());
        while (bb.remaining() >= 4 && sb.length() < maxlen) {
            sb.append('\\').append(bb.getFloat());
        }
        return StringUtils.truncate(sb.toString(), maxlen);
    }

    public static String promptOB(ByteBuffer bb, int maxlen) {
        return StringUtils.promptBytes(bb.array(), bb.arrayOffset(), bb.limit(), maxlen);
    }

    public static String promptOF(ByteBuffer bb, int maxlen) {
        return StringUtils.promptFL(bb, maxlen);
    }

    public static String promptOW(ByteBuffer bb, int maxlen) {
        int l = bb.limit() / 2 * 5 - 1;
        if (l < 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(l);
        bb.rewind();
        Tags.toHexString(sb, bb.getShort() & 0xFFFF, 4);
        while (bb.remaining() >= 2 && sb.length() < maxlen) {
            Tags.toHexString(sb.append('\\'), bb.getShort() & 0xFFFF, 4);
        }
        return StringUtils.truncate(sb.toString(), maxlen);
    }

    public static String promptSL(ByteBuffer bb, int maxlen) {
        if (bb.limit() < 4) {
            return "";
        }
        StringBuffer sb = new StringBuffer(bb.limit());
        bb.rewind();
        sb.append(bb.getInt());
        while (bb.remaining() >= 4 && sb.length() < maxlen) {
            sb.append('\\').append(bb.getInt());
        }
        return StringUtils.truncate(sb.toString(), maxlen);
    }

    public static String promptSS(ByteBuffer bb, int maxlen) {
        if (bb.limit() < 2) {
            return "";
        }
        StringBuffer sb = new StringBuffer(bb.limit());
        bb.rewind();
        sb.append(bb.getShort());
        while (bb.remaining() >= 2 && sb.length() < maxlen) {
            sb.append('\\').append(bb.getShort());
        }
        return StringUtils.truncate(sb.toString(), maxlen);
    }

    public static String promptUL(ByteBuffer bb, int maxlen) {
        if (bb.limit() < 4) {
            return "";
        }
        StringBuffer sb = new StringBuffer(bb.limit());
        bb.rewind();
        sb.append((long)bb.getInt() & 0xFFFFFFFFL);
        while (bb.remaining() >= 4 && sb.length() < maxlen) {
            sb.append('\\').append((long)bb.getInt() & 0xFFFFFFFFL);
        }
        return StringUtils.truncate(sb.toString(), maxlen);
    }

    public static String promptUS(ByteBuffer bb, int maxlen) {
        if (bb.limit() < 2) {
            return "";
        }
        StringBuffer sb = new StringBuffer(bb.limit());
        bb.rewind();
        sb.append(bb.getShort() & 0xFFFF);
        while (bb.remaining() >= 2 && sb.length() < maxlen) {
            sb.append('\\').append(bb.getShort() & 0xFFFF);
        }
        return StringUtils.truncate(sb.toString(), maxlen);
    }

    public static byte[] parseValue(int vr, String str) {
        if (str.length() == 0) {
            return b0;
        }
        switch (vr) {
            case 16724: {
                return StringUtils.parseAT(str);
            }
            case 17988: {
                return StringUtils.parseFD(str);
            }
            case 17996: {
                return StringUtils.parseFL(str);
            }
            case 20290: 
            case 21838: {
                return StringUtils.parseBytes(str);
            }
            case 20294: {
                return StringUtils.parseOF(str);
            }
            case 20311: {
                return StringUtils.parseOW(str);
            }
            case 21331: 
            case 21843: {
                return StringUtils.parseSS_US(str);
            }
            case 21324: 
            case 21836: {
                return StringUtils.parseSL_UL(str);
            }
        }
        throw new IllegalArgumentException("VR:" + VRs.toString(vr));
    }

    public static String[] split(String s, char delim) {
        int l;
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        int r0 = s.indexOf(delim);
        if (r0 == -1) {
            return new String[]{s};
        }
        int i = 2;
        int r = r0;
        while ((r = s.indexOf(delim, l = r + 1)) != -1) {
            ++i;
        }
        String[] retval = new String[i];
        l = 0;
        i = 0;
        r = r0;
        do {
            retval[i++] = s.substring(l, r);
        } while ((r = s.indexOf(delim, l = r + 1)) != -1);
        retval[i] = s.substring(l);
        return retval;
    }

    public static int count(String s, char delim) {
        if (s == null) {
            return 0;
        }
        int c = 0;
        int pos = -1;
        while ((pos = s.indexOf(delim, pos + 1)) != -1) {
            ++c;
        }
        return c;
    }

    public static String toString(String[] a, char delim) {
        if (a == null) {
            return null;
        }
        if (a.length == 0) {
            return "";
        }
        if (a.length == 1) {
            return a[0];
        }
        StringBuffer sb = new StringBuffer(a[0]);
        for (int i = 1; i < a.length; ++i) {
            sb.append(delim).append(a[i]);
        }
        return sb.toString();
    }

    public static byte[] parseAT(String str) {
        String[] a = StringUtils.split(str, '\\');
        byte[] b = new byte[a.length * 4];
        ByteBuffer bb = ByteBuffer.wrap(b, 0, b.length).order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < a.length; ++i) {
            int tag = (int)Long.parseLong(a[i], 16);
            bb.putShort((short)(tag >>> 16));
            bb.putShort((short)tag);
        }
        return b;
    }

    public static byte[] parseFD(String str) {
        String[] a = StringUtils.split(str, '\\');
        byte[] b = new byte[a.length * 8];
        ByteBuffer bb = ByteBuffer.wrap(b, 0, b.length).order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < a.length; ++i) {
            bb.putDouble(Double.parseDouble(a[i]));
        }
        return b;
    }

    public static byte[] parseFL(String str) {
        String[] a = StringUtils.split(str, '\\');
        byte[] b = new byte[a.length * 4];
        ByteBuffer bb = ByteBuffer.wrap(b, 0, b.length).order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < a.length; ++i) {
            bb.putFloat(Float.parseFloat(a[i]));
        }
        return b;
    }

    public static byte[] parseOF(String str) {
        return StringUtils.parseFL(str);
    }

    public static byte[] parseBytes(String str) {
        byte[] b = new byte[(str.length() + 1) / 3];
        int i = 0;
        int l = 0;
        while (i < b.length) {
            b[i++] = (byte)Short.parseShort(str.substring(l, l + 2), 16);
            ++i;
            l += 3;
        }
        return b;
    }

    public static byte[] parseOW(String str) {
        byte[] b = new byte[(str.length() + 1) / 5];
        int i = 0;
        int l = 0;
        while (i < b.length) {
            short s = (short)Integer.parseInt(str.substring(l, l + 4), 16);
            b[i++] = (byte)s;
            b[i++] = (byte)(s >>> 8);
            l += 5;
        }
        return b;
    }

    public static byte[] parseSS_US(String str) {
        String[] a = StringUtils.split(str, '\\');
        byte[] b = new byte[a.length * 2];
        ByteBuffer bb = ByteBuffer.wrap(b, 0, b.length).order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < a.length; ++i) {
            bb.putShort((short)Integer.parseInt(a[i]));
        }
        return b;
    }

    public static byte[] parseSL_UL(String str) {
        String[] a = StringUtils.split(str, '\\');
        byte[] b = new byte[a.length * 4];
        ByteBuffer bb = ByteBuffer.wrap(b, 0, b.length).order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < a.length; ++i) {
            bb.putInt((int)Long.parseLong(a[i]));
        }
        return b;
    }

    public static float[] parseFloats(String[] values) {
        float[] retval = new float[values.length];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = Float.parseFloat(values[i]);
        }
        return retval;
    }

    public static double[] parseDoubles(String[] values) {
        double[] retval = new double[values.length];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = Double.parseDouble(values[i]);
        }
        return retval;
    }

    public static int parseInt(String value, long min, long max) {
        long retval = Long.parseLong(value);
        if (retval < min || retval > max) {
            throw new NumberFormatException("value: " + value + ", min:" + min + ", max:" + max);
        }
        return (int)retval;
    }

    public static int[] parseInts(String[] values, long min, long max) {
        int[] retval = new int[values.length];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = StringUtils.parseInt(values[i], min, max);
        }
        return retval;
    }

    private static int nextState(int state, char c) {
        switch (state) {
            case 0: {
                if (c > '0' && c <= '9') {
                    return 1;
                }
                if (c == '0') {
                    return 2;
                }
                return -1;
            }
            case 1: {
                if (c >= '0' && c <= '9') {
                    return 1;
                }
            }
            case 2: {
                if (c != '.') break;
                return 0;
            }
        }
        return -1;
    }

    public static String checkUID(String s) {
        char[] a = s.toCharArray();
        if (a.length == 0 || a.length > 64) {
            throw new IllegalArgumentException(s);
        }
        int state = 0;
        for (int i = 0; i < a.length; ++i) {
            if ((state = StringUtils.nextState(state, a[i])) != -1) continue;
            throw new IllegalArgumentException(s);
        }
        if (state == 0) {
            throw new IllegalArgumentException(s);
        }
        return s;
    }

    public static String[] checkUIDs(String[] a) {
        for (int i = 0; i < a.length; ++i) {
            StringUtils.checkUID(a[i]);
        }
        return a;
    }

    public static String checkAET(String s) {
        char[] a = s.toCharArray();
        if (a.length == 0 || a.length > 16) {
            throw new IllegalArgumentException(s);
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] >= ' ' && a[i] < '\u007f') continue;
            throw new IllegalArgumentException(s);
        }
        return s;
    }

    public static String[] checkAETs(String[] a) {
        for (int i = 0; i < a.length; ++i) {
            StringUtils.checkAET(a[i]);
        }
        return a;
    }
}

