/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.util;

import org.apache.log4j.Logger;

public class LF_ThreadPool {
    private static final Logger log = Logger.getLogger(LF_ThreadPool.class);
    private final Handler handler;
    private boolean shutdown = false;
    private Thread leader = null;
    private Object mutex = new Object();
    private int waiting = 0;
    private int running = 0;
    private int maxRunning = 0;
    private int maxWaiting = -1;
    private final int instNo = ++instCount;
    private int threadNo = 0;
    private final String name;
    private static int instCount = 0;

    public LF_ThreadPool(Handler handler, String name) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.handler = handler;
        this.name = name;
    }

    public int waiting() {
        return this.waiting;
    }

    public int running() {
        return this.running;
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public int getMaxRunning() {
        return this.maxRunning;
    }

    public void setMaxRunning(int maxRunning) {
        if (maxRunning < 0) {
            throw new IllegalArgumentException("maxRunning: " + maxRunning);
        }
        this.maxRunning = maxRunning;
    }

    public int getMaxWaiting() {
        return this.maxWaiting;
    }

    public void setMaxWaiting(int maxWaiting) {
        if (maxWaiting < -1) {
            throw new IllegalArgumentException("maxWaiting: " + maxWaiting);
        }
        this.maxWaiting = maxWaiting;
    }

    public String toString() {
        return "LF_ThreadPool-" + this.instNo + "[leader:" + (this.leader == null ? "null" : this.leader.getName()) + ", waiting:" + this.waiting + ", running: " + this.running + "(" + this.maxRunning + "), shutdown: " + this.shutdown + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() {
        log.debug("Thread: " + Thread.currentThread().getName() + " JOIN ThreadPool " + this.name);
        try {
            while (!(this.shutdown || this.running != 0 && this.maxWaiting != -1 && this.waiting >= this.maxWaiting || this.maxRunning != 0 && this.waiting + this.running >= this.maxRunning)) {
                Object object = this.mutex;
                synchronized (object) {
                    block33: {
                        while (this.leader != null) {
                            if (log.isDebugEnabled()) {
                                log.debug("" + this + " - " + Thread.currentThread().getName() + " enter wait()");
                            }
                            ++this.waiting;
                            try {
                                this.mutex.wait();
                            }
                            catch (InterruptedException ie) {
                                log.error(ie);
                            }
                            finally {
                                --this.waiting;
                            }
                            if (!log.isDebugEnabled()) continue;
                            log.debug("" + this + " - " + Thread.currentThread().getName() + " awaked");
                        }
                        if (!this.shutdown) break block33;
                        return;
                    }
                    this.leader = Thread.currentThread();
                    if (log.isDebugEnabled()) {
                        log.debug("" + this + " - New Leader");
                    }
                    ++this.running;
                }
                try {
                    do {
                        this.handler.run(this);
                    } while (!this.shutdown && this.leader == Thread.currentThread());
                }
                catch (Throwable th) {
                    log.warn("Exception thrown in " + Thread.currentThread().getName(), th);
                    this.shutdown();
                }
                finally {
                    object = this.mutex;
                    synchronized (object) {
                        --this.running;
                    }
                }
            }
        }
        finally {
            log.debug("Thread: " + Thread.currentThread().getName() + " LEFT ThreadPool " + this.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean promoteNewLeader() {
        if (this.shutdown) {
            return false;
        }
        if (this.leader != Thread.currentThread()) {
            throw new IllegalStateException();
        }
        this.leader = null;
        Object object = this.mutex;
        synchronized (object) {
            if (this.waiting > 0) {
                if (log.isDebugEnabled()) {
                    log.debug("" + this + " - promote new leader by notify");
                }
                this.mutex.notify();
                return true;
            }
        }
        if (this.maxRunning != 0 && this.running >= this.maxRunning) {
            if (log.isDebugEnabled()) {
                log.debug("" + this + " - Max number of threads reached");
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("" + this + " - promote new leader by add new Thread");
        }
        this.addThread(new Runnable(){

            public void run() {
                LF_ThreadPool.this.join();
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (log.isDebugEnabled()) {
            log.debug("" + this + " - shutdown");
        }
        this.shutdown = true;
        this.leader = null;
        Object object = this.mutex;
        synchronized (object) {
            this.mutex.notifyAll();
        }
    }

    protected void addThread(Runnable r) {
        new Thread(r, this.name + "-" + ++this.threadNo).start();
    }

    public static interface Handler {
        public void run(LF_ThreadPool var1);
    }
}

