/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.util.Date;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.Content;
import org.dcm4che.srom.KeyObject;
import org.dcm4che.srom.TCoordContent;
import org.dcm4che.srom.Template;
import org.dcm4cheri.srom.NamedContentImpl;

abstract class TCoordContentImpl
extends NamedContentImpl
implements TCoordContent {
    protected final TCoordContent.Positions positions;

    static TCoordContent.Positions newPositions(Dataset ds) throws DcmValueException {
        DcmElement e = ds.get(4235570);
        if (e != null) {
            return new SamplePositions(e.getInts());
        }
        e = ds.get(4235576);
        if (e != null) {
            return new RelativePositions(e.getFloats());
        }
        e = ds.get(4235578);
        if (e != null) {
            return new AbsolutePositions(e.getDates());
        }
        throw new IllegalArgumentException("Missing Positions");
    }

    TCoordContentImpl(KeyObject owner, Date obsDateTime, Template template, Code name, TCoordContent.Positions positions) {
        super(owner, obsDateTime, template, name);
        this.positions = positions;
    }

    public final Content.ValueType getValueType() {
        return Content.ValueType.TCOORD;
    }

    public final TCoordContent.Positions getPositions() {
        return this.positions;
    }

    public void toDataset(Dataset ds) {
        super.toDataset(ds);
        ds.putCS(4235568, this.getRangeType());
        this.positions.toDataset(ds);
    }

    static class AbsolutePositions
    implements TCoordContent.Positions.Absolute {
        private final long[] dateTimes;

        AbsolutePositions(Date[] dateTimes) {
            this.dateTimes = new long[dateTimes.length];
            for (int i = 0; i < dateTimes.length; ++i) {
                this.dateTimes[i] = dateTimes[i].getTime();
            }
        }

        public int size() {
            return this.dateTimes.length;
        }

        public Date[] getDateTimes() {
            Date[] dts = new Date[this.dateTimes.length];
            for (int i = 0; i < this.dateTimes.length; ++i) {
                dts[i] = new Date(this.dateTimes[i]);
            }
            return dts;
        }

        public String toString() {
            return "DateTime[" + this.size() + "]";
        }

        public void toDataset(Dataset ds) {
            ds.putDT(4235578, this.getDateTimes());
        }
    }

    static class RelativePositions
    implements TCoordContent.Positions.Relative {
        private final float[] offsets;

        RelativePositions(float[] offsets) {
            this.offsets = (float[])offsets.clone();
        }

        public int size() {
            return this.offsets.length;
        }

        public float[] getOffsets() {
            return (float[])this.offsets.clone();
        }

        public String toString() {
            return "Offset[" + this.size() + "]";
        }

        public void toDataset(Dataset ds) {
            ds.putDS(4235576, this.offsets);
        }
    }

    static class SamplePositions
    implements TCoordContent.Positions.Sample {
        private final int[] indexes;

        SamplePositions(int[] indexes) {
            this.indexes = (int[])indexes.clone();
        }

        public int size() {
            return this.indexes.length;
        }

        public int[] getIndexes() {
            return (int[])this.indexes.clone();
        }

        public String toString() {
            return "Sample[" + this.size() + "]";
        }

        public void toDataset(Dataset ds) {
            ds.putUL(4235570, this.indexes);
        }
    }

    static class End
    extends TCoordContentImpl
    implements TCoordContent.End {
        End(KeyObject owner, Date obsDateTime, Template template, Code name, TCoordContent.Positions positions) {
            super(owner, obsDateTime, template, name, positions);
            if (positions.size() != 1) {
                throw new IllegalArgumentException("" + positions);
            }
        }

        Content clone(KeyObject newOwner, boolean inheritObsDateTime) {
            return new End(newOwner, this.getObservationDateTime(inheritObsDateTime), this.template, this.name, this.positions);
        }

        public String getRangeType() {
            return "END";
        }
    }

    static class Begin
    extends TCoordContentImpl
    implements TCoordContent.Begin {
        Begin(KeyObject owner, Date obsDateTime, Template template, Code name, TCoordContent.Positions positions) {
            super(owner, obsDateTime, template, name, positions);
            if (positions.size() != 1) {
                throw new IllegalArgumentException("" + positions);
            }
        }

        Content clone(KeyObject newOwner, boolean inheritObsDateTime) {
            return new Begin(newOwner, this.getObservationDateTime(inheritObsDateTime), this.template, this.name, this.positions);
        }

        public String getRangeType() {
            return "BEGIN";
        }
    }

    static class MultiSegment
    extends TCoordContentImpl
    implements TCoordContent.MultiSegment {
        MultiSegment(KeyObject owner, Date obsDateTime, Template template, Code name, TCoordContent.Positions positions) {
            super(owner, obsDateTime, template, name, positions);
            if ((positions.size() & 1) != 0) {
                throw new IllegalArgumentException("" + positions);
            }
        }

        Content clone(KeyObject newOwner, boolean inheritObsDateTime) {
            return new MultiSegment(newOwner, this.getObservationDateTime(inheritObsDateTime), this.template, this.name, this.positions);
        }

        public String getRangeType() {
            return "MULTISEGMENT";
        }
    }

    static class Segment
    extends TCoordContentImpl
    implements TCoordContent.Segment {
        Segment(KeyObject owner, Date obsDateTime, Template template, Code name, TCoordContent.Positions positions) {
            super(owner, obsDateTime, template, name, positions);
            if (positions.size() != 2) {
                throw new IllegalArgumentException("" + positions);
            }
        }

        Content clone(KeyObject newOwner, boolean inheritObsDateTime) {
            return new Segment(newOwner, this.getObservationDateTime(inheritObsDateTime), this.template, this.name, this.positions);
        }

        public String getRangeType() {
            return "SEGMENT";
        }
    }

    static class MultiPoint
    extends TCoordContentImpl
    implements TCoordContent.MultiPoint {
        MultiPoint(KeyObject owner, Date obsDateTime, Template template, Code name, TCoordContent.Positions positions) {
            super(owner, obsDateTime, template, name, positions);
        }

        Content clone(KeyObject newOwner, boolean inheritObsDateTime) {
            return new MultiPoint(newOwner, this.getObservationDateTime(inheritObsDateTime), this.template, this.name, this.positions);
        }

        public String getRangeType() {
            return "MULTIPOINT";
        }
    }

    static class Point
    extends TCoordContentImpl
    implements TCoordContent.Point {
        Point(KeyObject owner, Date obsDateTime, Template template, Code name, TCoordContent.Positions positions) {
            super(owner, obsDateTime, template, name, positions);
            if (positions.size() != 1) {
                throw new IllegalArgumentException("" + positions);
            }
        }

        Content clone(KeyObject newOwner, boolean inheritObsDateTime) {
            return new Point(newOwner, this.getObservationDateTime(inheritObsDateTime), this.template, this.name, this.positions);
        }

        public String getRangeType() {
            return "POINT";
        }
    }
}

