/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.util.Date;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.Content;
import org.dcm4che.srom.KeyObject;
import org.dcm4che.srom.NumContent;
import org.dcm4che.srom.Template;
import org.dcm4cheri.srom.NamedContentImpl;

class NumContentImpl
extends NamedContentImpl
implements NumContent {
    private Float value;
    private Code unit;
    private Code qualifier;

    NumContentImpl(KeyObject owner, Date obsDateTime, Template template, Code name, Float value, Code unit, Code qualifier) {
        super(owner, obsDateTime, template, NumContentImpl.checkNotNull(name));
        this.value = value;
        this.unit = unit;
        this.qualifier = qualifier;
    }

    Content clone(KeyObject newOwner, boolean inheritObsDateTime) {
        return new NumContentImpl(newOwner, this.getObservationDateTime(inheritObsDateTime), this.template, this.name, this.value, this.unit, this.qualifier);
    }

    public final void setName(Code newName) {
        this.name = NumContentImpl.checkNotNull(newName);
    }

    public String toString() {
        return this.prompt().append(this.value).append(this.unit).toString();
    }

    public final Content.ValueType getValueType() {
        return Content.ValueType.NUM;
    }

    public final Float getValue() {
        return this.value;
    }

    public final Code getUnit() {
        return this.unit;
    }

    public final Code getQualifier() {
        return this.qualifier;
    }

    public final void setValue(Float value) {
        this.value = value;
    }

    public final void setUnit(Code unit) {
        this.unit = unit;
    }

    public final void setQualifier(Code qualifier) {
        this.qualifier = qualifier;
    }

    public void toDataset(Dataset ds) {
        super.toDataset(ds);
        DcmElement mvsq = ds.putSQ(4236032);
        if (this.value != null && this.unit != null) {
            Dataset mv = mvsq.addNewItem();
            mv.putDS(4236042, this.value.floatValue());
            this.unit.toDataset(mv.putSQ(4196586).addNewItem());
        }
        if (this.qualifier != null) {
            this.qualifier.toDataset(ds.putSQ(4236033).addNewItem());
        }
    }
}

