/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ServerSocketFactory;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.log4j.Logger;
import org.dcm4che.server.Server;
import org.dcm4che.util.HandshakeFailedEvent;
import org.dcm4che.util.HandshakeFailedListener;
import org.dcm4cheri.util.LF_ThreadPool;

class ServerImpl
implements LF_ThreadPool.Handler,
Server {
    static final Logger log = Logger.getLogger(ServerImpl.class);
    private static int instCount = 0;
    private final String name = "TCPServer-" + ++instCount;
    private final Server.Handler handler;
    private LF_ThreadPool threadPool = new LF_ThreadPool(this, this.name);
    private ServerSocket ss;
    private int port = 104;
    private List hcl = null;
    private List hfl = null;
    private ServerSocketFactory ssf = ServerSocketFactory.getDefault();
    private int sslHandshakeSoTimeout = 0;
    private int soRcvBuf;
    private int soSndBuf;
    private boolean tcpNoDelay = true;
    private InetAddress laddr;

    public ServerImpl(Server.Handler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.handler = handler;
    }

    public void setSSLHandshakeSoTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout: " + timeout);
        }
        this.sslHandshakeSoTimeout = timeout;
    }

    public int getSSLHandshakeSoTimeout() {
        return this.sslHandshakeSoTimeout;
    }

    public final int getReceiveBufferSize() {
        return this.soRcvBuf;
    }

    public final void setReceiveBufferSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size: " + size);
        }
        this.soRcvBuf = size;
    }

    public final int getSendBufferSize() {
        return this.soSndBuf;
    }

    public final void setSendBufferSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size: " + size);
        }
        this.soSndBuf = size;
    }

    public final boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public final void setTcpNoDelay(boolean on) {
        this.tcpNoDelay = on;
    }

    public void addHandshakeCompletedListener(HandshakeCompletedListener listener) {
        this.hcl = ServerImpl.addToList(this.hcl, listener);
    }

    public void addHandshakeFailedListener(HandshakeFailedListener listener) {
        this.hfl = ServerImpl.addToList(this.hfl, listener);
    }

    public void removeHandshakeCompletedListener(HandshakeCompletedListener listener) {
        this.hcl = ServerImpl.removeFromList(this.hcl, listener);
    }

    public void removeHandshakeFailedListener(HandshakeFailedListener listener) {
        this.hfl = ServerImpl.removeFromList(this.hfl, listener);
    }

    public String getLocalAddress() {
        return this.laddr == null ? "0.0.0.0" : this.laddr.getHostAddress();
    }

    public void setLocalAddress(String laddrStr) {
        try {
            this.laddr = InetAddress.getByName(laddrStr);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Unknown Host: " + laddrStr);
        }
    }

    static List addToList(List l, Object elt) {
        if (l == null) {
            l = new ArrayList<Object>();
        }
        l.add(elt);
        return l;
    }

    static List removeFromList(List l, Object elt) {
        if (l == null) {
            return l;
        }
        l.remove(elt);
        if (l.size() == 0) {
            l = null;
        }
        return l;
    }

    public void setMaxClients(int max) {
        this.threadPool.setMaxRunning(max);
    }

    public int getMaxClients() {
        return this.threadPool.getMaxRunning();
    }

    public int getNumClients() {
        return this.threadPool.running() - 1;
    }

    public void setMaxIdleThreads(int max) {
        this.threadPool.setMaxWaiting(max);
    }

    public int getMaxIdleThreads() {
        return this.threadPool.getMaxWaiting();
    }

    public int getNumIdleThreads() {
        return this.threadPool.waiting();
    }

    public void start(int port) throws IOException {
        this.start(port, ServerSocketFactory.getDefault());
    }

    public void start(int port, ServerSocketFactory ssf) throws IOException {
        this.setPort(port);
        this.setServerSocketFactory(ssf);
        this.start();
    }

    public void start() throws IOException {
        this.checkNotRunning();
        if (log.isInfoEnabled()) {
            log.info("Start Server listening on " + this.getLocalAddress() + ":" + this.port);
        }
        this.ss = this.ssf.createServerSocket(this.port, 0, this.laddr);
        new Thread(new Runnable(){

            public void run() {
                ServerImpl.this.threadPool.join();
            }
        }, this.name).start();
    }

    public void stop() {
        if (this.ss == null) {
            return;
        }
        int port = this.ss.getLocalPort();
        if (log.isInfoEnabled()) {
            log.info("Stop Server listening at port " + port);
        }
        this.threadPool.shutdown();
        try {
            this.ss.close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        this.ss = null;
        LF_ThreadPool tp = new LF_ThreadPool(this, this.name);
        tp.setMaxRunning(this.threadPool.getMaxRunning());
        tp.setMaxWaiting(this.threadPool.getMaxWaiting());
        this.threadPool = tp;
    }

    public void run(LF_ThreadPool pool) {
        Socket s;
        block14: {
            if (this.ss == null) {
                return;
            }
            s = null;
            try {
                s = this.ss.accept();
                if (log.isInfoEnabled()) {
                    log.info("handle - " + s);
                }
                if (s instanceof SSLSocket) {
                    this.init((SSLSocket)s);
                }
                this.initSendBufferSize(s);
                this.initReceiveBufferSize(s);
                if (s.getTcpNoDelay() != this.tcpNoDelay) {
                    s.setTcpNoDelay(this.tcpNoDelay);
                }
                pool.promoteNewLeader();
                this.handler.handle(s);
                if (!this.handler.isSockedClosedByHandler() && s != null) {
                    try {
                        s.close();
                    }
                    catch (IOException ignore) {}
                }
            }
            catch (Exception e) {
                if (e instanceof SocketException && s == null) {
                    log.info("Blocking ServerSocket.accept method canceled");
                } else {
                    log.error(e, e);
                }
                if (s == null) break block14;
                try {
                    s.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
        }
        if (log.isInfoEnabled() && s != null) {
            log.info("finished - " + s);
        }
    }

    private void initSendBufferSize(Socket s) throws SocketException {
        int tmp = s.getSendBufferSize();
        if (this.soSndBuf == 0) {
            this.soSndBuf = tmp;
        }
        if (this.soSndBuf != tmp) {
            s.setSendBufferSize(this.soSndBuf);
            this.soSndBuf = s.getSendBufferSize();
        }
    }

    private void initReceiveBufferSize(Socket s) throws SocketException {
        int tmp = s.getReceiveBufferSize();
        if (this.soRcvBuf == 0) {
            this.soRcvBuf = tmp;
        }
        if (this.soRcvBuf != tmp) {
            s.setReceiveBufferSize(this.soRcvBuf);
            this.soRcvBuf = s.getReceiveBufferSize();
        }
    }

    private void checkNotRunning() {
        if (this.ss != null) {
            throw new IllegalStateException("Already Running - " + this.threadPool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(SSLSocket s) throws IOException {
        block12: {
            if (this.hcl != null) {
                int n = this.hcl.size();
                for (int i = 0; i < n; ++i) {
                    s.addHandshakeCompletedListener((HandshakeCompletedListener)this.hcl.get(i));
                }
            }
            InetAddress remoteAddr = s.getInetAddress();
            try {
                s.setSoTimeout(this.sslHandshakeSoTimeout);
                s.startHandshake();
                if (!log.isInfoEnabled()) break block12;
                SSLSession se = s.getSession();
                try {
                    X509Certificate cert = (X509Certificate)se.getPeerCertificates()[0];
                    cert.checkValidity();
                    log.info(s.getInetAddress().toString() + ": accept " + se.getCipherSuite() + " with " + cert.getSubjectDN() + " valid from " + cert.getNotBefore() + " to " + cert.getNotAfter());
                }
                catch (SSLPeerUnverifiedException e) {
                    log.error("SSL peer not verified:", e);
                }
                catch (CertificateException ce) {
                    throw new IOException(ce.getMessage());
                }
            }
            catch (IOException e) {
                if (this.hfl != null) {
                    HandshakeFailedEvent event = new HandshakeFailedEvent(s, remoteAddr, e);
                    int n = this.hfl.size();
                    for (int i = 0; i < n; ++i) {
                        ((HandshakeFailedListener)this.hfl.get(i)).handshakeFailed(event);
                    }
                    throw e;
                }
            }
            finally {
                s.setSoTimeout(0);
            }
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        if (port <= 0) {
            throw new IllegalArgumentException("port: " + port);
        }
        this.port = port;
    }

    public ServerSocketFactory getServerSocketFactory() {
        return this.ssf;
    }

    public void setServerSocketFactory(ServerSocketFactory ssf) {
        if (ssf == null) {
            throw new NullPointerException();
        }
        this.ssf = ssf;
    }
}

