/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.net;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.Association;
import org.dcm4che.net.AssociationListener;
import org.dcm4che.net.DcmServiceRegistry;
import org.dcm4che.net.Dimse;
import org.dcm4che.net.DimseListener;
import org.dcm4che.net.FutureRSP;
import org.dcm4che.net.PDU;
import org.dcm4cheri.net.AssociationImpl;
import org.dcm4cheri.net.FutureRSPImpl;
import org.dcm4cheri.util.IntHashtable2;
import org.dcm4cheri.util.LF_ThreadPool;

final class ActiveAssociationImpl
implements ActiveAssociation,
LF_ThreadPool.Handler,
AssociationListener {
    private static Logger log = Logger.getLogger(ActiveAssociationImpl.class);
    private static int instCount = 0;
    private final String name = "ActiveAssoc-" + ++instCount;
    private final AssociationImpl assoc;
    private final DcmServiceRegistry services;
    private final IntHashtable2 rspDispatcher = new IntHashtable2();
    private final IntHashtable2 cancelDispatcher = new IntHashtable2();
    private final LF_ThreadPool threadPool = new LF_ThreadPool(this, this.name);
    private boolean running = false;

    ActiveAssociationImpl(Association assoc, DcmServiceRegistry services) {
        if (assoc.getState() != 6) {
            throw new IllegalStateException("Association not established - " + assoc.getState());
        }
        this.assoc = (AssociationImpl)assoc;
        this.services = services;
        ((AssociationImpl)assoc).setThreadPool(this.threadPool);
        assoc.addAssociationListener(this);
    }

    public final void addCancelListener(int msgID, DimseListener l) {
        this.cancelDispatcher.put(msgID, l);
    }

    public String toString() {
        return "Active-" + this.assoc;
    }

    public void run() {
        if (this.running) {
            throw new IllegalStateException("Already running: " + this.threadPool);
        }
        this.running = true;
        this.threadPool.join();
    }

    public void start() {
        if (this.running) {
            throw new IllegalStateException("Already running: " + this.threadPool);
        }
        new Thread((Runnable)this, this.name).start();
    }

    public Association getAssociation() {
        return this.assoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Dimse rq, DimseListener l) throws InterruptedException, IOException {
        int msgID = rq.getCommand().getMessageID();
        int maxOps = this.assoc.getMaxOpsInvoked();
        IntHashtable2 intHashtable2 = this.rspDispatcher;
        synchronized (intHashtable2) {
            if (maxOps > 0) {
                while (this.rspDispatcher.size() >= maxOps) {
                    this.rspDispatcher.wait();
                }
            }
            this.rspDispatcher.put(msgID, l);
        }
        this.assoc.write(rq);
    }

    public FutureRSP invoke(Dimse rq) throws InterruptedException, IOException {
        FutureRSPImpl retval = new FutureRSPImpl(this.assoc);
        this.invoke(rq, retval);
        return retval;
    }

    public void release(boolean waitOnRSP) throws InterruptedException, IOException {
        if (waitOnRSP) {
            this.waitForPendingRSP();
        }
        this.assoc.writeReleaseRQ();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForPendingRSP() throws InterruptedException {
        IntHashtable2 intHashtable2 = this.rspDispatcher;
        synchronized (intHashtable2) {
            while (!this.rspDispatcher.isEmpty()) {
                this.rspDispatcher.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run(LF_ThreadPool pool) {
        Dimse dimse = null;
        try {
            dimse = this.assoc.read();
            if (dimse == null) {
                pool.shutdown();
                return;
            }
            this.assoc.initMDC();
            Command cmd = dimse.getCommand();
            switch (cmd.getCommandField()) {
                case 1: {
                    this.services.lookup(cmd.getAffectedSOPClassUID()).c_store(this, dimse);
                    return;
                }
                case 16: {
                    this.services.lookup(cmd.getAffectedSOPClassUID()).c_get(this, dimse);
                    return;
                }
                case 32: {
                    this.services.lookup(cmd.getAffectedSOPClassUID()).c_find(this, dimse);
                    return;
                }
                case 33: {
                    this.services.lookup(cmd.getAffectedSOPClassUID()).c_move(this, dimse);
                    return;
                }
                case 48: {
                    this.services.lookup(cmd.getAffectedSOPClassUID()).c_echo(this, dimse);
                    return;
                }
                case 256: {
                    this.services.lookup(cmd.getAffectedSOPClassUID()).n_event_report(this, dimse);
                    return;
                }
                case 272: {
                    this.services.lookup(cmd.getRequestedSOPClassUID()).n_get(this, dimse);
                    return;
                }
                case 288: {
                    this.services.lookup(cmd.getRequestedSOPClassUID()).n_set(this, dimse);
                    return;
                }
                case 304: {
                    this.services.lookup(cmd.getRequestedSOPClassUID()).n_action(this, dimse);
                    return;
                }
                case 320: {
                    this.services.lookup(cmd.getAffectedSOPClassUID()).n_create(this, dimse);
                    return;
                }
                case 336: {
                    this.services.lookup(cmd.getRequestedSOPClassUID()).n_delete(this, dimse);
                    return;
                }
                case 32769: 
                case 32784: 
                case 32800: 
                case 32801: 
                case 32816: 
                case 33024: 
                case 33040: 
                case 33056: 
                case 33072: 
                case 33088: 
                case 33104: {
                    this.handleResponse(dimse);
                    return;
                }
                case 4095: {
                    this.handleCancel(dimse);
                    return;
                }
                default: {
                    throw new RuntimeException("Illegal Command: " + cmd);
                }
            }
        }
        catch (IOException ioe) {
            log.error(ioe.getMessage(), ioe);
            pool.shutdown();
            return;
        }
        finally {
            if (dimse != null) {
                dimse.closeDataStream();
            }
            this.assoc.clearMDC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResponse(Dimse dimse) throws IOException {
        DimseListener l = null;
        IntHashtable2 intHashtable2 = this.rspDispatcher;
        synchronized (intHashtable2) {
            Command cmd = dimse.getCommand();
            Dataset ds = dimse.getDataset();
            int msgID = cmd.getMessageIDToBeingRespondedTo();
            if (cmd.isPending()) {
                l = (DimseListener)this.rspDispatcher.get(msgID);
            } else {
                l = (DimseListener)this.rspDispatcher.remove(msgID);
                this.rspDispatcher.notify();
            }
            if (l != null) {
                l.dimseReceived(this.assoc, dimse);
            }
        }
    }

    private void handleCancel(Dimse dimse) {
        Command cmd = dimse.getCommand();
        int msgID = cmd.getMessageIDToBeingRespondedTo();
        DimseListener l = (DimseListener)this.cancelDispatcher.remove(msgID);
        if (l != null) {
            l.dimseReceived(this.assoc, dimse);
        }
    }

    private void checkRunning() {
        if (!this.running) {
            throw new IllegalStateException("Not running: " + this.threadPool);
        }
    }

    public void write(Association src, PDU pdu) {
    }

    public void received(Association src, Dimse dimse) {
    }

    public void error(Association src, IOException ioe) {
    }

    public void closing(Association src) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closed(Association src) {
        IntHashtable2 intHashtable2 = this.rspDispatcher;
        synchronized (intHashtable2) {
            this.rspDispatcher.clear();
            this.rspDispatcher.notifyAll();
        }
        this.assoc.removeAssociationListener(this);
    }

    public void write(Association src, Dimse dimse) {
    }

    public void received(Association src, PDU pdu) {
    }
}

