/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.imageio.plugins;

import java.io.IOException;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.ImageOutputStreamImpl;
import org.dcm4cheri.imageio.plugins.PatchJpegLS;

public class PatchJpegLSImageOutputStream
extends ImageOutputStreamImpl {
    private final ImageOutputStream ios;
    private final byte[] jpegheader;

    public PatchJpegLSImageOutputStream(ImageOutputStream ios) throws IOException {
        if (ios == null) {
            throw new NullPointerException("ios");
        }
        this.ios = ios;
        this.jpegheader = new byte[17];
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int pos = (int)this.getStreamPosition();
        this.streamPos = pos + len;
        if (pos >= 17) {
            this.ios.write(b, off, len);
        } else {
            int b_header = Math.min(17 - pos, len);
            System.arraycopy(b, off, this.jpegheader, pos, b_header);
            if (pos + len >= 17) {
                this.ios.write(this.jpegheader, 0, 15);
                byte[] patch = PatchJpegLS.selectPatch(this.jpegheader);
                if (patch != null) {
                    this.ios.write(patch);
                }
                this.ios.write(this.jpegheader, 15, 2);
                this.ios.write(b, off + b_header, len - b_header);
            }
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(int b) throws IOException {
        this.ios.write(b);
    }

    public int read() throws IOException {
        return this.ios.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.ios.read(b, off, len);
    }
}

