/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.imageio.plugins;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;
import org.dcm4cheri.imageio.plugins.PatchJpegLS;

public class PatchJpegLSImageInputStream
extends ImageInputStreamImpl {
    private final ImageInputStream iis;
    private final long patchPos;
    private final byte[] patch;

    public PatchJpegLSImageInputStream(ImageInputStream iis) throws IOException {
        if (iis == null) {
            throw new NullPointerException("iis");
        }
        this.streamPos = iis.getStreamPosition();
        this.flushedPos = iis.getFlushedPosition();
        this.iis = iis;
        this.patchPos = this.streamPos + 15L;
        byte[] jpegheader = new byte[17];
        iis.readFully(jpegheader);
        iis.seek(this.streamPos);
        this.patch = PatchJpegLS.selectPatch(jpegheader);
    }

    public void close() throws IOException {
        super.close();
        this.iis.close();
    }

    public void flushBefore(long pos) throws IOException {
        super.flushBefore(pos);
        this.iis.flushBefore(this.adjustStreamPosition(pos));
    }

    private long adjustStreamPosition(long pos) {
        if (this.patch == null) {
            return pos;
        }
        long index = pos - this.patchPos;
        return index < 0L ? pos : (index < (long)this.patch.length ? this.patchPos : pos - (long)this.patch.length);
    }

    public boolean isCached() {
        return this.iis.isCached();
    }

    public boolean isCachedFile() {
        return this.iis.isCachedFile();
    }

    public boolean isCachedMemory() {
        return this.iis.isCachedMemory();
    }

    public long length() {
        try {
            long len = this.iis.length();
            return this.patch == null || len < 0L ? len : len + (long)this.patch.length;
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public int read() throws IOException {
        long index;
        int ch = this.patch != null && (index = this.streamPos - this.patchPos) >= 0L && index < (long)this.patch.length ? this.patch[(int)index] : this.iis.read();
        if (ch >= 0) {
            ++this.streamPos;
        }
        return ch;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int r = 0;
        if (this.patch != null && this.streamPos < this.patchPos + (long)this.patch.length) {
            if (this.streamPos < this.patchPos) {
                r = this.iis.read(b, off, (int)Math.min(this.patchPos - this.streamPos, (long)len));
                if (r < 0) {
                    return r;
                }
                this.streamPos += (long)r;
                if (this.streamPos < this.patchPos) {
                    return r;
                }
                off += r;
                len -= r;
            }
            int index = (int)(this.patchPos - this.streamPos);
            int r2 = Math.min(this.patch.length - index, len);
            System.arraycopy(this.patch, index, b, off, r2);
            this.streamPos += (long)r2;
            r += r2;
            off += r2;
            len -= r2;
        }
        if (len > 0) {
            int r3 = this.iis.read(b, off, len);
            if (r3 < 0) {
                return r3;
            }
            this.streamPos += (long)r3;
            r += r3;
        }
        return r;
    }

    public void mark() {
        super.mark();
        this.iis.mark();
    }

    public void reset() throws IOException {
        super.reset();
        this.iis.reset();
    }

    public void seek(long pos) throws IOException {
        super.seek(pos);
        this.iis.seek(this.adjustStreamPosition(pos));
    }
}

