/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.imageio.plugins;

import org.apache.log4j.Logger;

class PatchJpegLS {
    private static final Logger log = Logger.getLogger(PatchJpegLS.class);
    private static final int SOI = 65496;
    private static final int SOF55 = 65527;
    private static final int LSE = 65528;
    private static final int SOS = 65498;
    private static final byte[] LSE_13 = new byte[]{-1, -8, 0, 13, 1, 31, -1, 0, 34, 0, -125, 2, 36, 0, 64};
    private static final byte[] LSE_14 = new byte[]{-1, -8, 0, 13, 1, 63, -1, 0, 66, 1, 3, 4, 68, 0, 64};
    private static final byte[] LSE_15 = new byte[]{-1, -8, 0, 13, 1, 127, -1, 0, -126, 2, 3, 8, -124, 0, 64};
    private static final byte[] LSE_16 = new byte[]{-1, -8, 0, 13, 1, -1, -1, 1, 2, 4, 3, 17, 4, 0, 64};

    PatchJpegLS() {
    }

    public static byte[] selectPatch(byte[] jpegheader) {
        if (PatchJpegLS.toInt(jpegheader, 0) != 65496) {
            log.warn("SOI marker is missing - do not patch JPEG LS");
            return null;
        }
        int marker = PatchJpegLS.toInt(jpegheader, 2);
        if (marker != 65527) {
            log.warn(marker == 65528 ? "contains already LSE marker segment - do not patch JPEG LS" : "SOI marker is not followed by JPEG-LS SOF marker - do not patch JPEG LS");
            return null;
        }
        if (PatchJpegLS.toInt(jpegheader, 4) != 11) {
            log.warn("unexpected length of JPEG-LS SOF marker segment - do not patch JPEG LS");
            return null;
        }
        marker = PatchJpegLS.toInt(jpegheader, 15);
        if (marker != 65498) {
            log.warn(marker == 65528 ? "contains already LSE marker segment - do not patch JPEG LS" : "JPEG-LS SOF marker segment is not followed by SOS marker - do not patch JPEG LS");
            return null;
        }
        switch (jpegheader[6]) {
            case 13: {
                log.info("Patch JPEG LS 13-bit with LSE segment(T1=34, T2=131, T3=548)");
                return LSE_13;
            }
            case 14: {
                log.info("Patch JPEG LS 14-bit with LSE segment(T1=66, T2=259, T3=1092)");
                return LSE_14;
            }
            case 15: {
                log.info("Patch JPEG LS 15-bit with LSE segment(T1=130, T2=515, T3=2180)");
                return LSE_15;
            }
            case 16: {
                log.info("Patch JPEG LS 16-bit with LSE segment(T1=258, T2=1027, T3=4356)");
                return LSE_16;
            }
        }
        return null;
    }

    private static int toInt(byte[] b, int off) {
        return (b[off] & 0xFF) << 8 | b[off + 1] & 0xFF;
    }
}

