/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.imageio.plugins;

import javax.imageio.metadata.IIOMetadataNode;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.dict.DictionaryFactory;
import org.dcm4che.dict.TagDictionary;
import org.dcm4che.imageio.plugins.DcmMetadata;
import org.dcm4cheri.imageio.plugins.DcmImageReaderConf;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

public class DcmMetadataImpl
extends DcmMetadata {
    private static Logger log = Logger.getLogger(DcmMetadataImpl.class);
    static final DcmImageReaderConf conf = DcmImageReaderConf.getInstance();
    private Dataset ds;
    private TagDictionary dict = DictionaryFactory.getInstance().getDefaultTagDictionary();

    public DcmMetadataImpl(Dataset ds) {
        super(false, conf.getExtraStreamMetadataFormatNames(), conf.getExtraStreamMetadataFormatClassNames());
        this.ds = ds;
    }

    public final Dataset getDataset() {
        return this.ds;
    }

    public final void setDataset(Dataset ds) {
        if (ds == null) {
            throw new NullPointerException("ds can not be null");
        }
        this.ds = ds;
    }

    public final void setDictionary(TagDictionary dict) {
        this.dict = dict;
    }

    public final boolean isReadOnly() {
        return false;
    }

    public Node getAsTree(String formatName) {
        if (formatName.equals("dcm4che_imageio_dicom_1.0")) {
            return this.getTree(formatName, null, null);
        }
        if (formatName.equals("javax_imageio_1.0")) {
            throw new IllegalArgumentException("javax_imageio_1.0 not supported!");
        }
        if (conf.contains(formatName)) {
            return this.getTree(formatName, conf.getFilterDataset(formatName), conf.getTransformerHandler(formatName));
        }
        throw new IllegalArgumentException("Not a recognized format: " + formatName);
    }

    private Node getTree(String formatName, Dataset filter, TransformerHandler th) {
        final IIOMetadataNode root = new IIOMetadataNode(formatName);
        ContentHandler ch = new DefaultHandler(){
            Node curNode;
            {
                this.curNode = root;
            }

            public void startElement(String uri, String localName, String qName, Attributes attr) {
                if ("dicomfile".equals(qName)) {
                    return;
                }
                IIOMetadataNode newNode = new IIOMetadataNode(qName);
                int n = attr.getLength();
                for (int i = 0; i < n; ++i) {
                    String attrName = attr.getQName(i);
                    if ("pos".equals(attrName)) continue;
                    newNode.setAttribute(attrName, attr.getValue(i));
                }
                this.curNode.appendChild(newNode);
                this.curNode = newNode;
            }

            public void endElement(String uri, String localName, String qName) {
                if ("dicomfile".equals(qName)) {
                    return;
                }
                this.curNode = this.curNode.getParentNode();
            }
        };
        try {
            if (th != null) {
                th.setResult(new SAXResult(ch));
                ch = th;
            }
            this.ds.subSet(filter).writeFile(ch, this.dict);
        }
        catch (Exception ex) {
            log.error(ex);
            throw new RuntimeException("Exception in getTree", ex);
        }
        return root;
    }

    public void mergeTree(String formatName, Node root) {
        if (formatName.equals("javax_imageio_1.0")) {
            throw new IllegalArgumentException("javax_imageio_1.0 not supported!");
        }
        if (!formatName.equals("dcm4che_imageio_dicom_1.0")) {
            throw new IllegalArgumentException("Not a recognized format: " + formatName);
        }
        this.mergeTree(root);
    }

    private void mergeTree(Node root) {
        DOMSource src = new DOMSource(root);
        SAXResult res = new SAXResult(this.ds.getSAXHandler());
        try {
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            trans.transform(src, res);
        }
        catch (TransformerConfigurationException tce) {
            log.error(tce);
        }
        catch (TransformerException te) {
            log.error(te);
        }
    }

    public void reset() {
        this.ds = DcmObjectFactory.getInstance().newDataset();
    }

    public void setFromTree(String formatName, Node root) {
        if (formatName.equals("javax_imageio_1.0")) {
            throw new IllegalArgumentException("javax_imageio_1.0 not supported!");
        }
        if (!formatName.equals("dcm4che_imageio_dicom_1.0")) {
            throw new IllegalArgumentException("Not a recognized format: " + formatName);
        }
        this.reset();
        this.mergeTree(root);
    }
}

