/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.imageio.plugins;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.util.SystemUtils;

public class DcmImageReaderConf {
    private static Logger log = Logger.getLogger(DcmImageReaderConf.class);
    private static DcmImageReaderConf instance = new DcmImageReaderConf();
    private final ClassLoader classloader;
    private String[] extraStreamMetadataFormatNames = null;
    private List formatNameList = Collections.EMPTY_LIST;
    private String[] extraStreamMetadataFormatClassNames = null;
    private String[] extraStreamMetadataFormatFilterResource = null;
    private String[] extraStreamMetadataFormatStyleResource = null;
    private Dataset[] datasetFilter = null;
    private Templates[] transformerTemplates = null;

    public static DcmImageReaderConf getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DcmImageReaderConf() {
        this.classloader = Thread.currentThread().getContextClassLoader();
        String conf = SystemUtils.getSystemProperty("dcm4cheri.imageio.plugins.DcmImageReader.config", "DcmImageReader.properties");
        InputStream in = this.classloader.getResourceAsStream(conf);
        if (in == null) {
            return;
        }
        Properties p = new Properties();
        try {
            p.load(in);
        }
        catch (IOException ioe) {
            log.error(ioe);
            return;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ignore) {}
        }
        StringTokenizer tk = new StringTokenizer(p.getProperty("extraStreamMetadataFormatNames", ""), " ,\t");
        int n = tk.countTokens();
        if (n == 0) {
            return;
        }
        this.extraStreamMetadataFormatNames = new String[n];
        this.extraStreamMetadataFormatClassNames = new String[n];
        this.extraStreamMetadataFormatFilterResource = new String[n];
        this.extraStreamMetadataFormatStyleResource = new String[n];
        for (int i = 0; i < n; ++i) {
            String name;
            this.extraStreamMetadataFormatNames[i] = name = tk.nextToken();
            this.extraStreamMetadataFormatClassNames[i] = p.getProperty(name + ".class");
            this.extraStreamMetadataFormatFilterResource[i] = p.getProperty(name + ".filter");
            this.extraStreamMetadataFormatStyleResource[i] = p.getProperty(name + ".style");
        }
        this.formatNameList = Arrays.asList(this.extraStreamMetadataFormatNames);
        this.datasetFilter = new Dataset[n];
        this.transformerTemplates = new Templates[n];
    }

    public String[] getExtraStreamMetadataFormatNames() {
        return this.extraStreamMetadataFormatNames;
    }

    public String[] getExtraStreamMetadataFormatClassNames() {
        return this.extraStreamMetadataFormatClassNames;
    }

    public boolean contains(String formatName) {
        return this.formatNameList.indexOf(formatName) != -1;
    }

    public Dataset getFilterDataset(String formatName) {
        int index = this.formatNameList.indexOf(formatName);
        if (index == -1 || this.extraStreamMetadataFormatFilterResource[index] == null) {
            return null;
        }
        if (this.datasetFilter[index] != null) {
            return this.datasetFilter[index];
        }
        InputStream in = this.classloader.getResourceAsStream(this.extraStreamMetadataFormatFilterResource[index]);
        if (in == null) {
            throw new ConfigurationError("Could not open resource " + this.extraStreamMetadataFormatFilterResource[index], null);
        }
        try {
            Dataset ds = DcmObjectFactory.getInstance().newDataset();
            SAXParser p = SAXParserFactory.newInstance().newSAXParser();
            p.parse(in, ds.getSAXHandler());
            Dataset dataset = this.datasetFilter[index] = ds;
            return dataset;
        }
        catch (Exception ex) {
            throw new ConfigurationError("Could not parse resource " + this.extraStreamMetadataFormatFilterResource[index], ex);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ignore) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransformerHandler getTransformerHandler(String formatName) {
        int index = this.formatNameList.indexOf(formatName);
        if (index == -1 || this.extraStreamMetadataFormatStyleResource[index] == null) {
            return null;
        }
        try {
            SAXTransformerFactory tf = (SAXTransformerFactory)TransformerFactory.newInstance();
            if (this.transformerTemplates[index] == null) {
                InputStream in = this.classloader.getResourceAsStream(this.extraStreamMetadataFormatStyleResource[index]);
                if (in == null) {
                    throw new ConfigurationError("Could not open resource " + this.extraStreamMetadataFormatStyleResource[index], null);
                }
                try {
                    this.transformerTemplates[index] = tf.newTemplates(new StreamSource(in));
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException ignore) {}
                }
            }
            return tf.newTransformerHandler(this.transformerTemplates[index]);
        }
        catch (Exception ex) {
            throw new ConfigurationError("Could not parse resource " + this.extraStreamMetadataFormatStyleResource[index], ex);
        }
    }

    static class ConfigurationError
    extends Error {
        ConfigurationError(String msg, Exception x) {
            super(msg, x);
        }
    }
}

