/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.image;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.image.ColorModelParam;
import org.dcm4cheri.image.BasicColorModelParam;

final class MonochromeParam
extends BasicColorModelParam {
    private static final Logger log = Logger.getLogger(MonochromeParam.class);
    private final int inverse;
    private final float slope;
    private final float intercept;
    private final float[] center;
    private final float[] width;
    private Dataset voilut;
    private final int hashcode;
    private final byte[] pv2dll;
    private final int andmask;
    private final int pvBits;
    private static final float[] EMPTY = new float[0];

    private static final float[] nullToEmpty(float[] a) {
        return a == null ? EMPTY : a;
    }

    private final float correctSlope(float f) {
        return f == 0.0f || Math.abs(f) > (float)this.max ? 1.0f : f;
    }

    private static final int inBits(int len) {
        int i = 8;
        int n = 256;
        while (i <= 16) {
            if (n == len) {
                return i;
            }
            ++i;
            n <<= 1;
        }
        throw new IllegalArgumentException("pv2dll length: " + len);
    }

    public MonochromeParam(Dataset ds, boolean inverse1, byte[] pv2dll) {
        super(ds);
        this.inverse = inverse1 ? -1 : 0;
        this.slope = this.correctSlope(ds.getFloat(2625619, 1.0f));
        this.intercept = ds.getFloat(2625618, 0.0f);
        this.center = MonochromeParam.nullToEmpty(ds.getFloats(2625616));
        this.width = MonochromeParam.nullToEmpty(ds.getFloats(2625617));
        for (int i = 0; i < this.width.length; ++i) {
            if (!(this.width[i] <= 0.0f)) continue;
            this.width[i] = (float)(this.max - this.min) / this.slope;
        }
        this.voilut = this.center.length == 0 ? ds.getItem(2633744) : null;
        this.pv2dll = pv2dll;
        this.pvBits = MonochromeParam.inBits(pv2dll.length);
        this.andmask = (1 << this.pvBits) - 1;
        this.hashcode = MonochromeParam.hashcode(this.dataType, this.inverse, this.min, this.max, this.slope, this.intercept, this.center, this.width, pv2dll);
    }

    private static int hashcode(int dataType, int inverse, int min, int max, float slope, float intercept, float[] center, float[] width, byte[] pv2dll) {
        StringBuffer sb = new StringBuffer();
        sb.append(dataType).append(inverse).append(min).append(max).append(slope).append(intercept).append(pv2dll);
        if (Math.min(center.length, width.length) != 0) {
            sb.append(center[0]).append(width[0]);
        }
        return sb.toString().hashCode();
    }

    private MonochromeParam(MonochromeParam other, float center1, float width1, boolean inverse1) {
        super(other);
        this.inverse = inverse1 ? -1 : 0;
        this.slope = other.slope;
        this.intercept = other.intercept;
        this.center = new float[]{center1};
        this.width = new float[]{width1};
        this.pv2dll = other.pv2dll;
        this.pvBits = other.pvBits;
        this.andmask = other.andmask;
        this.hashcode = MonochromeParam.hashcode(this.dataType, this.inverse, this.min, this.max, this.slope, this.intercept, this.center, this.width, this.pv2dll);
    }

    public boolean isMonochrome() {
        return true;
    }

    public ColorModelParam update(float center, float width, boolean inverse) {
        if (width < 0.0f) {
            throw new IllegalArgumentException("width: " + width);
        }
        return new MonochromeParam(this, center, width, inverse);
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MonochromeParam)) {
            return false;
        }
        MonochromeParam other = (MonochromeParam)o;
        if (this.getNumberOfWindows() == 0 ? other.getNumberOfWindows() != 0 : other.getNumberOfWindows() == 0 || this.center[0] != other.center[0] || this.width[0] != other.width[0]) {
            return false;
        }
        return this.inverse == other.inverse && this.intercept == other.intercept && this.slope == other.slope && this.max == other.max && this.min == other.min && this.pv2dll == other.pv2dll;
    }

    public final float getRescaleSlope() {
        return this.slope;
    }

    public final float getRescaleIntercept() {
        return this.intercept;
    }

    public final float getWindowCenter(int index) {
        return this.center[index];
    }

    public final float getWindowWidth(int index) {
        return this.width[index];
    }

    public final int getNumberOfWindows() {
        return Math.min(this.center.length, this.width.length);
    }

    public final Dataset getVOILUT() {
        return this.voilut;
    }

    public final boolean isCacheable() {
        return this.voilut == null;
    }

    public final boolean isInverse() {
        return this.inverse != 0;
    }

    public final float toMeasureValue(int pxValue) {
        return (float)this.toSampleValue(pxValue) * this.slope + this.intercept;
    }

    public final int toPixelValue(float measureValue) {
        return (int)((measureValue - this.intercept) / this.slope);
    }

    private static int toARGB(byte grey) {
        int v = grey & 0xFF;
        return 0xFF000000 | v << 16 | v << 8 | v;
    }

    public ColorModel newColorModel() {
        int[] cmap = new int[this.size];
        if (this.voilut != null) {
            this.createCMAPfromVOILUT(cmap);
        } else {
            float widthV;
            float centerV;
            if (this.getNumberOfWindows() == 0) {
                centerV = this.slope * (float)(this.max + this.min) / 2.0f + this.intercept;
                widthV = (float)(this.max - this.min) * this.slope;
            } else {
                centerV = this.center[0];
                widthV = this.width[0];
            }
            log.debug("window level " + centerV + "," + widthV + " intercept, slope=" + this.intercept + "," + this.slope + " isInverse " + this.isInverse());
            this.createCMAP(cmap, (centerV - this.intercept) / this.slope, widthV / this.slope);
        }
        return new IndexColorModel(this.bits, this.size, cmap, 0, false, -1, this.dataType);
    }

    private void createCMAP(int[] cmap, float c, float wFlt) {
        int i;
        int w = (int)wFlt;
        int u = (int)(c - wFlt / 2.0f);
        int o = u + w;
        int cmin = MonochromeParam.toARGB(this.pv2dll[0]);
        int cmax = MonochromeParam.toARGB(this.pv2dll[this.pv2dll.length - 1]);
        int useInverse = this.inverse;
        if (this.min < 0) {
            useInverse = 0;
        }
        if (u > 0) {
            Arrays.fill(cmap, 0, Math.min(u, this.max), useInverse == 0 ? cmin : cmax);
        }
        if (o < this.max) {
            Arrays.fill(cmap, Math.max(0, o), this.max, useInverse == 0 ? cmax : cmin);
        }
        int n = Math.min(o, this.max);
        for (i = Math.max(0, u); i < n; ++i) {
            cmap[i] = MonochromeParam.toARGB(this.pv2dll[((i - u << this.pvBits) / w ^ useInverse) & this.andmask]);
        }
        if (this.min == 0) {
            return;
        }
        if (u > this.min) {
            Arrays.fill(cmap, this.size >> 1, Math.min(u + this.size, this.size), useInverse == 0 ? cmin : cmax);
        }
        if (o < 0) {
            Arrays.fill(cmap, Math.max(o + this.size, this.size >> 1), this.size, useInverse == 0 ? cmax : cmin);
        }
        n = Math.min(o, 0);
        for (i = Math.max(this.min, u); i < n; ++i) {
            cmap[i + this.size] = MonochromeParam.toARGB(this.pv2dll[((i - u << this.pvBits) / w ^ useInverse) & this.andmask]);
        }
    }

    private void createCMAPfromVOILUT(int[] cmap) {
        int[] lutDescriptor = this.voilut.getInts(2633730);
        byte[] lutData = this.voilut.getByteBuffer(2633734).array();
        int lutLength = lutDescriptor[0] != 0 ? lutDescriptor[0] : 65536;
        int lutOffset = lutDescriptor[1];
        if (lutOffset > 0 && (lutOffset & 0x8000) != 0 && (this.min < 0 || this.intercept < 0.0f)) {
            lutOffset |= 0xFFFF0000;
        }
        int lutBits = lutDescriptor[2];
        if (lutData.length == lutLength) {
            if (lutBits != 8) {
                throw new IllegalArgumentException("VOI LUT Bit Depth in Descriptor:" + lutBits + " does not match 8 bits alloacted of VOI LUT Data");
            }
            if (this.isInverse()) {
                this.createInverseCMAPfrom8bitVOILUT(cmap, lutData, lutOffset);
            } else {
                this.createCMAPfrom8bitVOILUT(cmap, lutData, lutOffset);
            }
        } else if (lutData.length == lutLength << 1) {
            if (this.bits < lutBits && !this.containsBitsInHighByte(lutData, -1 << this.bits - 8 & 0xFF)) {
                log.info("Detect Agfa ADC VOI LUT bug => assume VOI LUT Bit Depth = " + this.bits);
                lutBits = this.bits;
            }
            if (this.isInverse()) {
                this.createInverseCMAPfrom16bitVOILUT(cmap, lutData, lutOffset, lutBits);
            } else {
                this.createCMAPfrom16bitVOILUT(cmap, lutData, lutOffset, lutBits);
            }
        } else {
            throw new IllegalArgumentException("VOI LUT Data Length in Descriptor:" + lutDescriptor[0] + " does not match length of VOI LUT Data:" + lutData.length);
        }
    }

    private boolean containsBitsInHighByte(byte[] lutData, int bits) {
        for (int i = lutData.length - 1; i > 0; --i) {
            if ((lutData[i] & bits) != 0) {
                return true;
            }
            --i;
        }
        return false;
    }

    private void createCMAPfrom8bitVOILUT(int[] cmap, byte[] lutData, int offset) {
        int u = (int)(((float)offset - this.intercept) / this.slope);
        int o = u + (int)((float)lutData.length / this.slope);
        int lshift = this.pvBits - 8;
        int cmin = MonochromeParam.toARGB(this.pv2dll[(lutData[0] & 0xFF) << lshift]);
        int cmax = MonochromeParam.toARGB(this.pv2dll[(lutData[lutData.length - 1] & 0xFF) << lshift]);
        if (u > 0) {
            Arrays.fill(cmap, 0, Math.min(u, this.max), cmin);
        }
        if (o < this.max) {
            Arrays.fill(cmap, Math.max(0, o), this.max, cmax);
        }
        int i = Math.max(0, u);
        int n = Math.min(o, this.max);
        int j = i - u;
        while (i < n) {
            cmap[i++] = MonochromeParam.toARGB(this.pv2dll[(lutData[j++] & 0xFF) << lshift]);
        }
        if (this.min == 0) {
            return;
        }
        if (u > this.min) {
            Arrays.fill(cmap, this.size >> 1, Math.min(u + this.size, this.size), cmin);
        }
        if (o < 0) {
            Arrays.fill(cmap, Math.max(o + this.size, this.size >> 1), this.size, cmax);
        }
        i = Math.max(this.min, u);
        n = Math.min(o, 0);
        j = i - u;
        while (i < n) {
            cmap[this.size + i++] = MonochromeParam.toARGB(this.pv2dll[(lutData[j++] & 0xFF) << lshift]);
        }
    }

    private void createInverseCMAPfrom8bitVOILUT(int[] cmap, byte[] lutData, int offset) {
        int u = (int)(((float)offset - this.intercept) / this.slope);
        int o = u + (int)((float)lutData.length / this.slope);
        int lshift = this.pvBits - 8;
        int cmin = MonochromeParam.toARGB(this.pv2dll[this.pv2dll.length - 1 - ((lutData[0] & 0xFF) << lshift)]);
        int cmax = MonochromeParam.toARGB(this.pv2dll[this.pv2dll.length - 1 - ((lutData[lutData.length - 1] & 0xFF) << lshift)]);
        if (u > 0) {
            Arrays.fill(cmap, 0, Math.min(u, this.max), cmin);
        }
        if (o < this.max) {
            Arrays.fill(cmap, Math.max(0, o), this.max, cmax);
        }
        int i = Math.max(0, u);
        int n = Math.min(o, this.max);
        int j = i - u;
        while (i < n) {
            cmap[i++] = MonochromeParam.toARGB(this.pv2dll[this.pv2dll.length - 1 - ((lutData[j++] & 0xFF) << lshift)]);
        }
        if (this.min == 0) {
            return;
        }
        if (u > this.min) {
            Arrays.fill(cmap, this.size >> 1, Math.min(u + this.size, this.size), cmin);
        }
        if (o < 0) {
            Arrays.fill(cmap, Math.max(o + this.size, this.size >> 1), this.size, cmax);
        }
        i = Math.max(this.min, u);
        n = Math.min(o, 0);
        j = i - u;
        while (i < n) {
            cmap[this.size + i++] = MonochromeParam.toARGB(this.pv2dll[this.pv2dll.length - 1 - ((lutData[j++] & 0xFF) << lshift)]);
        }
    }

    private void createCMAPfrom16bitVOILUT(int[] cmap, byte[] lutData, int offset, int lutBits) {
        int u = (int)(((float)offset - this.intercept) / this.slope);
        int o = u + (int)((float)(lutData.length >> 1) / this.slope);
        int rshift = lutBits - this.pvBits;
        int lshift = -rshift;
        if (rshift < 0) {
            rshift = 0;
        } else {
            lshift = 0;
        }
        int cmin = MonochromeParam.toARGB(this.pv2dll[(lutData[0] & 0xFF | (lutData[1] & 0xFF) << 8) << lshift >> rshift]);
        int cmax = MonochromeParam.toARGB(this.pv2dll[(lutData[lutData.length - 2] & 0xFF | (lutData[lutData.length - 1] & 0xFF) << 8) << lshift >> rshift]);
        if (u > 0) {
            Arrays.fill(cmap, 0, Math.min(u, this.max), cmin);
        }
        if (o < this.max) {
            Arrays.fill(cmap, Math.max(0, o), this.max, cmax);
        }
        int i = Math.max(0, u);
        int n = Math.min(o, this.max);
        int j = i - u << 1;
        while (i < n) {
            cmap[i++] = MonochromeParam.toARGB(this.pv2dll[(lutData[j++] & 0xFF | (lutData[j++] & 0xFF) << 8) << lshift >> rshift]);
        }
        if (this.min == 0) {
            return;
        }
        if (u > this.min) {
            Arrays.fill(cmap, this.size >> 1, Math.min(u + this.size, this.size), cmin);
        }
        if (o < 0) {
            Arrays.fill(cmap, Math.max(o + this.size, this.size >> 1), this.size, cmax);
        }
        i = Math.max(this.min, u);
        n = Math.min(o, 0);
        j = i - u << 1;
        while (i < n) {
            cmap[this.size + i++] = MonochromeParam.toARGB(this.pv2dll[(lutData[j++] & 0xFF | (lutData[j++] & 0xFF) << 8) << lshift >> rshift]);
        }
    }

    private void createInverseCMAPfrom16bitVOILUT(int[] cmap, byte[] lutData, int offset, int lutBits) {
        int u = (int)(((float)offset - this.intercept) / this.slope);
        int o = u + (int)((float)(lutData.length >> 1) / this.slope);
        int rshift = lutBits - this.pvBits;
        int lshift = -rshift;
        if (rshift < 0) {
            rshift = 0;
        } else {
            lshift = 0;
        }
        int cmin = MonochromeParam.toARGB(this.pv2dll[this.pv2dll.length - 1 - ((lutData[0] & 0xFF | (lutData[1] & 0xFF) << 8) << lshift >> rshift)]);
        int cmax = MonochromeParam.toARGB(this.pv2dll[this.pv2dll.length - 1 - ((lutData[lutData.length - 2] & 0xFF | (lutData[lutData.length - 1] & 0xFF) << 8) << lshift >> rshift)]);
        if (u > 0) {
            Arrays.fill(cmap, 0, Math.min(u, this.max), cmin);
        }
        if (o < this.max) {
            Arrays.fill(cmap, Math.max(0, o), this.max, cmax);
        }
        int i = Math.max(0, u);
        int n = Math.min(o, this.max);
        int j = i - u << 1;
        while (i < n) {
            cmap[i++] = MonochromeParam.toARGB(this.pv2dll[this.pv2dll.length - 1 - ((lutData[j++] & 0xFF | (lutData[j++] & 0xFF) << 8) << lshift >> rshift)]);
        }
        if (this.min == 0) {
            return;
        }
        if (u > this.min) {
            Arrays.fill(cmap, this.size >> 1, Math.min(u + this.size, this.size), cmin);
        }
        if (o < 0) {
            Arrays.fill(cmap, Math.max(o + this.size, this.size >> 1), this.size, cmax);
        }
        i = Math.max(this.min, u);
        n = Math.min(o, 0);
        j = i - u << 1;
        while (i < n) {
            cmap[this.size + i++] = MonochromeParam.toARGB(this.pv2dll[this.pv2dll.length - 1 - ((lutData[j++] & 0xFF | (lutData[j++] & 0xFF) << 8) << lshift >> rshift)]);
        }
    }
}

