/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.data;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.imageio.stream.ImageInputStream;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmDecodeParam;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmHandler;
import org.dcm4che.data.FileFormat;
import org.dcm4che.data.SpecificCharacterSet;
import org.dcm4che.dict.Tags;
import org.dcm4che.dict.VRs;
import org.dcm4cheri.data.BaseDatasetImpl;
import org.dcm4cheri.data.ExcludePrivateSQElement;
import org.dcm4cheri.data.FilterSQElement;
import org.dcm4cheri.data.SQElement;
import org.xml.sax.helpers.DefaultHandler;

abstract class FilterDataset
extends BaseDatasetImpl
implements Dataset {
    protected final BaseDatasetImpl backend;
    static final int[] EMPTY_INT = new int[0];

    public FilterDataset(Dataset backend) {
        this.backend = (BaseDatasetImpl)backend;
    }

    protected abstract boolean filter(int var1, int var2);

    public boolean contains(int tag) {
        return this.get(tag) != null;
    }

    public int vm(int tag) {
        DcmElement el = this.get(tag);
        return el != null ? el.vm(this.backend.getSpecificCharacterSet()) : -1;
    }

    public int size() {
        int count = 0;
        Iterator iter = this.backend.iterator();
        while (iter.hasNext()) {
            DcmElement el = (DcmElement)iter.next();
            if (!this.filter(el.tag(), el.vr())) continue;
            ++count;
        }
        return count;
    }

    public DcmElement get(int tag) {
        DcmElement el = this.backend.get(tag);
        return el != null && this.filter(el.tag(), el.vr()) ? el : null;
    }

    public Iterator iterator() {
        final Iterator backendIter = this.backend.iterator();
        return new Iterator(){
            private DcmElement next = this.findNext();

            private DcmElement findNext() {
                while (backendIter.hasNext()) {
                    DcmElement el = (DcmElement)backendIter.next();
                    if (!FilterDataset.this.filter(el.tag(), el.vr())) continue;
                    return el;
                }
                return null;
            }

            public boolean hasNext() {
                return this.next != null;
            }

            public Object next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                DcmElement retval = this.next;
                this.next = this.findNext();
                return retval;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public SpecificCharacterSet getSpecificCharacterSet() {
        return this.backend.getSpecificCharacterSet();
    }

    public Dataset getParent() {
        return this.backend.getParent();
    }

    public void setPrivateCreatorID(String privateCreatorID) {
        this.backend.setPrivateCreatorID(privateCreatorID);
    }

    public String getPrivateCreatorID() {
        return this.backend.getPrivateCreatorID();
    }

    public long getItemOffset() {
        return this.backend.getItemOffset();
    }

    public DcmHandler getDcmHandler() {
        throw new UnsupportedOperationException();
    }

    public DefaultHandler getSAXHandler() {
        throw new UnsupportedOperationException();
    }

    protected DcmElement put(DcmElement el) {
        if (!this.filter(el.tag(), el.vr())) {
            throw new IllegalArgumentException("" + el + " does not fit in this sub DataSet");
        }
        return this.backend.put(el);
    }

    public DcmElement remove(int tag) {
        DcmElement el = this.backend.get(tag);
        return el != null && this.filter(tag, el.vr()) ? this.backend.remove(tag) : null;
    }

    public void clear() {
        ArrayList<DcmElement> toRemove = new ArrayList<DcmElement>();
        Iterator iter = this.backend.iterator();
        while (iter.hasNext()) {
            DcmElement el = (DcmElement)iter.next();
            if (!this.filter(el.tag(), el.vr())) continue;
            toRemove.add(el);
        }
        int n = toRemove.size();
        for (int i = 0; i < n; ++i) {
            this.backend.remove(((DcmElement)toRemove.get(i)).tag());
        }
    }

    public Dataset setItemOffset(long itemOffset) {
        throw new UnsupportedOperationException();
    }

    public void readDataset(InputStream in, DcmDecodeParam param, int stopTag) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void readFile(InputStream in, FileFormat format, int stopTag) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void readFile(ImageInputStream iin, FileFormat format, int stopTag) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void readFile(File f, FileFormat format, int stopTag) throws IOException {
        throw new UnsupportedOperationException();
    }

    public DcmElement putXX(int tag, int vr) {
        if (!this.filter(tag, vr)) {
            throw new IllegalArgumentException("Tag " + Tags.toString(tag) + ", VR " + VRs.toString(vr) + " does not fit in this sub DataSet");
        }
        return this.backend.putXX(tag, vr);
    }

    static final class TagFilter
    extends FilterDataset {
        private final int[] tags;
        private final int[] vrs;
        private final boolean exclude;
        private final boolean excludePrivate;

        TagFilter(Dataset backend, int[] tags, int[] vrs, boolean exclude, boolean excludePrivate) {
            super(backend);
            this.tags = tags == null ? EMPTY_INT : (int[])tags.clone();
            this.exclude = exclude;
            this.excludePrivate = excludePrivate;
            this.vrs = vrs == null ? EMPTY_INT : (int[])vrs.clone();
            Arrays.sort(this.tags);
        }

        protected boolean filter(int tag, int vr) {
            return !(this.excludePrivate && Tags.isPrivate(tag) || !this.containsVR(vr) && Arrays.binarySearch(this.tags, tag) < 0) ? !this.exclude : this.exclude;
        }

        private boolean containsVR(int vr) {
            for (int i = 0; i < this.vrs.length; ++i) {
                if (this.vrs[i] != vr) continue;
                return true;
            }
            return false;
        }
    }

    static final class Segment
    extends FilterDataset {
        private long fromTag;
        private long toTag;

        Segment(Dataset backend, int fromTag, int toTag) {
            super(backend);
            this.fromTag = (long)fromTag & 0xFFFFFFFFL;
            this.toTag = (long)toTag & 0xFFFFFFFFL;
            if (this.fromTag > this.toTag) {
                throw new IllegalArgumentException("fromTag:" + Tags.toString(fromTag) + " greater toTag:" + Tags.toString(toTag));
            }
        }

        public int size() {
            int count = 0;
            Iterator iter = this.backend.iterator();
            while (iter.hasNext()) {
                long ltag = (long)((DcmElement)iter.next()).tag() & 0xFFFFFFFFL;
                if (ltag < this.fromTag) continue;
                if (ltag >= this.toTag) break;
                ++count;
            }
            return count;
        }

        protected boolean filter(int tag, int vr) {
            long ltag = (long)tag & 0xFFFFFFFFL;
            return ltag >= this.fromTag && ltag < this.toTag;
        }
    }

    static final class ExcludePrivate
    extends FilterDataset {
        ExcludePrivate(Dataset backend) {
            super(backend);
        }

        protected boolean filter(int tag, int vr) {
            return !Tags.isPrivate(tag);
        }

        public DcmElement get(int tag) {
            if (Tags.isPrivate(tag)) {
                return null;
            }
            DcmElement el = this.backend.get(tag);
            if (!(el instanceof SQElement)) {
                return el;
            }
            return new ExcludePrivateSQElement((SQElement)el);
        }
    }

    static final class Selection
    extends FilterDataset {
        private final Dataset filter;

        Selection(Dataset backend, Dataset filter) {
            super(backend);
            this.filter = filter;
        }

        protected boolean filter(int tag, int vr) {
            return this.filter == null || this.filter.contains(tag);
        }

        public DcmElement get(int tag) {
            if (this.filter == null) {
                return this.backend.get(tag);
            }
            DcmElement filterEl = this.filter.get(tag);
            if (filterEl == null) {
                return null;
            }
            DcmElement el = this.backend.get(tag);
            if (!(el instanceof SQElement)) {
                return el;
            }
            if (!(filterEl instanceof SQElement)) {
                log.warn("VR mismatch - dataset:" + el + ", filter:" + filterEl);
                return el;
            }
            Dataset item = filterEl.getItem();
            if (item == null || item.isEmpty()) {
                return el;
            }
            return new FilterSQElement((SQElement)el, item);
        }
    }
}

