/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.data;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.dcm4che.data.DcmDecodeParam;
import org.dcm4che.data.DcmHandler;
import org.dcm4che.data.SpecificCharacterSet;
import org.dcm4che.dict.TagDictionary;
import org.dcm4che.dict.Tags;
import org.dcm4che.dict.VRs;
import org.dcm4cheri.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class DcmHandlerAdapter2
implements DcmHandler {
    private static final char[] HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Attributes EMPTY_ATTR = new AttributesImpl();
    private final ContentHandler handler;
    private final TagDictionary dict;
    private boolean explicitVR;
    private ByteOrder byteOrder;
    private static final int UNDEF = 0;
    private static final int COMMAND = 1;
    private static final int FILEMETAINFO = 2;
    private static final int DATASET = 3;
    private static final int DCMFILE = 4;
    private int docType = 0;
    private int vr;
    private final char[] cbuf = new char[512];
    private final StringBuffer sb = new StringBuffer(512);
    private int tag;
    private long pos;
    private final File outsrcDir;
    private final int[] outsrcTags;
    private final int outsrcValueLengthLimit;
    private final StringBuffer outsrcName = new StringBuffer();
    private String tagStr;
    private boolean outsrc;
    private SpecificCharacterSet cs;

    public DcmHandlerAdapter2(ContentHandler handler, TagDictionary dict, int[] outsrcTags, int outsrcValueLengthLimit, File outsrcDir) {
        this.handler = handler;
        this.dict = dict;
        this.outsrcValueLengthLimit = outsrcValueLengthLimit;
        this.outsrcDir = outsrcDir;
        this.outsrcTags = outsrcTags == null ? new int[]{} : (int[])outsrcTags.clone();
        Arrays.sort(this.outsrcTags);
    }

    public void startCommand() throws IOException {
        this.start(1, "command", EMPTY_ATTR);
    }

    public void endCommand() throws IOException {
        this.end(1, "command");
    }

    public void startFileMetaInfo(byte[] preamble) throws IOException {
        this.start(2, "filemetainfo", EMPTY_ATTR);
        if (preamble == null) {
            return;
        }
        try {
            this.handler.startElement("", "preamble", "preamble", EMPTY_ATTR);
            this.outOB(preamble, 0, preamble.length);
            this.handler.endElement("", "preamble", "preamble");
        }
        catch (SAXException se) {
            throw (IOException)new IOException("Exception in startFileMetaInfo").initCause(se);
        }
    }

    public void endFileMetaInfo() throws IOException {
        this.end(2, "filemetainfo");
    }

    public void startDataset() throws IOException {
        this.start(3, "dataset", EMPTY_ATTR);
    }

    public void endDataset() throws IOException {
        this.end(3, "dataset");
    }

    public void startDcmFile() throws IOException {
        this.start(4, "dicomfile", EMPTY_ATTR);
    }

    public void endDcmFile() throws IOException {
        this.end(4, "dicomfile");
    }

    private void start(int docType, String xmltag, Attributes attrs) throws IOException {
        try {
            if (this.docType == 0) {
                this.docType = docType;
                this.handler.startDocument();
            }
            this.handler.startElement("", xmltag, xmltag, attrs);
        }
        catch (SAXException se) {
            throw (IOException)new IOException("Exception in start " + xmltag).initCause(se);
        }
    }

    private void end(int docType, String xmltag) throws IOException {
        try {
            this.handler.endElement("", xmltag, xmltag);
            if (this.docType == docType) {
                this.handler.endDocument();
                docType = 0;
            }
        }
        catch (SAXException se) {
            throw (IOException)new IOException("Exception in end " + xmltag).initCause(se);
        }
    }

    public void setDcmDecodeParam(DcmDecodeParam param) {
        this.byteOrder = param.byteOrder;
        this.explicitVR = param.explicitVR;
    }

    public void startElement(int tag, int vr, long pos) throws IOException {
        this.tag = tag;
        this.outsrc = Arrays.binarySearch(this.outsrcTags, tag) >= 0;
        this.tagStr = Tags.toHexString(tag, 8);
        this.vr = vr;
        this.pos = pos;
        this.outsrcName.append(this.tagStr);
    }

    public void endElement() throws IOException {
        this.outsrcName.setLength(this.outsrcName.length() - 8);
    }

    public void startSequence(int length) throws IOException {
        try {
            TagDictionary.Entry entry;
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "tag", "tag", "", Tags.toHexString(this.tag, 8));
            attrs.addAttribute("", "vr", "vr", "", VRs.toString(this.vr));
            attrs.addAttribute("", "pos", "pos", "", "" + this.pos);
            if (this.dict != null && (entry = this.dict.lookup(this.tag)) != null) {
                attrs.addAttribute("", "name", "name", "", entry.name);
            }
            attrs.addAttribute("", "len", "len", "", "" + length);
            this.handler.startElement("", "attr", "attr", attrs);
        }
        catch (SAXException se) {
            throw (IOException)new IOException("Exception in startElement").initCause(se);
        }
    }

    public void fragment(int id, long pos, byte[] data, int start, int length) throws IOException {
        try {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "id", "id", "", "" + id);
            attrs.addAttribute("", "pos", "pos", "", "" + pos);
            attrs.addAttribute("", "len", "len", "", "" + length);
            String fname = this.outsrcName.toString() + '-' + id;
            boolean bl = this.outsrc = this.outsrc || length > this.outsrcValueLengthLimit;
            if (this.outsrc && length > 0) {
                if (this.outsrcDir != null) {
                    attrs.addAttribute("", "src", "src", "", fname);
                } else {
                    attrs.addAttribute("", "hide", "hide", "", "true");
                }
            }
            this.handler.startElement("", "item", "item", attrs);
            if (length > 0) {
                if (this.outsrc) {
                    this.outsrc(fname, data, start, length);
                } else {
                    this.out(data, start, length);
                }
            }
            this.handler.endElement("", "item", "item");
        }
        catch (SAXException se) {
            throw (IOException)new IOException("Exception in fragment").initCause(se);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outsrc(String fname, byte[] data, int start, int length) throws IOException {
        if (this.outsrcDir == null) {
            return;
        }
        FileOutputStream out = new FileOutputStream(new File(this.outsrcDir, fname));
        try {
            out.write(data, start, length);
        }
        finally {
            out.close();
        }
    }

    public int vm(byte[] data, int start, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        switch (this.vr) {
            case 19540: 
            case 20290: 
            case 20311: 
            case 21332: 
            case 21838: 
            case 21844: {
                return 1;
            }
            case 21331: 
            case 21843: {
                return length >> 1;
            }
            case 16724: 
            case 17996: 
            case 21324: 
            case 21836: {
                return length >> 2;
            }
            case 17988: {
                return length >> 3;
            }
        }
        int count = 1;
        int i = 0;
        int j = start;
        while (i < length) {
            if (data[j] == 92) {
                ++count;
            }
            ++i;
            ++j;
        }
        return count;
    }

    public void value(byte[] data, int start, int length) throws IOException {
        try {
            TagDictionary.Entry entry;
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "tag", "tag", "", this.tagStr);
            attrs.addAttribute("", "vr", "vr", "", VRs.toString(this.vr));
            attrs.addAttribute("", "pos", "pos", "", "" + this.pos);
            if (this.dict != null && (entry = this.dict.lookup(this.tag)) != null) {
                attrs.addAttribute("", "name", "name", "", entry.name);
            }
            attrs.addAttribute("", "vm", "vm", "", "" + this.vm(data, start, length));
            attrs.addAttribute("", "len", "len", "", "" + length);
            String fname = this.outsrcName.toString();
            boolean bl = this.outsrc = this.outsrc || length > this.outsrcValueLengthLimit;
            if (this.outsrc && length > 0) {
                if (this.outsrcDir != null) {
                    attrs.addAttribute("", "src", "src", "", fname);
                } else {
                    attrs.addAttribute("", "hide", "hide", "", "true");
                }
            }
            this.handler.startElement("", "attr", "attr", attrs);
            if (length > 0) {
                if (this.outsrc) {
                    this.outsrc(fname, data, start, length);
                } else {
                    this.out(data, start, length);
                }
            }
            this.handler.endElement("", "attr", "attr");
        }
        catch (SAXException se) {
            throw (IOException)new IOException("Exception in value").initCause(se);
        }
    }

    public void endSequence(int length) throws IOException {
        try {
            this.handler.endElement("", "attr", "attr");
        }
        catch (SAXException se) {
            throw (IOException)new IOException("Exception in endSequence").initCause(se);
        }
    }

    public void startItem(int id, long pos, int length) throws IOException {
        try {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "id", "id", "", "" + id);
            attrs.addAttribute("", "pos", "pos", "", "" + pos);
            attrs.addAttribute("", "len", "len", "", "" + length);
            this.handler.startElement("", "item", "item", attrs);
            this.outsrcName.append('-').append(id).append('-');
        }
        catch (SAXException se) {
            throw (IOException)new IOException("Exception in startItem").initCause(se);
        }
    }

    public void endItem(int len) throws IOException {
        try {
            this.handler.endElement("", "item", "item");
            int outsrcNameLen = this.outsrcName.length() - 2;
            while (this.outsrcName.charAt(outsrcNameLen) != '-') {
                --outsrcNameLen;
            }
            this.outsrcName.setLength(outsrcNameLen);
        }
        catch (SAXException se) {
            throw (IOException)new IOException("Exception in endItem").initCause(se);
        }
    }

    private void out(byte[] data, int start, int length) throws SAXException {
        switch (this.vr) {
            case 16709: 
            case 16723: 
            case 17235: 
            case 17473: 
            case 17491: 
            case 17492: 
            case 18771: 
            case 21581: {
                this.outText(data, start, length, null);
                break;
            }
            case 19535: 
            case 19540: 
            case 20558: 
            case 21320: 
            case 21332: 
            case 21844: {
                this.outText(data, start, length, this.cs);
                break;
            }
            case 21833: {
                this.outText(data, start, data[length - 1] == 0 ? length - 1 : length, null);
                break;
            }
            case 16724: {
                this.outAT(data, start, length);
                return;
            }
            case 17996: 
            case 20294: {
                this.outFL_OF(data, start, length);
                return;
            }
            case 17988: {
                this.outFD(data, start, length);
                return;
            }
            case 20290: {
                this.outOB(data, start, length);
                return;
            }
            case 20311: 
            case 21843: {
                this.outOW_SS_US(data, start, length, 65535);
                return;
            }
            case 21324: {
                this.outSL_UL(data, start, length, -1L);
                return;
            }
            case 21331: {
                this.outOW_SS_US(data, start, length, -1);
                return;
            }
            case 21838: {
                this.outUN(data, start, length);
                return;
            }
            case 21836: {
                this.outSL_UL(data, start, length, 0xFFFFFFFFL);
                return;
            }
        }
    }

    private void outText(byte[] data, int start, int length, SpecificCharacterSet cs) throws SAXException {
        String s;
        String string = s = cs == null ? new String(data, start, length) : cs.decode(data, start, length);
        if (this.tag == 524293) {
            this.cs = SpecificCharacterSet.valueOf(StringUtils.split(s.trim(), '\\'));
        }
        int pos = 0;
        while (pos < s.length()) {
            int end = Math.min(s.length(), pos + this.cbuf.length);
            s.getChars(pos, end, this.cbuf, 0);
            this.handler.characters(this.cbuf, 0, end - pos);
            pos = end;
        }
    }

    private void outAT(byte[] data, int start, int length) throws SAXException {
        ByteBuffer bb = ByteBuffer.wrap(data, start, length).order(this.byteOrder);
        while (bb.remaining() > 0) {
            if (this.sb.length() + 9 > this.cbuf.length) {
                this.flushChars();
            }
            short grTag = bb.getShort();
            short elTag = bb.getShort();
            Tags.toHexString(this.sb, Tags.valueOf(grTag, elTag), 8).append('\\');
        }
        this.sb.setLength(this.sb.length() - 1);
        this.flushChars();
    }

    private void outFD(byte[] data, int start, int length) throws SAXException {
        ByteBuffer bb = ByteBuffer.wrap(data, start, length).order(this.byteOrder);
        while (bb.remaining() > 0) {
            if (this.sb.length() + 26 > this.cbuf.length) {
                this.flushChars();
            }
            this.sb.append(bb.getDouble()).append('\\');
        }
        this.sb.setLength(this.sb.length() - 1);
        this.flushChars();
    }

    private void outFL_OF(byte[] data, int start, int length) throws SAXException {
        ByteBuffer bb = ByteBuffer.wrap(data, start, length).order(this.byteOrder);
        while (bb.remaining() > 0) {
            if (this.sb.length() + 16 > this.cbuf.length) {
                this.flushChars();
            }
            this.sb.append(bb.getFloat()).append('\\');
        }
        this.sb.setLength(this.sb.length() - 1);
        this.flushChars();
    }

    private void outSL_UL(byte[] data, int start, int length, long mask) throws SAXException {
        ByteBuffer bb = ByteBuffer.wrap(data, start, length).order(this.byteOrder);
        while (bb.remaining() > 0) {
            if (this.sb.length() + 12 > this.cbuf.length) {
                this.flushChars();
            }
            this.sb.append((long)bb.getInt() & mask).append('\\');
        }
        this.sb.setLength(this.sb.length() - 1);
        this.flushChars();
    }

    private void outOW_SS_US(byte[] data, int start, int length, int mask) throws SAXException {
        ByteBuffer bb = ByteBuffer.wrap(data, start, length).order(this.byteOrder);
        while (bb.remaining() > 0) {
            if (this.sb.length() + 6 > this.cbuf.length) {
                this.flushChars();
            }
            this.sb.append(bb.getShort() & mask).append('\\');
        }
        this.sb.setLength(this.sb.length() - 1);
        this.flushChars();
    }

    private void outOB(byte[] data, int start, int length) throws SAXException {
        int i = 0;
        int j = start;
        while (i < length) {
            if (this.sb.length() + 4 > this.cbuf.length) {
                this.flushChars();
            }
            this.sb.append(data[j] & 0xFF).append('\\');
            ++i;
            ++j;
        }
        this.sb.setLength(this.sb.length() - 1);
        this.flushChars();
    }

    private void outUN(byte[] data, int start, int length) throws SAXException {
        int i = 0;
        int j = start;
        while (i < length) {
            byte v;
            if (this.sb.length() + 3 > this.cbuf.length) {
                this.flushChars();
            }
            if ((v = data[j]) >= 32 && v < 128) {
                this.sb.append((char)v);
                if (v == 92) {
                    this.sb.append('\\');
                }
            } else {
                this.sb.append('\\').append(HEX_DIGIT[v >> 4 & 0xF]).append(HEX_DIGIT[v & 0xF]);
            }
            ++i;
            ++j;
        }
        this.flushChars();
    }

    private void flushChars() throws SAXException {
        int end = this.sb.length();
        this.sb.getChars(0, end, this.cbuf, 0);
        this.handler.characters(this.cbuf, 0, end);
        this.sb.setLength(0);
    }
}

