/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che.util;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class MD5Utils {
    public static final long MEGA = 1000000L;
    public static final long GIGA = 1000000000L;
    private static final int BUF_SIZE = 512;
    private static final Logger log = Logger.getLogger(MD5Utils.class);
    private static final char[] HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private MD5Utils() {
    }

    public static File makeMD5File(File f) {
        return new File(f.getParent(), f.getName() + ".MD5");
    }

    public static char[] toHexChars(byte[] bs) {
        char[] cbuf = new char[bs.length * 2];
        MD5Utils.toHexChars(bs, cbuf);
        return cbuf;
    }

    private static int hex2digit(char ch) {
        return ch < '0' ? 0 : (ch <= '9' ? ch - 48 : (ch < 'A' ? 0 : (ch <= 'F' ? ch - 55 : (ch < 'a' ? 0 : (ch <= 'f' ? ch - 87 : 0)))));
    }

    public static void toHexChars(byte[] bs, char[] cbuf) {
        int i = 0;
        int j = 0;
        while (i < bs.length) {
            cbuf[j] = HEX_DIGIT[bs[i] >>> 4 & 0xF];
            cbuf[j + 1] = HEX_DIGIT[bs[i] & 0xF];
            ++i;
            ++j;
            ++j;
        }
    }

    public static void toHexChars(byte[] bs, byte[] cbuf, int off) {
        int i = 0;
        int j = off;
        while (i < bs.length) {
            cbuf[j] = (byte)HEX_DIGIT[bs[i] >>> 4 & 0xF];
            cbuf[j + 1] = (byte)HEX_DIGIT[bs[i] & 0xF];
            ++i;
            ++j;
            ++j;
        }
    }

    public static void toBytes(char[] cbuf, byte[] bs) {
        int i = 0;
        int j = 0;
        while (i < bs.length) {
            bs[i] = (byte)(MD5Utils.hex2digit(cbuf[j]) << 4 | MD5Utils.hex2digit(cbuf[j + 1]));
            ++i;
            ++j;
            ++j;
        }
    }

    public static byte[] toBytes(char[] cbuf) {
        byte[] bs = new byte[cbuf.length / 2];
        MD5Utils.toBytes(cbuf, bs);
        return bs;
    }

    public static byte[] toBytes(String s) {
        return MD5Utils.toBytes(s.toCharArray());
    }

    public static void md5sum(File f, char[] cbuf, MessageDigest digest, byte[] bbuf) throws IOException {
        MD5Utils.toHexChars(MD5Utils.md5sum(f, digest, bbuf), cbuf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] md5sum(File dst, MessageDigest digest, byte[] buf) throws IOException {
        digest.reset();
        DigestInputStream in = new DigestInputStream(new FileInputStream(dst), digest);
        try {
            while (((InputStream)in).read(buf) != -1) {
            }
        }
        finally {
            ((InputStream)in).close();
        }
        return digest.digest();
    }

    public static boolean verify(File driveDir, File fsDir) throws IOException {
        File md5sums = new File(driveDir, "MD5_SUMS");
        return md5sums.exists() ? MD5Utils.verifyMd5Sums(md5sums, new byte[512]) : MD5Utils.equals(driveDir, fsDir, new byte[512], new byte[512]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean equals(File dst, File src, byte[] srcBuf, byte[] dstBuf) throws IOException {
        if (src.isDirectory()) {
            String[] ss = src.list();
            for (int i = 0; i < ss.length; ++i) {
                String s = ss[i];
                if (MD5Utils.equals(new File(dst, s), new File(src, s), srcBuf, dstBuf)) continue;
                return false;
            }
        } else {
            if (!dst.isFile()) {
                log.warn("File " + dst + " missing");
                return false;
            }
            log.debug("check " + dst + " = " + src);
            long srcLen = src.length();
            long dstLen = dst.length();
            if (dstLen != srcLen) {
                log.warn("File " + dst + " has wrong length");
                return false;
            }
            DataInputStream dstIn = new DataInputStream(new FileInputStream(dst));
            try {
                FileInputStream srcIn = new FileInputStream(src);
                try {
                    int len;
                    while ((len = ((InputStream)srcIn).read(srcBuf)) != -1) {
                        dstIn.readFully(dstBuf, 0, len);
                        if (MD5Utils.equals(dstBuf, srcBuf, len)) continue;
                        log.warn("File " + dst + " corrupted");
                        boolean bl = false;
                        return bl;
                    }
                }
                finally {
                    ((InputStream)srcIn).close();
                }
            }
            finally {
                dstIn.close();
            }
        }
        return true;
    }

    private static boolean equals(byte[] dstBuf, byte[] srcBuf, int len) {
        for (int i = 0; i < len; ++i) {
            if (dstBuf[i] == srcBuf[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean verifyMd5Sums(File md5sums, byte[] bbuf) throws IOException {
        String base = md5sums.getParentFile().toURI().toString();
        BufferedReader md5sumsIn = new BufferedReader(new FileReader(md5sums));
        try {
            String line;
            char[] cbuf = new char[32];
            MessageDigest digest = MessageDigest.getInstance("MD5");
            while ((line = md5sumsIn.readLine()) != null) {
                if (line.length() < 33) continue;
                File f = new File(new URI(base + line.substring(32).trim()));
                log.debug("md5sum " + f);
                MD5Utils.md5sum(f, cbuf, digest, bbuf);
                if (Arrays.equals(cbuf, line.substring(0, 32).toCharArray())) continue;
                log.warn("File " + f + " corrupted");
                boolean bl = false;
                return bl;
            }
        }
        catch (URISyntaxException e) {
            log.warn("File " + md5sums + " corrupted");
            boolean bl = false;
            return bl;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        finally {
            md5sumsIn.close();
        }
        return true;
    }

    public static String formatSize(long size) {
        if (size < 1000000000L) {
            return (float)size / 1000000.0f + "MB";
        }
        return (float)size / 1.0E9f + "GB";
    }

    public static long parseSize(String s, long minSize) {
        long u;
        if (s.endsWith("GB")) {
            u = 1000000000L;
        } else if (s.endsWith("MB")) {
            u = 1000000L;
        } else {
            throw new IllegalArgumentException(s);
        }
        try {
            long size = (long)(Float.parseFloat(s.substring(0, s.length() - 2)) * (float)u);
            if (size >= minSize) {
                return size;
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        throw new IllegalArgumentException(s);
    }
}

