/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che.util;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class HostNameUtils {
    private static String localHostName = null;
    private static String localHostAddress = null;

    public static String getLocalHostName() {
        if (localHostName == null) {
            HostNameUtils.init();
        }
        return localHostName;
    }

    public static String getLocalHostAddress() {
        if (localHostAddress == null) {
            HostNameUtils.init();
        }
        return localHostAddress;
    }

    private static void init() {
        try {
            InetAddress ia = InetAddress.getLocalHost();
            localHostName = HostNameUtils.skipDomain(ia.getHostName());
            localHostAddress = ia.getHostAddress();
        }
        catch (UnknownHostException e) {
            localHostName = "localhost";
            localHostAddress = "127.0.0.1";
        }
    }

    public static String skipDomain(String fqdn) {
        if (Character.isDigit(fqdn.charAt(0))) {
            return fqdn;
        }
        int pos = fqdn.indexOf(46);
        return pos == -1 ? fqdn : fqdn.substring(0, pos);
    }

    private HostNameUtils() {
    }
}

