/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che.net;

import java.io.IOException;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.AssociationFactory;
import org.dcm4che.net.DcmService;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.Dimse;
import org.dcm4che.net.DimseListener;
import org.dcm4che.util.UIDGenerator;

public class DcmServiceBase
implements DcmService {
    public static final int SUCCESS = 0;
    public static final int PENDING = 65280;
    public static final int NO_SUCH_SOP_CLASS = 280;
    public static final int UNRECOGNIZE_OPERATION = 529;
    public static final DcmService VERIFICATION_SCP = new DcmServiceBase(){

        protected void doCEcho(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws IOException {
            rspCmd.putUS(2304, 0);
        }
    };
    public static final DcmService NO_SUCH_SOP_CLASS_SCP = new DcmServiceBase(new DcmServiceException(280));
    protected static final DcmObjectFactory objFact = DcmObjectFactory.getInstance();
    protected static final AssociationFactory fact = AssociationFactory.getInstance();
    protected static final UIDGenerator uidGen = UIDGenerator.getInstance();
    protected final DcmServiceException defEx;

    public DcmServiceBase(DcmServiceException defEx) {
        this.defEx = defEx;
    }

    public DcmServiceBase() {
        this.defEx = new DcmServiceException(529);
    }

    public void c_store(ActiveAssociation assoc, Dimse rq) throws IOException {
        Command rqCmd = rq.getCommand();
        Command rspCmd = objFact.newCommand();
        rspCmd.initCStoreRSP(rqCmd.getMessageID(), rqCmd.getAffectedSOPClassUID(), rqCmd.getAffectedSOPInstanceUID(), 0);
        try {
            this.doCStore(assoc, rq, rspCmd);
        }
        catch (DcmServiceException e) {
            e.writeTo(rspCmd);
        }
        Dimse rsp = fact.newDimse(rq.pcid(), rspCmd);
        this.doBeforeRsp(assoc, rsp);
        assoc.getAssociation().write(rsp);
        this.doAfterRsp(assoc, rsp);
    }

    public void c_get(ActiveAssociation assoc, Dimse rq) throws IOException {
        Command rqCmd = rq.getCommand();
        Command rspCmd = objFact.newCommand();
        rspCmd.initCGetRSP(rqCmd.getMessageID(), rqCmd.getAffectedSOPClassUID(), 0);
        try {
            this.doMultiRsp(assoc, rq, rspCmd, this.doCGet(assoc, rq, rspCmd));
        }
        catch (DcmServiceException e) {
            e.writeTo(rspCmd);
            Dimse rsp = fact.newDimse(rq.pcid(), rspCmd);
            this.doBeforeRsp(assoc, rsp);
            assoc.getAssociation().write(rsp);
            this.doAfterRsp(assoc, rsp);
        }
    }

    public void c_find(ActiveAssociation assoc, Dimse rq) throws IOException {
        Command rqCmd = rq.getCommand();
        Command rspCmd = objFact.newCommand();
        rspCmd.initCFindRSP(rqCmd.getMessageID(), rqCmd.getAffectedSOPClassUID(), 65280);
        try {
            this.doMultiRsp(assoc, rq, rspCmd, this.doCFind(assoc, rq, rspCmd));
        }
        catch (DcmServiceException e) {
            e.writeTo(rspCmd);
            Dimse rsp = fact.newDimse(rq.pcid(), rspCmd);
            this.doBeforeRsp(assoc, rsp);
            assoc.getAssociation().write(rsp);
            this.doAfterRsp(assoc, rsp);
        }
    }

    public void c_move(ActiveAssociation assoc, Dimse rq) throws IOException {
        Command rqCmd = rq.getCommand();
        Command rspCmd = objFact.newCommand();
        rspCmd.initCMoveRSP(rqCmd.getMessageID(), rqCmd.getAffectedSOPClassUID(), 65280);
        try {
            this.doMultiRsp(assoc, rq, rspCmd, this.doCMove(assoc, rq, rspCmd));
        }
        catch (DcmServiceException e) {
            e.writeTo(rspCmd);
            Dimse rsp = fact.newDimse(rq.pcid(), rspCmd);
            this.doBeforeRsp(assoc, rsp);
            assoc.getAssociation().write(rsp);
            this.doAfterRsp(assoc, rsp);
        }
    }

    public void c_echo(ActiveAssociation assoc, Dimse rq) throws IOException {
        Command rqCmd = rq.getCommand();
        Command rspCmd = objFact.newCommand();
        rspCmd.initCEchoRSP(rqCmd.getMessageID(), rqCmd.getAffectedSOPClassUID(), 0);
        try {
            this.doCEcho(assoc, rq, rspCmd);
        }
        catch (DcmServiceException e) {
            e.writeTo(rspCmd);
        }
        Dimse rsp = fact.newDimse(rq.pcid(), rspCmd);
        this.doBeforeRsp(assoc, rsp);
        assoc.getAssociation().write(rsp);
        this.doAfterRsp(assoc, rsp);
    }

    public void n_event_report(ActiveAssociation assoc, Dimse rq) throws IOException {
        Command rqCmd = rq.getCommand();
        Command rspCmd = objFact.newCommand();
        rspCmd.initNEventReportRSP(rqCmd.getMessageID(), rqCmd.getAffectedSOPClassUID(), rqCmd.getAffectedSOPInstanceUID(), 0);
        Dataset rspData = null;
        try {
            rspData = this.doNEventReport(assoc, rq, rspCmd);
        }
        catch (DcmServiceException e) {
            e.writeTo(rspCmd);
        }
        Dimse rsp = fact.newDimse(rq.pcid(), rspCmd, rspData);
        this.doBeforeRsp(assoc, rsp);
        assoc.getAssociation().write(rsp);
        this.doAfterRsp(assoc, rsp);
    }

    public void n_get(ActiveAssociation assoc, Dimse rq) throws IOException {
        Command rqCmd = rq.getCommand();
        Command rspCmd = objFact.newCommand();
        rspCmd.initNGetRSP(rqCmd.getMessageID(), rqCmd.getRequestedSOPClassUID(), rqCmd.getRequestedSOPInstanceUID(), 0);
        Dataset rspData = null;
        try {
            rspData = this.doNGet(assoc, rq, rspCmd);
        }
        catch (DcmServiceException e) {
            e.writeTo(rspCmd);
        }
        Dimse rsp = fact.newDimse(rq.pcid(), rspCmd, rspData);
        this.doBeforeRsp(assoc, rsp);
        assoc.getAssociation().write(rsp);
        this.doAfterRsp(assoc, rsp);
    }

    public void n_set(ActiveAssociation assoc, Dimse rq) throws IOException {
        Command rqCmd = rq.getCommand();
        Command rspCmd = objFact.newCommand();
        rspCmd.initNSetRSP(rqCmd.getMessageID(), rqCmd.getRequestedSOPClassUID(), rqCmd.getRequestedSOPInstanceUID(), 0);
        Dataset rspData = null;
        try {
            rspData = this.doNSet(assoc, rq, rspCmd);
        }
        catch (DcmServiceException e) {
            e.writeTo(rspCmd);
        }
        Dimse rsp = fact.newDimse(rq.pcid(), rspCmd, rspData);
        this.doBeforeRsp(assoc, rsp);
        assoc.getAssociation().write(rsp);
        this.doAfterRsp(assoc, rsp);
    }

    public void n_action(ActiveAssociation assoc, Dimse rq) throws IOException {
        Command rqCmd = rq.getCommand();
        Command rspCmd = objFact.newCommand();
        rspCmd.initNActionRSP(rqCmd.getMessageID(), rqCmd.getRequestedSOPClassUID(), rqCmd.getRequestedSOPInstanceUID(), 0);
        Dataset rspData = null;
        try {
            rspData = this.doNAction(assoc, rq, rspCmd);
        }
        catch (DcmServiceException e) {
            e.writeTo(rspCmd);
        }
        Dimse rsp = fact.newDimse(rq.pcid(), rspCmd, rspData);
        this.doBeforeRsp(assoc, rsp);
        assoc.getAssociation().write(rsp);
        this.doAfterRsp(assoc, rsp);
    }

    public void n_create(ActiveAssociation assoc, Dimse rq) throws IOException {
        Command rqCmd = rq.getCommand();
        Command rspCmd = objFact.newCommand();
        rspCmd.initNCreateRSP(rqCmd.getMessageID(), rqCmd.getAffectedSOPClassUID(), DcmServiceBase.createUID(rqCmd.getAffectedSOPInstanceUID()), 0);
        Dataset rspData = null;
        try {
            rspData = this.doNCreate(assoc, rq, rspCmd);
        }
        catch (DcmServiceException e) {
            e.writeTo(rspCmd);
        }
        Dimse rsp = fact.newDimse(rq.pcid(), rspCmd, rspData);
        this.doBeforeRsp(assoc, rsp);
        assoc.getAssociation().write(rsp);
        this.doAfterRsp(assoc, rsp);
    }

    public void n_delete(ActiveAssociation assoc, Dimse rq) throws IOException {
        Command rqCmd = rq.getCommand();
        Command rspCmd = objFact.newCommand();
        rspCmd.initNDeleteRSP(rqCmd.getMessageID(), rqCmd.getRequestedSOPClassUID(), rqCmd.getRequestedSOPInstanceUID(), 0);
        Dataset rspData = null;
        try {
            rspData = this.doNDelete(assoc, rq, rspCmd);
        }
        catch (DcmServiceException e) {
            e.writeTo(rspCmd);
        }
        Dimse rsp = fact.newDimse(rq.pcid(), rspCmd, rspData);
        this.doBeforeRsp(assoc, rsp);
        assoc.getAssociation().write(rsp);
        this.doAfterRsp(assoc, rsp);
    }

    protected void doBeforeRsp(ActiveAssociation assoc, Dimse rsp) {
    }

    protected void doAfterRsp(ActiveAssociation assoc, Dimse rsp) {
    }

    protected void doCStore(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws IOException, DcmServiceException {
        rq.getDataset();
        throw this.defEx;
    }

    protected MultiDimseRsp doCGet(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws IOException, DcmServiceException {
        rq.getDataset();
        throw this.defEx;
    }

    protected MultiDimseRsp doCFind(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws IOException, DcmServiceException {
        rq.getDataset();
        throw this.defEx;
    }

    protected MultiDimseRsp doCMove(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws IOException, DcmServiceException {
        rq.getDataset();
        throw this.defEx;
    }

    protected void doCEcho(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws IOException, DcmServiceException {
        throw this.defEx;
    }

    protected Dataset doNEventReport(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws IOException, DcmServiceException {
        rq.getDataset();
        throw this.defEx;
    }

    protected Dataset doNGet(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws IOException, DcmServiceException {
        rq.getDataset();
        throw this.defEx;
    }

    protected Dataset doNSet(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws IOException, DcmServiceException {
        rq.getDataset();
        throw this.defEx;
    }

    protected Dataset doNAction(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws IOException, DcmServiceException {
        rq.getDataset();
        throw this.defEx;
    }

    protected Dataset doNCreate(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws IOException, DcmServiceException {
        rq.getDataset();
        throw this.defEx;
    }

    protected Dataset doNDelete(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws IOException, DcmServiceException {
        rq.getDataset();
        throw this.defEx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doMultiRsp(ActiveAssociation assoc, Dimse rq, Command rspCmd, MultiDimseRsp mdr) throws IOException, DcmServiceException {
        try {
            assoc.addCancelListener(rspCmd.getMessageIDToBeingRespondedTo(), mdr.getCancelListener());
            do {
                Dataset rspData = mdr.next(assoc, rq, rspCmd);
                Dimse rsp = fact.newDimse(rq.pcid(), rspCmd, rspData);
                this.doBeforeRsp(assoc, rsp);
                assoc.getAssociation().write(rsp);
                this.doAfterRsp(assoc, rsp);
            } while (rspCmd.isPending());
        }
        finally {
            mdr.release();
        }
    }

    private static String createUID(String uid) {
        return uid != null ? uid : uidGen.createUID();
    }

    public static interface MultiDimseRsp {
        public DimseListener getCancelListener();

        public Dataset next(ActiveAssociation var1, Dimse var2, Command var3) throws DcmServiceException;

        public void release();
    }
}

