/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.or.ObjectRenderer;
import org.dcm4che.data.Dataset;
import org.dcm4che.util.SystemUtils;

public class DatasetRenderer
implements ObjectRenderer {
    private static Map dumpParam = new Hashtable();
    private static int excludeValueLengthLimit = 128;

    public static Map getDumpParam() {
        return dumpParam;
    }

    public static void setExcludeValueLengthLimit(int limit) {
        excludeValueLengthLimit = limit;
    }

    public String doRender(Object arg0) {
        StringWriter w = new StringWriter();
        try {
            Dataset ds = (Dataset)arg0;
            ds.dumpDataset(w, dumpParam, excludeValueLengthLimit);
            return w.toString();
        }
        catch (Exception e) {
            e.printStackTrace(new PrintWriter(w));
            return "Failed to dump dataset:" + w;
        }
    }

    static {
        String cfg = SystemUtils.getSystemProperty("DatasetRenderer.dumpParam", "128,64,\t,128");
        StringTokenizer st = new StringTokenizer(cfg, ",");
        if (st.hasMoreTokens()) {
            dumpParam.put("maxlen", Integer.valueOf(st.nextToken()));
        }
        if (st.hasMoreTokens()) {
            dumpParam.put("vallen", Integer.valueOf(st.nextToken()));
        }
        if (st.hasMoreTokens()) {
            dumpParam.put("prefix", st.nextToken());
        }
        if (st.hasMoreTokens()) {
            excludeValueLengthLimit = Integer.parseInt(st.nextToken());
        }
    }
}

